/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptions;
/*     */ 
/*     */ @XmlType(name="exclude-listType")
/*     */ public class ExcludeListMetaData extends IdMetaDataImplWithDescriptions
/*     */ {
/*     */   private static final long serialVersionUID = -7505132782235878508L;
/*     */   private MethodsMetaData methods;
/*     */ 
/*     */   public MethodsMetaData getMethods()
/*     */   {
/*  59 */     return this.methods;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="method")
/*     */   public void setMethods(MethodsMetaData methods)
/*     */   {
/*  71 */     if (methods == null)
/*  72 */       throw new IllegalArgumentException("Null methods");
/*  73 */     this.methods = methods;
/*     */   }
/*     */ 
/*     */   public boolean matches(String methodName, Class[] params, MethodInterfaceType interfaceType)
/*     */   {
/*  86 */     if (this.methods == null)
/*  87 */       return false;
/*  88 */     return this.methods.matches(methodName, params, interfaceType);
/*     */   }
/*     */ 
/*     */   public ExcludeListMetaData getExcludeListByEjbName(String ejbName)
/*     */   {
/* 100 */     if (ejbName == null) {
/* 101 */       throw new IllegalArgumentException("Null ejbName");
/*     */     }
/* 103 */     if (this.methods == null) {
/* 104 */       return null;
/*     */     }
/* 106 */     MethodsMetaData ejbMethods = this.methods.getMethodsByEjbName(ejbName);
/* 107 */     if (ejbMethods == null) {
/* 108 */       return null;
/*     */     }
/* 110 */     ExcludeListMetaData result = clone();
/* 111 */     result.setMethods(ejbMethods);
/* 112 */     return result;
/*     */   }
/*     */ 
/*     */   public ExcludeListMetaData clone()
/*     */   {
/* 118 */     return (ExcludeListMetaData)super.clone();
/*     */   }
/*     */ 
/*     */   public void merge(ExcludeListMetaData override, ExcludeListMetaData original)
/*     */   {
/* 123 */     super.merge(override, original);
/*     */ 
/* 127 */     this.methods = new MethodsMetaData();
/* 128 */     this.methods.merge(override != null ? override.methods : null, original != null ? original.methods : null);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.ExcludeListMetaData
 * JD-Core Version:    0.6.0
 */