/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
/*     */ 
/*     */ @XmlType(name="entity-beanType")
/*     */ public class EntityBeanMetaData extends EnterpriseBeanMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 1538890391418490043L;
/*     */   private String home;
/*     */   private String remote;
/*     */   private String localHome;
/*     */   private String local;
/*     */   private PersistenceType persistenceType;
/*     */   private String primKeyClass;
/*     */   private boolean reentrant;
/*     */   private String cmpVersion;
/*     */   private String abstractSchemaName;
/*     */   private CMPFieldsMetaData cmpFields;
/*     */   private String primKeyField;
/*     */   private SecurityRoleRefsMetaData securityRoleRefs;
/*     */   private QueriesMetaData queries;
/*     */ 
/*     */   public boolean isEntity()
/*     */   {
/*  90 */     return true;
/*     */   }
/*     */ 
/*     */   public String getHome()
/*     */   {
/* 100 */     return this.home;
/*     */   }
/*     */ 
/*     */   public void setHome(String home)
/*     */   {
/* 111 */     if (home == null)
/* 112 */       throw new IllegalArgumentException("Null home");
/* 113 */     this.home = home;
/*     */   }
/*     */ 
/*     */   public String getRemote()
/*     */   {
/* 123 */     return this.remote;
/*     */   }
/*     */ 
/*     */   public void setRemote(String remote)
/*     */   {
/* 134 */     if (remote == null)
/* 135 */       throw new IllegalArgumentException("Null remote");
/* 136 */     this.remote = remote;
/*     */   }
/*     */ 
/*     */   public String getLocalHome()
/*     */   {
/* 146 */     return this.localHome;
/*     */   }
/*     */ 
/*     */   public void setLocalHome(String localHome)
/*     */   {
/* 157 */     if (localHome == null)
/* 158 */       throw new IllegalArgumentException("Null localHome");
/* 159 */     this.localHome = localHome;
/*     */   }
/*     */ 
/*     */   public String getLocal()
/*     */   {
/* 169 */     return this.local;
/*     */   }
/*     */ 
/*     */   public void setLocal(String local)
/*     */   {
/* 180 */     if (local == null)
/* 181 */       throw new IllegalArgumentException("Null local");
/* 182 */     this.local = local;
/*     */   }
/*     */ 
/*     */   public boolean isCMP()
/*     */   {
/* 192 */     if (this.persistenceType == null)
/* 193 */       return true;
/* 194 */     return this.persistenceType == PersistenceType.Container;
/*     */   }
/*     */ 
/*     */   public boolean isBMP()
/*     */   {
/* 204 */     return !isCMP();
/*     */   }
/*     */ 
/*     */   public PersistenceType getPersistenceType()
/*     */   {
/* 214 */     return this.persistenceType;
/*     */   }
/*     */ 
/*     */   public void setPersistenceType(PersistenceType persistenceType)
/*     */   {
/* 225 */     if (persistenceType == null)
/* 226 */       throw new IllegalArgumentException("Null persistenceType");
/* 227 */     this.persistenceType = persistenceType;
/*     */   }
/*     */ 
/*     */   public String getPrimKeyClass()
/*     */   {
/* 237 */     return this.primKeyClass;
/*     */   }
/*     */ 
/*     */   public void setPrimKeyClass(String primKeyClass)
/*     */   {
/* 248 */     if (primKeyClass == null)
/* 249 */       throw new IllegalArgumentException("Null primKeyClass");
/* 250 */     this.primKeyClass = primKeyClass;
/*     */   }
/*     */ 
/*     */   public boolean isReentrant()
/*     */   {
/* 260 */     return this.reentrant;
/*     */   }
/*     */ 
/*     */   public void setReentrant(boolean reentrant)
/*     */   {
/* 270 */     this.reentrant = reentrant;
/*     */   }
/*     */ 
/*     */   public boolean isCMP1x()
/*     */   {
/* 280 */     if (this.cmpVersion == null)
/*     */     {
/* 283 */       return (!getEjbJarMetaData().isEJB2x()) && (!getEjbJarMetaData().isEJB3x());
/*     */     }
/*     */ 
/* 287 */     return "1.x".equals(this.cmpVersion);
/*     */   }
/*     */ 
/*     */   public String getCmpVersion()
/*     */   {
/* 297 */     return this.cmpVersion;
/*     */   }
/*     */ 
/*     */   public void setCmpVersion(String cmpVersion)
/*     */   {
/* 308 */     if (cmpVersion == null)
/* 309 */       throw new IllegalArgumentException("Null cmpVersion");
/* 310 */     this.cmpVersion = cmpVersion;
/*     */   }
/*     */ 
/*     */   public String getAbstractSchemaName()
/*     */   {
/* 320 */     return this.abstractSchemaName;
/*     */   }
/*     */ 
/*     */   public void setAbstractSchemaName(String abstractSchemaName)
/*     */   {
/* 331 */     if (abstractSchemaName == null)
/* 332 */       throw new IllegalArgumentException("Null abstractSchemaName");
/* 333 */     this.abstractSchemaName = abstractSchemaName;
/*     */   }
/*     */ 
/*     */   public String getPrimKeyField()
/*     */   {
/* 343 */     return this.primKeyField;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="primkey-field")
/*     */   public void setPrimKeyField(String primKeyField)
/*     */   {
/* 355 */     if (primKeyField == null)
/* 356 */       throw new IllegalArgumentException("Null primKeyField");
/* 357 */     this.primKeyField = primKeyField;
/*     */   }
/*     */ 
/*     */   public CMPFieldsMetaData getCmpFields()
/*     */   {
/* 367 */     return this.cmpFields;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="cmp-field")
/*     */   public void setCmpFields(CMPFieldsMetaData cmpFields)
/*     */   {
/* 379 */     if (cmpFields == null)
/* 380 */       throw new IllegalArgumentException("Null cmpFields");
/* 381 */     this.cmpFields = cmpFields;
/*     */   }
/*     */ 
/*     */   public SecurityRoleRefsMetaData getSecurityRoleRefs()
/*     */   {
/* 391 */     return this.securityRoleRefs;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="security-role-ref")
/*     */   public void setSecurityRoleRefs(SecurityRoleRefsMetaData securityRoleRefs)
/*     */   {
/* 403 */     if (securityRoleRefs == null)
/* 404 */       throw new IllegalArgumentException("Null securityRoleRefs");
/* 405 */     this.securityRoleRefs = securityRoleRefs;
/*     */   }
/*     */ 
/*     */   public QueriesMetaData getQueries()
/*     */   {
/* 415 */     return this.queries;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="query")
/*     */   public void setQueries(QueriesMetaData queries)
/*     */   {
/* 427 */     if (queries == null)
/* 428 */       throw new IllegalArgumentException("Null queries");
/* 429 */     this.queries = queries;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.EntityBeanMetaData
 * JD-Core Version:    0.6.0
 */