/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import org.jboss.metadata.common.ejb.IEjbJarMetaData;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptionGroup;
/*     */ 
/*     */ public abstract class EjbJarMetaData extends IdMetaDataImplWithDescriptionGroup
/*     */   implements IEjbJarMetaData<AssemblyDescriptorMetaData, EnterpriseBeansMetaData, EnterpriseBeanMetaData, EjbJarMetaData>
/*     */ {
/*     */   private static final long serialVersionUID = 809339942454480150L;
/*     */   private String dtdPublicId;
/*     */   private String dtdSystemId;
/*     */   private String version;
/*     */   private String ejbClientJar;
/*     */   private EnterpriseBeansMetaData enterpriseBeans;
/*     */   private RelationsMetaData relationships;
/*     */   private AssemblyDescriptorMetaData assemblyDescriptor;
/*     */ 
/*     */   @XmlTransient
/*     */   public void setDTD(String root, String publicId, String systemId)
/*     */   {
/*  76 */     this.dtdPublicId = publicId;
/*  77 */     this.dtdSystemId = systemId;
/*     */ 
/*  79 */     if (publicId != null)
/*     */     {
/*  81 */       if (publicId.contains("2.0"))
/*  82 */         setVersion("2.0");
/*  83 */       if (publicId.contains("1.1"))
/*  84 */         setVersion("1.1");
/*     */     }
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDtdPublicId()
/*     */   {
/*  95 */     return this.dtdPublicId;
/*     */   }
/*     */ 
/*     */   @XmlTransient
/*     */   public String getDtdSystemId()
/*     */   {
/* 104 */     return this.dtdSystemId;
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/* 114 */     return this.version;
/*     */   }
/*     */ 
/*     */   public void setVersion(String version)
/*     */   {
/* 125 */     if (version == null)
/* 126 */       throw new IllegalArgumentException("Null version");
/* 127 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public boolean isEJB1x()
/*     */   {
/* 137 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isEJB2x()
/*     */   {
/* 147 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isEJB21()
/*     */   {
/* 157 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isEJB3x()
/*     */   {
/* 167 */     return false;
/*     */   }
/*     */ 
/*     */   public String getEjbClientJar()
/*     */   {
/* 177 */     return this.ejbClientJar;
/*     */   }
/*     */ 
/*     */   public void setEjbClientJar(String ejbClientJar)
/*     */   {
/* 188 */     if (ejbClientJar == null)
/* 189 */       throw new IllegalArgumentException("Null ejbClientJar");
/* 190 */     this.ejbClientJar = ejbClientJar;
/*     */   }
/*     */ 
/*     */   public EnterpriseBeansMetaData getEnterpriseBeans()
/*     */   {
/* 200 */     return this.enterpriseBeans;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="enterprise-beans")
/*     */   public void setEnterpriseBeans(EnterpriseBeansMetaData enterpriseBeans)
/*     */   {
/* 212 */     if (enterpriseBeans == null)
/* 213 */       throw new IllegalArgumentException("Null enterpriseBeans");
/* 214 */     this.enterpriseBeans = enterpriseBeans;
/* 215 */     enterpriseBeans.setEjbJarMetaData(this);
/*     */   }
/*     */ 
/*     */   public EnterpriseBeanMetaData getEnterpriseBean(String name)
/*     */   {
/* 220 */     return (EnterpriseBeanMetaData)this.enterpriseBeans.get(name);
/*     */   }
/*     */ 
/*     */   public RelationsMetaData getRelationships()
/*     */   {
/* 230 */     return this.relationships;
/*     */   }
/*     */ 
/*     */   public void setRelationships(RelationsMetaData relationships)
/*     */   {
/* 241 */     if (relationships == null)
/* 242 */       throw new IllegalArgumentException("Null relationships");
/* 243 */     this.relationships = relationships;
/*     */   }
/*     */ 
/*     */   public AssemblyDescriptorMetaData getAssemblyDescriptor()
/*     */   {
/* 253 */     return this.assemblyDescriptor;
/*     */   }
/*     */ 
/*     */   public void setAssemblyDescriptor(AssemblyDescriptorMetaData assemblyDescriptor)
/*     */   {
/* 264 */     if (assemblyDescriptor == null)
/* 265 */       throw new IllegalArgumentException("Null assemblyDescriptor");
/* 266 */     this.assemblyDescriptor = assemblyDescriptor;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.EjbJarMetaData
 * JD-Core Version:    0.6.0
 */