/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import javax.ejb.TransactionAttributeType;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
/*     */ import org.jboss.metadata.javaee.spec.TransactionAttributeTypeAdapter;
/*     */ import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptions;
/*     */ 
/*     */ @XmlType(name="container-transactionType")
/*     */ public class ContainerTransactionMetaData extends IdMetaDataImplWithDescriptions
/*     */ {
/*     */   private static final long serialVersionUID = -8080829946285127796L;
/*     */   private MethodsMetaData methods;
/*     */   private TransactionAttributeType transAttribute;
/*     */ 
/*     */   public MethodsMetaData getMethods()
/*     */   {
/*  64 */     return this.methods;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="method")
/*     */   public void setMethods(MethodsMetaData methods)
/*     */   {
/*  76 */     if (methods == null)
/*  77 */       throw new IllegalArgumentException("Null methods");
/*  78 */     this.methods = methods;
/*     */   }
/*     */ 
/*     */   @XmlElement(name="trans-attribute")
/*     */   public TransactionAttributeType getTransAttribute()
/*     */   {
/*  89 */     return this.transAttribute;
/*     */   }
/*     */ 
/*     */   @XmlJavaTypeAdapter(TransactionAttributeTypeAdapter.class)
/*     */   public void setTransAttribute(TransactionAttributeType transactionAttribute)
/*     */   {
/* 101 */     if (transactionAttribute == null)
/* 102 */       throw new IllegalArgumentException("Null transactionAttribute");
/* 103 */     this.transAttribute = transactionAttribute;
/*     */   }
/*     */ 
/*     */   public ContainerTransactionMetaData getContainerTransactionsByEjbName(String ejbName)
/*     */   {
/* 115 */     if (ejbName == null) {
/* 116 */       throw new IllegalArgumentException("Null ejbName");
/*     */     }
/* 118 */     if (this.methods == null) {
/* 119 */       return null;
/*     */     }
/* 121 */     MethodsMetaData ejbMethods = this.methods.getMethodsByEjbName(ejbName);
/* 122 */     if (ejbMethods == null) {
/* 123 */       return null;
/*     */     }
/* 125 */     ContainerTransactionMetaData result = clone();
/* 126 */     result.setMethods(ejbMethods);
/* 127 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean matches(String methodName, Class[] params, MethodInterfaceType interfaceType)
/*     */   {
/* 140 */     if (this.methods == null)
/* 141 */       return false;
/* 142 */     return this.methods.matches(methodName, params, interfaceType);
/*     */   }
/*     */ 
/*     */   public MethodMetaData bestMatch(String methodName, Class[] params, MethodInterfaceType interfaceType, MethodMetaData bestMatch)
/*     */   {
/* 156 */     if (this.methods == null)
/* 157 */       return bestMatch;
/* 158 */     return this.methods.bestMatch(methodName, params, interfaceType, bestMatch);
/*     */   }
/*     */ 
/*     */   public ContainerTransactionMetaData clone()
/*     */   {
/* 164 */     return (ContainerTransactionMetaData)super.clone();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.ContainerTransactionMetaData
 * JD-Core Version:    0.6.0
 */