/*     */ package org.jboss.metadata.ejb.spec;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ 
/*     */ public class AnnotationMergedView
/*     */ {
/*     */   public static void merge(EjbJar3xMetaData merged, EjbJar3xMetaData xml, EjbJar3xMetaData annotation)
/*     */   {
/*  38 */     EnterpriseBeansMetaData enterpriseBeans = new EnterpriseBeansMetaData();
/*  39 */     merge(enterpriseBeans, xml.getEnterpriseBeans(), annotation.getEnterpriseBeans());
/*  40 */     merged.setEnterpriseBeans(enterpriseBeans);
/*     */ 
/*  42 */     AssemblyDescriptorMetaData assemblyDescriptor = new AssemblyDescriptorMetaData();
/*  43 */     merge(assemblyDescriptor, xml.getAssemblyDescriptor(), annotation.getAssemblyDescriptor());
/*  44 */     merged.setAssemblyDescriptor(assemblyDescriptor);
/*     */ 
/*  46 */     if (xml.getDescriptionGroup() != null) {
/*  47 */       merged.setDescriptionGroup(xml.getDescriptionGroup());
/*     */     }
/*  49 */     merged.setDTD(null, xml.getDtdPublicId(), xml.getDtdSystemId());
/*     */ 
/*  51 */     if (xml.getEjbClientJar() != null) {
/*  52 */       merged.setEjbClientJar(xml.getEjbClientJar());
/*     */     }
/*  54 */     if (xml.getId() != null) {
/*  55 */       merged.setId(xml.getId());
/*     */     }
/*  57 */     if (xml.getRelationships() != null) {
/*  58 */       merged.setRelationships(xml.getRelationships());
/*     */     }
/*  60 */     if (xml.getVersion() != null)
/*  61 */       merged.setVersion(xml.getVersion());
/*  62 */     merged.setMetadataComplete(xml.isMetadataComplete());
/*  63 */     if ((xml.getInterceptors() != null) || (annotation.getInterceptors() != null))
/*     */     {
/*  65 */       InterceptorsMetaData interceptors = new InterceptorsMetaData();
/*  66 */       interceptors.merge(xml.getInterceptors(), annotation.getInterceptors());
/*  67 */       merged.setInterceptors(interceptors);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void merge(AssemblyDescriptorMetaData merged, AssemblyDescriptorMetaData xml, AssemblyDescriptorMetaData annotation)
/*     */   {
/*  74 */     merged.merge(xml, annotation);
/*     */   }
/*     */ 
/*     */   private static void merge(EnterpriseBeansMetaData merged, EnterpriseBeansMetaData xml, EnterpriseBeansMetaData annotation)
/*     */   {
/*  87 */     HashMap ejbClassToName = new HashMap();
/*  88 */     if (xml != null)
/*     */     {
/*  90 */       if (xml.getId() != null)
/*  91 */         merged.setId(xml.getId());
/*  92 */       for (EnterpriseBeanMetaData bean : xml)
/*     */       {
/*  94 */         String className = bean.getEjbClass();
/*  95 */         if (className != null)
/*     */         {
/*  98 */           int dot = className.lastIndexOf('.');
/*  99 */           if (dot >= 0)
/* 100 */             className = className.substring(dot + 1);
/* 101 */           ejbClassToName.put(className, bean.getEjbName());
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 106 */     HashSet names = new HashSet();
/* 107 */     if (annotation != null)
/*     */     {
/* 109 */       for (EnterpriseBeanMetaData bean : annotation)
/*     */       {
/* 112 */         EnterpriseBeanMetaData match = null;
/* 113 */         if (xml != null)
/*     */         {
/* 115 */           String ejbName = bean.getEjbName();
/* 116 */           match = (EnterpriseBeanMetaData)xml.get(ejbName);
/* 117 */           if (match == null)
/*     */           {
/* 120 */             String name = (String)ejbClassToName.get(ejbName);
/* 121 */             if (name == null)
/*     */             {
/* 123 */               names.add(ejbName);
/* 124 */               merged.add(bean);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 131 */     if (xml != null)
/*     */     {
/* 133 */       for (EnterpriseBeanMetaData bean : xml)
/*     */       {
/* 135 */         EnterpriseBeanMetaData annBean = null;
/* 136 */         if (annotation != null)
/*     */         {
/* 138 */           String name = bean.getEjbName();
/* 139 */           annBean = (EnterpriseBeanMetaData)annotation.get(name);
/* 140 */           if (annBean == null)
/*     */           {
/* 143 */             String className = bean.getEjbClass();
/* 144 */             if (className != null)
/*     */             {
/* 147 */               int dot = className.lastIndexOf('.');
/* 148 */               if (dot >= 0)
/* 149 */                 className = className.substring(dot + 1);
/* 150 */               annBean = (EnterpriseBeanMetaData)annotation.get(className);
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/* 155 */         EnterpriseBeanMetaData mbean = bean;
/* 156 */         if (annBean != null)
/*     */         {
/* 158 */           mbean = EnterpriseBeanMetaData.newBean(bean);
/* 159 */           mbean.merge(bean, annBean);
/*     */         }
/* 161 */         merged.add(mbean);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.spec.AnnotationMergedView
 * JD-Core Version:    0.6.0
 */