/*     */ package org.jboss.metadata.ejb.jboss;
/*     */ 
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.metadata.javaee.support.AbstractMappedMetaData;
/*     */ import org.jboss.xb.annotations.JBossXmlChild;
/*     */ 
/*     */ @XmlType(name="method-attributesType")
/*     */ @JBossXmlChild(name="method", type=MethodAttributeMetaData.class, unbounded=true)
/*     */ public class MethodAttributesMetaData extends AbstractMappedMetaData<MethodAttributeMetaData>
/*     */ {
/*     */   private static final long serialVersionUID = 4074287842839442989L;
/*     */   private transient ConcurrentHashMap<String, MethodAttributeMetaData> cache;
/*     */ 
/*     */   public MethodAttributesMetaData()
/*     */   {
/*  46 */     super("method-name for method attributes");
/*     */   }
/*     */ 
/*     */   public boolean isMethodReadOnly(String methodName)
/*     */   {
/*  57 */     MethodAttributeMetaData attribute = getMethodAttribute(methodName);
/*  58 */     return attribute.isReadOnly();
/*     */   }
/*     */ 
/*     */   public int getMethodTransactionTimeout(String methodName)
/*     */   {
/*  69 */     MethodAttributeMetaData attribute = getMethodAttribute(methodName);
/*  70 */     return attribute.getTransactionTimeout();
/*     */   }
/*     */ 
/*     */   public MethodAttributeMetaData getMethodAttribute(String methodName)
/*     */   {
/*  81 */     if (methodName == null) {
/*  82 */       return MethodAttributeMetaData.DEFAULT;
/*     */     }
/*  84 */     MethodAttributeMetaData result = null;
/*  85 */     if (this.cache != null)
/*     */     {
/*  87 */       result = (MethodAttributeMetaData)this.cache.get(methodName);
/*  88 */       if (result != null) {
/*  89 */         return result;
/*     */       }
/*     */     }
/*  92 */     for (MethodAttributeMetaData attribute : this)
/*     */     {
/*  94 */       if (attribute.matches(methodName))
/*     */       {
/*  96 */         result = attribute;
/*  97 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 101 */     if (result == null) {
/* 102 */       result = MethodAttributeMetaData.DEFAULT;
/*     */     }
/* 104 */     if (this.cache == null)
/* 105 */       this.cache = new ConcurrentHashMap();
/* 106 */     this.cache.put(methodName, result);
/*     */ 
/* 108 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.jboss.MethodAttributesMetaData
 * JD-Core Version:    0.6.0
 */