/*     */ package org.jboss.metadata.ejb.jboss;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import org.jboss.annotation.javaee.Descriptions;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class ContainerConfigurationMetaDataWrapper extends ContainerConfigurationMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private transient ContainerConfigurationMetaData primary;
/*     */   private transient ContainerConfigurationMetaData defaults;
/*     */ 
/*     */   ContainerConfigurationMetaDataWrapper(ContainerConfigurationMetaData primary, ContainerConfigurationMetaData defaults)
/*     */   {
/*  43 */     this.primary = primary;
/*  44 */     this.defaults = defaults;
/*     */   }
/*     */ 
/*     */   public Descriptions getDescriptions()
/*     */   {
/*  50 */     return this.primary.getDescriptions();
/*     */   }
/*     */ 
/*     */   public String getKey()
/*     */   {
/*  56 */     return this.primary.getKey();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  62 */     return this.primary.getName();
/*     */   }
/*     */ 
/*     */   public String getId()
/*     */   {
/*  68 */     return this.primary.getId();
/*     */   }
/*     */ 
/*     */   public ClusterConfigMetaData getClusterConfig()
/*     */   {
/*  74 */     ClusterConfigMetaData md = this.primary.getClusterConfig();
/*  75 */     if ((md == null) && (this.defaults != null))
/*     */     {
/*  77 */       md = this.defaults.getClusterConfig();
/*     */     }
/*  79 */     else if (this.defaults != null)
/*     */     {
/*  81 */       md = new ClusterConfigMetaData();
/*  82 */       md.merge(this.primary.getClusterConfig(), this.defaults.getClusterConfig());
/*     */     }
/*  84 */     return md;
/*     */   }
/*     */ 
/*     */   public CommitOption getCommitOption()
/*     */   {
/*  90 */     CommitOption co = this.defaults != null ? this.defaults.getCommitOption() : CommitOption.A;
/*  91 */     if (this.primary.commitOptionWasSet())
/*  92 */       co = this.primary.getCommitOption();
/*  93 */     return co;
/*     */   }
/*     */ 
/*     */   public Element getContainerCacheConf()
/*     */   {
/*  99 */     Element conf = this.primary.getContainerCacheConf();
/* 100 */     if ((conf == null) && (this.defaults != null))
/* 101 */       conf = this.defaults.getContainerCacheConf();
/* 102 */     return conf;
/*     */   }
/*     */ 
/*     */   public Element getContainerInterceptors()
/*     */   {
/* 108 */     Element conf = this.primary.getContainerInterceptors();
/* 109 */     if ((conf == null) && (this.defaults != null))
/* 110 */       conf = this.defaults.getContainerInterceptors();
/* 111 */     return conf;
/*     */   }
/*     */ 
/*     */   public String getContainerName()
/*     */   {
/* 117 */     return this.primary.getContainerName();
/*     */   }
/*     */ 
/*     */   public Element getContainerPoolConf()
/*     */   {
/* 123 */     Element conf = this.primary.getContainerPoolConf();
/* 124 */     if ((conf == null) && (this.defaults != null))
/* 125 */       conf = this.defaults.getContainerPoolConf();
/* 126 */     return conf;
/*     */   }
/*     */ 
/*     */   public String getDefaultInvokerName()
/*     */   {
/* 132 */     String name = this.primary.getDefaultInvokerName();
/* 133 */     if ((name == null) && (this.defaults != null))
/* 134 */       name = this.defaults.getDefaultInvokerName();
/* 135 */     if (name == null)
/* 136 */       throw new IllegalStateException("No invokers defined");
/* 137 */     return name;
/*     */   }
/*     */ 
/*     */   public Set<String> getDepends()
/*     */   {
/* 143 */     HashSet depends = new HashSet();
/* 144 */     if (this.primary.getDepends() != null)
/* 145 */       depends.addAll(this.primary.getDepends());
/* 146 */     if ((this.defaults != null) && (this.defaults.getDepends() != null))
/* 147 */       depends.addAll(this.defaults.getDepends());
/* 148 */     return depends;
/*     */   }
/*     */ 
/*     */   public String getExtendsName()
/*     */   {
/* 154 */     return this.primary.getExtendsName();
/*     */   }
/*     */ 
/*     */   public String getInstanceCache()
/*     */   {
/* 160 */     String name = this.primary.getInstanceCache();
/* 161 */     if ((name == null) && (this.defaults != null))
/* 162 */       name = this.defaults.getInstanceCache();
/* 163 */     return name;
/*     */   }
/*     */ 
/*     */   public String getInstancePool()
/*     */   {
/* 169 */     String name = this.primary.getInstancePool();
/* 170 */     if ((name == null) && (this.defaults != null))
/* 171 */       name = this.defaults.getInstancePool();
/* 172 */     return name;
/*     */   }
/*     */ 
/*     */   public Set<String> getInvokerProxyBindingNames()
/*     */   {
/* 178 */     Set names = this.primary.getInvokerProxyBindingNames();
/* 179 */     if (((names == null) || (names.isEmpty())) && (this.defaults != null))
/* 180 */       names = this.defaults.getInvokerProxyBindingNames();
/* 181 */     return names;
/*     */   }
/*     */ 
/*     */   public String getLockingPolicy()
/*     */   {
/* 187 */     String name = this.primary.getLockingPolicy();
/* 188 */     if ((name == null) && (this.defaults != null))
/* 189 */       name = this.defaults.getLockingPolicy();
/* 190 */     if (name == null)
/* 191 */       name = "org.jboss.ejb.plugins.lock.QueuedPessimisticEJBLock";
/* 192 */     return name;
/*     */   }
/*     */ 
/*     */   public int getOptiondRefreshRate()
/*     */   {
/* 198 */     int rate = (int)getOptiondRefreshRateMillis() / 1000;
/* 199 */     return rate;
/*     */   }
/*     */ 
/*     */   public long getOptiondRefreshRateMillis()
/*     */   {
/* 205 */     long rate = this.primary.getOptiondRefreshRateMillis();
/* 206 */     if ((rate <= 0L) && (this.defaults != null))
/* 207 */       rate = this.defaults.getOptiondRefreshRateMillis();
/* 208 */     if (rate <= 0L)
/* 209 */       rate = 30000L;
/* 210 */     return rate;
/*     */   }
/*     */ 
/*     */   public String getPersistenceManager()
/*     */   {
/* 216 */     String name = this.primary.getPersistenceManager();
/* 217 */     if ((name == null) && (this.defaults != null))
/* 218 */       name = this.defaults.getPersistenceManager();
/* 219 */     return name;
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 225 */     String name = this.primary.getSecurityDomain();
/* 226 */     if ((name == null) && (this.defaults != null))
/* 227 */       name = this.defaults.getSecurityDomain();
/* 228 */     return name;
/*     */   }
/*     */ 
/*     */   public String getWebClassLoader()
/*     */   {
/* 234 */     String name = this.primary.getWebClassLoader();
/* 235 */     if ((name == null) && (this.defaults != null))
/* 236 */       name = this.defaults.getWebClassLoader();
/* 237 */     if (name == null)
/* 238 */       name = "org.jboss.web.WebClassLoader";
/* 239 */     return name;
/*     */   }
/*     */ 
/*     */   public boolean isCallLogging()
/*     */   {
/* 245 */     boolean flag = this.defaults != null ? this.defaults.isCallLogging() : false;
/* 246 */     if (this.primary.callLoggingWasSet())
/* 247 */       flag = this.primary.isCallLogging();
/* 248 */     return flag;
/*     */   }
/*     */ 
/*     */   public boolean isEjbStoreOnClean()
/*     */   {
/* 254 */     boolean flag = this.defaults != null ? this.defaults.isEjbStoreOnClean() : false;
/* 255 */     if (this.primary.ejbStoreOnCleanWasSet())
/* 256 */       flag = this.primary.isEjbStoreOnClean();
/* 257 */     return flag;
/*     */   }
/*     */ 
/*     */   public boolean isInsertAfterEjbPostCreate()
/*     */   {
/* 263 */     boolean flag = this.defaults != null ? this.defaults.isInsertAfterEjbPostCreate() : false;
/* 264 */     if (this.primary.insertAfterEjbPostCreateWasSet())
/* 265 */       flag = this.primary.isInsertAfterEjbPostCreate();
/* 266 */     return flag;
/*     */   }
/*     */ 
/*     */   public boolean isStoreNotFlushed()
/*     */   {
/* 272 */     boolean flag = this.defaults != null ? this.defaults.isStoreNotFlushed() : true;
/* 273 */     if (this.primary.storeNotFlushedWasSet())
/* 274 */       flag = this.primary.isStoreNotFlushed();
/* 275 */     return flag;
/*     */   }
/*     */ 
/*     */   public boolean isSyncOnCommitOnly()
/*     */   {
/* 281 */     boolean flag = this.defaults != null ? this.defaults.isSyncOnCommitOnly() : false;
/* 282 */     if (this.primary.syncOnCommitOnlyWasSet())
/* 283 */       flag = this.primary.isSyncOnCommitOnly();
/* 284 */     return flag;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.ejb.jboss.ContainerConfigurationMetaDataWrapper
 * JD-Core Version:    0.6.0
 */