/*    */ package org.jboss.metadata.annotation.creator.web;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import java.util.ArrayList;
/*    */ import java.util.Collection;
/*    */ import java.util.Iterator;
/*    */ import java.util.List;
/*    */ import org.jboss.metadata.annotation.creator.AbstractFinderUser;
/*    */ import org.jboss.metadata.annotation.creator.Creator;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.web.spec.Web25MetaData;
/*    */ import org.jboss.metadata.web.spec.WebMetaData;
/*    */ 
/*    */ public class Web25MetaDataCreator extends AbstractFinderUser
/*    */   implements Creator<Collection<Class<?>>, Web25MetaData>
/*    */ {
/*    */   private List<Processor<WebMetaData, Class<?>>> processors;
/*    */ 
/*    */   public Web25MetaDataCreator(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 53 */     super(finder);
/*    */ 
/* 55 */     this.processors = new ArrayList();
/* 56 */     this.processors.add(new WebComponentProcessor(finder));
/*    */   }
/*    */ 
/*    */   public Web25MetaData create(Collection<Class<?>> classes)
/*    */   {
/* 61 */     Web25MetaData metaData = new Web25MetaData();
/* 62 */     metaData.setVersion("2.5");
/*    */ 
/* 64 */     for (Iterator i$ = classes.iterator(); i$.hasNext(); ) { cls = (Class)i$.next();
/*    */ 
/* 66 */       for (Processor processor : this.processors)
/*    */       {
/* 68 */         processor.process(metaData, cls);
/*    */       }
/*    */     }
/*    */     Class cls;
/* 72 */     return metaData;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.web.Web25MetaDataCreator
 * JD-Core Version:    0.6.0
 */