/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import javax.ejb.Stateless;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
/*    */ import org.jboss.metadata.ejb.spec.SessionType;
/*    */ 
/*    */ public class StatelessProcessor extends AbstractSessionBeanProcessor
/*    */ {
/*    */   public StatelessProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 42 */     super(finder);
/*    */   }
/*    */ 
/*    */   public SessionBeanMetaData create(Class<?> beanClass)
/*    */   {
/* 47 */     Stateless annotation = (Stateless)this.finder.getAnnotation(beanClass, Stateless.class);
/* 48 */     if (annotation == null) {
/* 49 */       return null;
/*    */     }
/* 51 */     SessionBeanMetaData beanMetaData = create(beanClass, annotation);
/* 52 */     beanMetaData.setSessionType(SessionType.Stateless);
/* 53 */     return beanMetaData;
/*    */   }
/*    */ 
/*    */   protected SessionBeanMetaData create(Class<?> beanClass, Stateless annotation)
/*    */   {
/* 58 */     return create(beanClass, annotation.name(), annotation.mappedName(), annotation.description());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.StatelessProcessor
 * JD-Core Version:    0.6.0
 */