/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import javax.ejb.EJBObject;
/*    */ import javax.ejb.Remote;
/*    */ import org.jboss.metadata.annotation.creator.AbstractFinderUser;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
/*    */ import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
/*    */ import org.jboss.metadata.lang.ClassHelper;
/*    */ 
/*    */ public class RemoteProcessor extends AbstractFinderUser
/*    */   implements Processor<SessionBeanMetaData, Class<?>>
/*    */ {
/*    */   public RemoteProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 46 */     super(finder);
/*    */   }
/*    */ 
/*    */   protected void addBusinessInterface(SessionBeanMetaData metaData, Class<?> businessInterface)
/*    */   {
/* 53 */     if (EJBObject.class.isAssignableFrom(businessInterface))
/*    */     {
/* 55 */       if (metaData.getRemote() != null)
/* 56 */         throw new IllegalArgumentException("2.1 bean " + metaData.getEjbName() + " already has a remote interface " + metaData.getRemote() + ", can't add " + businessInterface.getName());
/* 57 */       metaData.setRemote(businessInterface.getName());
/*    */     }
/*    */     else
/*    */     {
/* 61 */       if (metaData.getBusinessRemotes() == null) {
/* 62 */         metaData.setBusinessRemotes(new BusinessRemotesMetaData());
/*    */       }
/* 64 */       metaData.getBusinessRemotes().add(businessInterface.getName());
/*    */     }
/*    */   }
/*    */ 
/*    */   public void process(SessionBeanMetaData metaData, Class<?> type)
/*    */   {
/* 70 */     Remote remote = (Remote)this.finder.getAnnotation(type, Remote.class);
/* 71 */     if (remote == null) {
/* 72 */       return;
/*    */     }
/* 74 */     if (type.isInterface())
/*    */     {
/* 76 */       addBusinessInterface(metaData, type);
/*    */     }
/* 80 */     else if ((remote.value() == null) || (remote.value().length == 0))
/*    */     {
/* 82 */       Class businessInterface = ClassHelper.getDefaultInterface(type);
/* 83 */       addBusinessInterface(metaData, businessInterface);
/*    */     }
/*    */     else
/*    */     {
/* 87 */       for (Class businessInterface : remote.value())
/*    */       {
/* 89 */         addBusinessInterface(metaData, businessInterface);
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.RemoteProcessor
 * JD-Core Version:    0.6.0
 */