/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import java.lang.reflect.Method;
/*    */ import javax.ejb.PostActivate;
/*    */ import org.jboss.metadata.annotation.creator.AbstractLifeCycleMethodProcessor;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
/*    */ import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
/*    */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*    */ 
/*    */ public class PostActivateMethodProcessor extends AbstractLifeCycleMethodProcessor
/*    */   implements Processor<SessionBeanMetaData, Method>
/*    */ {
/*    */   public PostActivateMethodProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 52 */     super(finder);
/*    */   }
/*    */ 
/*    */   public void process(SessionBeanMetaData metaData, Method element)
/*    */   {
/* 57 */     PostActivate annotation = (PostActivate)this.finder.getAnnotation(element, PostActivate.class);
/* 58 */     if (annotation == null) {
/* 59 */       return;
/*    */     }
/* 61 */     LifecycleCallbackMetaData callback = super.create(element);
/* 62 */     LifecycleCallbacksMetaData preDestroys = metaData.getPostActivates();
/* 63 */     if (preDestroys == null)
/*    */     {
/* 65 */       preDestroys = new LifecycleCallbacksMetaData();
/* 66 */       metaData.setPostActivates(preDestroys);
/*    */     }
/* 68 */     preDestroys.add(callback);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.PostActivateMethodProcessor
 * JD-Core Version:    0.6.0
 */