/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import javax.ejb.EJBLocalObject;
/*    */ import javax.ejb.Local;
/*    */ import org.jboss.metadata.annotation.creator.AbstractFinderUser;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
/*    */ import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
/*    */ import org.jboss.metadata.lang.ClassHelper;
/*    */ 
/*    */ public class LocalProcessor extends AbstractFinderUser
/*    */   implements Processor<SessionBeanMetaData, Class<?>>
/*    */ {
/*    */   public LocalProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 46 */     super(finder);
/*    */   }
/*    */ 
/*    */   protected void addBusinessInterface(SessionBeanMetaData metaData, Class<?> businessInterface)
/*    */   {
/* 53 */     if (EJBLocalObject.class.isAssignableFrom(businessInterface))
/*    */     {
/* 55 */       if (metaData.getLocal() != null)
/* 56 */         throw new IllegalArgumentException("2.1 bean " + metaData.getEjbName() + " already has a local interface " + metaData.getLocal() + ", can't add " + businessInterface.getName());
/* 57 */       metaData.setLocal(businessInterface.getName());
/*    */     }
/*    */     else
/*    */     {
/* 61 */       if (metaData.getBusinessLocals() == null) {
/* 62 */         metaData.setBusinessLocals(new BusinessLocalsMetaData());
/*    */       }
/* 64 */       metaData.getBusinessLocals().add(businessInterface.getName());
/*    */     }
/*    */   }
/*    */ 
/*    */   public void process(SessionBeanMetaData metaData, Class<?> type)
/*    */   {
/* 70 */     Local local = (Local)this.finder.getAnnotation(type, Local.class);
/* 71 */     if (local == null) {
/* 72 */       return;
/*    */     }
/* 74 */     if (type.isInterface())
/*    */     {
/* 76 */       addBusinessInterface(metaData, type);
/*    */     }
/* 80 */     else if ((local.value() == null) || (local.value().length == 0))
/*    */     {
/* 82 */       Class businessInterface = ClassHelper.getDefaultInterface(type);
/* 83 */       addBusinessInterface(metaData, businessInterface);
/*    */     }
/*    */     else
/*    */     {
/* 87 */       for (Class businessInterface : local.value())
/*    */       {
/* 89 */         addBusinessInterface(metaData, businessInterface);
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.LocalProcessor
 * JD-Core Version:    0.6.0
 */