/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import java.util.ArrayList;
/*    */ import java.util.Collection;
/*    */ import java.util.Iterator;
/*    */ import java.util.List;
/*    */ import org.jboss.metadata.annotation.creator.AbstractFinderUser;
/*    */ import org.jboss.metadata.annotation.creator.Creator;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.EjbJar30MetaData;
/*    */ import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
/*    */ 
/*    */ public class EjbJar30Creator extends AbstractFinderUser
/*    */   implements Creator<Collection<Class<?>>, EjbJar30MetaData>
/*    */ {
/*    */   private List<Processor<EjbJar3xMetaData, Class<?>>> processors;
/*    */ 
/*    */   public EjbJar30Creator(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 49 */     super(finder);
/*    */ 
/* 51 */     this.processors = new ArrayList();
/* 52 */     this.processors.add(new StatefulProcessor(finder));
/* 53 */     this.processors.add(new StatelessProcessor(finder));
/* 54 */     this.processors.add(new MessageDrivenProcessor(finder));
/* 55 */     this.processors.add(new EntityProcessor(finder));
/* 56 */     this.processors.add(new ApplicationExceptionProcessor(finder));
/*    */   }
/*    */ 
/*    */   public EjbJar30MetaData create(Collection<Class<?>> classes)
/*    */   {
/* 61 */     EjbJar30MetaData metaData = new EjbJar30MetaData();
/* 62 */     metaData.setVersion("3.0");
/*    */ 
/* 64 */     for (Iterator i$ = classes.iterator(); i$.hasNext(); ) { cls = (Class)i$.next();
/*    */ 
/* 66 */       for (Processor processor : this.processors)
/*    */       {
/* 68 */         processor.process(metaData, cls);
/*    */       }
/*    */     }
/*    */     Class cls;
/* 72 */     return metaData;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.EjbJar30Creator
 * JD-Core Version:    0.6.0
 */