/*    */ package org.jboss.metadata.annotation.creator.ejb;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import javax.ejb.ApplicationException;
/*    */ import org.jboss.metadata.annotation.creator.AbstractFinderUser;
/*    */ import org.jboss.metadata.annotation.creator.Creator;
/*    */ import org.jboss.metadata.annotation.creator.Processor;
/*    */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*    */ import org.jboss.metadata.ejb.spec.ApplicationExceptionMetaData;
/*    */ import org.jboss.metadata.ejb.spec.ApplicationExceptionsMetaData;
/*    */ import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
/*    */ import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
/*    */ 
/*    */ public class ApplicationExceptionProcessor extends AbstractFinderUser
/*    */   implements Creator<Class<?>, ApplicationExceptionMetaData>, Processor<EjbJar3xMetaData, Class<?>>
/*    */ {
/*    */   protected ApplicationExceptionProcessor(AnnotationFinder<AnnotatedElement> finder)
/*    */   {
/* 47 */     super(finder);
/*    */   }
/*    */ 
/*    */   public ApplicationExceptionMetaData create(Class<?> element)
/*    */   {
/* 52 */     ApplicationException annotation = (ApplicationException)this.finder.getAnnotation(element, ApplicationException.class);
/* 53 */     if (annotation == null) {
/* 54 */       return null;
/*    */     }
/* 56 */     if (!Exception.class.isAssignableFrom(element)) {
/* 57 */       throw new IllegalArgumentException("ApplicationException is only valid on an Exception");
/*    */     }
/* 59 */     ApplicationExceptionMetaData metaData = new ApplicationExceptionMetaData();
/* 60 */     metaData.setExceptionClass(element.getName());
/* 61 */     metaData.setRollback(annotation.rollback());
/*    */ 
/* 63 */     return metaData;
/*    */   }
/*    */ 
/*    */   public void process(EjbJar3xMetaData ejbJar, Class<?> type)
/*    */   {
/* 68 */     ApplicationExceptionMetaData applicationException = create(type);
/* 69 */     if (applicationException == null) {
/* 70 */       return;
/*    */     }
/* 72 */     if (ejbJar.getAssemblyDescriptor() == null)
/* 73 */       ejbJar.setAssemblyDescriptor(new AssemblyDescriptorMetaData());
/* 74 */     if (ejbJar.getAssemblyDescriptor().getApplicationExceptions() == null) {
/* 75 */       ejbJar.getAssemblyDescriptor().setApplicationExceptions(new ApplicationExceptionsMetaData());
/*    */     }
/* 77 */     ejbJar.getAssemblyDescriptor().getApplicationExceptions().add(applicationException);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.ejb.ApplicationExceptionProcessor
 * JD-Core Version:    0.6.0
 */