/*     */ package org.jboss.metadata.annotation.creator;
/*     */ 
/*     */ import java.lang.reflect.AnnotatedElement;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.annotation.Resource;
/*     */ import javax.annotation.Resource.AuthenticationType;
/*     */ import org.jboss.annotation.javaee.Descriptions;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*     */ import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceAuthorityType;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*     */ 
/*     */ public abstract class AbstractResourceProcessor<E extends AnnotatedElement> extends AbstractFinderUser
/*     */ {
/*  90 */   private static Logger log = Logger.getLogger(AbstractResourceProcessor.class);
/*  91 */   private static final Set<String> envEntryTypes = new HashSet();
/*  92 */   private static final Set<String> serviceRefTypes = new HashSet();
/*  93 */   private static final Set<String> resourceRefTypes = new HashSet();
/*  94 */   private static final Set<String> messageDestRefRefTypes = new HashSet();
/*     */ 
/*     */   public static boolean isEnvEntry(String type)
/*     */   {
/* 133 */     return envEntryTypes.contains(type);
/*     */   }
/*     */ 
/*     */   public static boolean isServiceRef(String type) {
/* 137 */     return serviceRefTypes.contains(type);
/*     */   }
/*     */ 
/*     */   public static boolean isResourceRef(String type) {
/* 141 */     return resourceRefTypes.contains(type);
/*     */   }
/*     */ 
/*     */   public static boolean isMessageDestinationRef(String type) {
/* 145 */     return messageDestRefRefTypes.contains(type);
/*     */   }
/*     */ 
/*     */   protected AbstractResourceProcessor(AnnotationFinder<AnnotatedElement> finder)
/*     */   {
/* 150 */     super(finder);
/*     */   }
/*     */ 
/*     */   public void process(EnvironmentRefsGroupMetaData refs, E element)
/*     */   {
/* 155 */     Resource annotation = (Resource)this.finder.getAnnotation(element, Resource.class);
/* 156 */     if (annotation == null)
/* 157 */       return;
/* 158 */     process(refs, element, annotation);
/*     */   }
/*     */ 
/*     */   protected void process(EnvironmentRefsGroupMetaData refs, E element, Resource annotation) {
/* 162 */     boolean trace = log.isTraceEnabled();
/* 163 */     String type = annotation.type().getName();
/* 164 */     if (type.equals("java.lang.Object"))
/* 165 */       type = getType(element);
/* 166 */     if (trace)
/* 167 */       log.trace("process: " + annotation + ", type=" + type);
/* 168 */     if (isEnvEntry(type))
/*     */     {
/* 170 */       EnvironmentEntriesMetaData env = refs.getEnvironmentEntries();
/* 171 */       if (env == null)
/*     */       {
/* 173 */         env = new EnvironmentEntriesMetaData();
/* 174 */         refs.setEnvironmentEntries(env);
/*     */       }
/* 176 */       EnvironmentEntryMetaData entry = createEntry(annotation, element);
/* 177 */       env.add(entry);
/* 178 */       if (trace)
/* 179 */         log.trace("created env-entry: " + entry);
/*     */     }
/* 181 */     else if (isServiceRef(type))
/*     */     {
/* 183 */       ServiceReferencesMetaData srefs = refs.getServiceReferences();
/* 184 */       if (srefs == null)
/*     */       {
/* 186 */         srefs = new ServiceReferencesMetaData();
/* 187 */         refs.setServiceReferences(srefs);
/*     */       }
/* 189 */       ServiceReferenceMetaData ref = createServiceRef(annotation, element);
/* 190 */       srefs.add(ref);
/* 191 */       if (trace)
/* 192 */         log.trace("created service-ref: " + ref);
/*     */     }
/* 194 */     else if (isResourceRef(type))
/*     */     {
/* 196 */       ResourceReferencesMetaData resRefs = refs.getResourceReferences();
/* 197 */       if (resRefs == null)
/*     */       {
/* 199 */         resRefs = new ResourceReferencesMetaData();
/* 200 */         refs.setResourceReferences(resRefs);
/*     */       }
/* 202 */       ResourceReferenceMetaData ref = createResourceRef(annotation, element);
/* 203 */       resRefs.add(ref);
/* 204 */       if (trace)
/* 205 */         log.trace("created resource-ref: " + ref);
/*     */     }
/* 207 */     else if (isMessageDestinationRef(type))
/*     */     {
/* 209 */       MessageDestinationReferencesMetaData mrefs = refs.getMessageDestinationReferences();
/* 210 */       if (mrefs == null)
/*     */       {
/* 212 */         mrefs = new MessageDestinationReferencesMetaData();
/* 213 */         refs.setMessageDestinationReferences(mrefs);
/*     */       }
/* 215 */       MessageDestinationReferenceMetaData ref = createMessageRef(annotation, element);
/* 216 */       mrefs.add(ref);
/* 217 */       if (trace)
/* 218 */         log.trace("created message-destination-ref: " + ref);
/*     */     }
/*     */     else
/*     */     {
/* 222 */       ResourceEnvironmentReferencesMetaData resRefs = refs.getResourceEnvironmentReferences();
/* 223 */       if (resRefs == null)
/*     */       {
/* 225 */         resRefs = new ResourceEnvironmentReferencesMetaData();
/* 226 */         refs.setResourceEnvironmentReferences(resRefs);
/*     */       }
/* 228 */       ResourceEnvironmentReferenceMetaData ref = createResourceEnvRef(annotation, element);
/* 229 */       resRefs.add(ref);
/* 230 */       if (trace)
/* 231 */         log.trace("created resource-env-ref: " + ref);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract String getName(E paramE);
/*     */ 
/*     */   protected abstract String getInjectionName(E paramE);
/*     */ 
/*     */   protected abstract String getType(E paramE);
/*     */ 
/*     */   protected abstract String getDeclaringClass(E paramE);
/*     */ 
/*     */   protected ResourceReferenceMetaData createResourceRef(Resource annotation, E element)
/*     */   {
/* 252 */     ResourceReferenceMetaData ref = new ResourceReferenceMetaData();
/* 253 */     String name = annotation.name();
/* 254 */     if (name.length() == 0)
/* 255 */       name = getName(element);
/* 256 */     ref.setResourceRefName(name);
/* 257 */     Resource.AuthenticationType authType = annotation.authenticationType();
/* 258 */     ResourceAuthorityType resAuthType = ResourceAuthorityType.Container;
/* 259 */     if (authType == Resource.AuthenticationType.APPLICATION)
/* 260 */       resAuthType = ResourceAuthorityType.Application;
/* 261 */     ref.setResAuth(resAuthType);
/* 262 */     if (annotation.mappedName().length() > 0)
/* 263 */       ref.setMappedName(annotation.mappedName());
/* 264 */     Descriptions descriptions = ProcessorUtils.getDescription(annotation.description());
/* 265 */     if (descriptions != null)
/*     */     {
/* 267 */       ref.setDescriptions(descriptions);
/*     */     }
/* 269 */     if (annotation.type() != Object.class)
/* 270 */       ref.setType(annotation.type().getName());
/*     */     else {
/* 272 */       ref.setType(getType(element));
/*     */     }
/* 274 */     String injectionName = getInjectionName(element);
/* 275 */     Set injectionTargets = ProcessorUtils.getInjectionTargets(injectionName, element);
/* 276 */     if (injectionTargets != null) {
/* 277 */       ref.setInjectionTargets(injectionTargets);
/*     */     }
/* 279 */     return ref;
/*     */   }
/*     */ 
/*     */   protected EnvironmentEntryMetaData createEntry(Resource annotation, E element)
/*     */   {
/* 284 */     EnvironmentEntryMetaData entry = new EnvironmentEntryMetaData();
/* 285 */     String name = annotation.name();
/* 286 */     if (name.length() == 0)
/* 287 */       name = getName(element);
/* 288 */     entry.setEnvEntryName(name);
/* 289 */     Descriptions descriptions = ProcessorUtils.getDescription(annotation.description());
/* 290 */     if (descriptions != null)
/* 291 */       entry.setDescriptions(descriptions);
/* 292 */     if (annotation.type() != Object.class)
/* 293 */       entry.setType(annotation.type().getName());
/*     */     else
/* 295 */       entry.setType(getType(element));
/* 296 */     if (annotation.mappedName().length() > 0)
/* 297 */       entry.setValue(annotation.mappedName());
/* 298 */     String injectionName = getInjectionName(element);
/* 299 */     Set injectionTargets = ProcessorUtils.getInjectionTargets(injectionName, element);
/* 300 */     if (injectionTargets != null) {
/* 301 */       entry.setInjectionTargets(injectionTargets);
/*     */     }
/* 303 */     return entry;
/*     */   }
/*     */ 
/*     */   protected ServiceReferenceMetaData createServiceRef(Resource annotation, E element)
/*     */   {
/* 308 */     ServiceReferenceMetaData ref = new ServiceReferenceMetaData();
/* 309 */     String name = annotation.name();
/* 310 */     if (name.length() == 0)
/* 311 */       name = getName(element);
/* 312 */     ref.setServiceRefName(name);
/* 313 */     if (annotation.mappedName().length() > 0)
/* 314 */       ref.setMappedName(annotation.mappedName());
/* 315 */     ref.setAnnotatedElement(element);
/* 316 */     DescriptionGroupMetaData dg = ProcessorUtils.getDescriptionGroup(annotation.description());
/* 317 */     if (dg != null)
/* 318 */       ref.setDescriptionGroup(dg);
/* 319 */     if (annotation.type() != Object.class)
/* 320 */       ref.setServiceRefType(annotation.type().getName());
/*     */     else
/* 322 */       ref.setServiceRefType(getType(element));
/* 323 */     String injectionName = getInjectionName(element);
/* 324 */     Set injectionTargets = ProcessorUtils.getInjectionTargets(injectionName, element);
/* 325 */     if (injectionTargets != null) {
/* 326 */       ref.setInjectionTargets(injectionTargets);
/*     */     }
/* 328 */     return ref;
/*     */   }
/*     */ 
/*     */   protected MessageDestinationReferenceMetaData createMessageRef(Resource annotation, E element)
/*     */   {
/* 333 */     MessageDestinationReferenceMetaData ref = new MessageDestinationReferenceMetaData();
/* 334 */     String name = annotation.name();
/* 335 */     if (name.length() == 0)
/* 336 */       name = getName(element);
/* 337 */     ref.setMessageDestinationRefName(name);
/* 338 */     if (annotation.mappedName().length() > 0)
/* 339 */       ref.setMappedName(annotation.mappedName());
/* 340 */     if (annotation.type() != Object.class)
/* 341 */       ref.setType(annotation.type().getName());
/*     */     else
/* 343 */       ref.setType(getType(element));
/* 344 */     Descriptions descriptions = ProcessorUtils.getDescription(annotation.description());
/* 345 */     if (descriptions != null)
/* 346 */       ref.setDescriptions(descriptions);
/* 347 */     String injectionName = getInjectionName(element);
/* 348 */     Set injectionTargets = ProcessorUtils.getInjectionTargets(injectionName, element);
/* 349 */     if (injectionTargets != null) {
/* 350 */       ref.setInjectionTargets(injectionTargets);
/*     */     }
/* 352 */     return ref;
/*     */   }
/*     */ 
/*     */   protected ResourceEnvironmentReferenceMetaData createResourceEnvRef(Resource annotation, E element)
/*     */   {
/* 357 */     ResourceEnvironmentReferenceMetaData ref = new ResourceEnvironmentReferenceMetaData();
/* 358 */     String name = annotation.name();
/* 359 */     if (name.length() == 0)
/* 360 */       name = getName(element);
/* 361 */     ref.setResourceEnvRefName(name);
/* 362 */     if (annotation.mappedName().length() > 0)
/* 363 */       ref.setMappedName(annotation.mappedName());
/* 364 */     if (annotation.type() != Object.class)
/* 365 */       ref.setType(annotation.type().getName());
/*     */     else
/* 367 */       ref.setType(getType(element));
/* 368 */     Descriptions descriptions = ProcessorUtils.getDescription(annotation.description());
/* 369 */     if (descriptions != null) {
/* 370 */       ref.setDescriptions(descriptions);
/*     */     }
/* 372 */     String injectionName = getInjectionName(element);
/* 373 */     Set injectionTargets = ProcessorUtils.getInjectionTargets(injectionName, element);
/* 374 */     if (injectionTargets != null) {
/* 375 */       ref.setInjectionTargets(injectionTargets);
/*     */     }
/* 377 */     return ref;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  97 */     envEntryTypes.add("java.lang.String");
/*  98 */     envEntryTypes.add("java.lang.Character");
/*  99 */     envEntryTypes.add("java.lang.Integer");
/* 100 */     envEntryTypes.add("java.lang.Boolean");
/* 101 */     envEntryTypes.add("java.lang.Double");
/* 102 */     envEntryTypes.add("java.lang.Byte");
/* 103 */     envEntryTypes.add("java.lang.Short");
/* 104 */     envEntryTypes.add("java.lang.Float");
/* 105 */     envEntryTypes.add("java.lang.Long");
/* 106 */     envEntryTypes.add("char");
/* 107 */     envEntryTypes.add("int");
/* 108 */     envEntryTypes.add("boolean");
/* 109 */     envEntryTypes.add("double");
/* 110 */     envEntryTypes.add("byte");
/* 111 */     envEntryTypes.add("short");
/* 112 */     envEntryTypes.add("float");
/* 113 */     envEntryTypes.add("long");
/* 114 */     serviceRefTypes.add("javax.xml.rpc.Service");
/* 115 */     serviceRefTypes.add("javax.xml.ws.Service");
/* 116 */     serviceRefTypes.add("javax.jws.WebService");
/* 117 */     resourceRefTypes.add("javax.sql.DataSource");
/* 118 */     resourceRefTypes.add("javax.jms.ConnectionFactory");
/* 119 */     resourceRefTypes.add("javax.jms.QueueConnectionFactory");
/* 120 */     resourceRefTypes.add("javax.jms.TopicConnectionFactory");
/* 121 */     resourceRefTypes.add("javax.mail.Session");
/* 122 */     resourceRefTypes.add("java.net.URL");
/* 123 */     resourceRefTypes.add("javax.resource.cci.ConnectionFactory");
/* 124 */     resourceRefTypes.add("org.omg.CORBA_2_3.ORB");
/* 125 */     messageDestRefRefTypes.add("javax.jms.Queue");
/* 126 */     messageDestRefRefTypes.add("javax.jms.Topic");
/* 127 */     messageDestRefRefTypes.add("javax.jms.TemporaryQueue");
/* 128 */     messageDestRefRefTypes.add("javax.jms.TemporaryTopic");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.AbstractResourceProcessor
 * JD-Core Version:    0.6.0
 */