/*     */ package org.jboss.metadata.annotation.creator;
/*     */ 
/*     */ import java.lang.reflect.AnnotatedElement;
/*     */ import java.util.Set;
/*     */ import javax.persistence.PersistenceContext;
/*     */ import javax.persistence.PersistenceContextType;
/*     */ import javax.persistence.PersistenceProperty;
/*     */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PropertiesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.PropertyMetaData;
/*     */ 
/*     */ public abstract class AbstractPersistenceContextProcessor<E extends AnnotatedElement> extends AbstractFinderUser
/*     */ {
/*     */   public AbstractPersistenceContextProcessor(AnnotationFinder<AnnotatedElement> finder)
/*     */   {
/*  52 */     super(finder);
/*     */   }
/*     */ 
/*     */   public void process(PersistenceContextReferencesMetaData refs, E element)
/*     */   {
/*  57 */     PersistenceContext annotation = (PersistenceContext)this.finder.getAnnotation(element, PersistenceContext.class);
/*  58 */     if (annotation == null) {
/*  59 */       return;
/*     */     }
/*  61 */     process(refs, element, annotation);
/*     */   }
/*     */ 
/*     */   protected void process(PersistenceContextReferencesMetaData refs, E element, PersistenceContext annotation)
/*     */   {
/*  66 */     PersistenceContextReferenceMetaData ref = createPC(element, annotation);
/*  67 */     refs.add(ref);
/*     */   }
/*     */ 
/*     */   protected PersistenceContextReferenceMetaData createPC(E element, PersistenceContext annotation)
/*     */   {
/*  72 */     PersistenceContextReferenceMetaData ref = new PersistenceContextReferenceMetaData();
/*  73 */     String name = annotation.name();
/*  74 */     if (name.length() == 0)
/*  75 */       name = ProcessorUtils.getName(element);
/*  76 */     ref.setPersistenceContextRefName(name);
/*  77 */     if (annotation.unitName().length() > 0)
/*  78 */       ref.setPersistenceUnitName(annotation.unitName());
/*  79 */     PersistenceContextType type = annotation.type();
/*  80 */     ref.setPersistenceContextType(type);
/*     */ 
/*  82 */     PersistenceProperty[] properties = annotation.properties();
/*  83 */     if (properties.length > 0)
/*     */     {
/*  85 */       PropertiesMetaData refProperties = new PropertiesMetaData();
/*  86 */       for (PersistenceProperty p : properties)
/*     */       {
/*  88 */         PropertyMetaData pmd = new PropertyMetaData();
/*  89 */         pmd.setName(p.name());
/*  90 */         pmd.setValue(p.value());
/*  91 */         refProperties.add(pmd);
/*     */       }
/*  93 */       ref.setProperties(refProperties);
/*     */     }
/*     */ 
/*  96 */     Set injectionTargets = ProcessorUtils.getInjectionTargets(name, element);
/*  97 */     if (injectionTargets != null) {
/*  98 */       ref.setInjectionTargets(injectionTargets);
/*     */     }
/* 100 */     return ref;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.annotation.creator.AbstractPersistenceContextProcessor
 * JD-Core Version:    0.6.0
 */