/*     */ package org.jboss.metadata;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import javax.jms.Message;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
/*     */ import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
/*     */ import org.jboss.metadata.ejb.spec.ActivationConfigPropertiesMetaData;
/*     */ import org.jboss.metadata.ejb.spec.SubscriptionDurability;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ 
/*     */ @Deprecated
/*     */ public class MessageDrivenMetaData extends BeanMetaData
/*     */ {
/*     */   public static final int AUTO_ACKNOWLEDGE_MODE = 1;
/*     */   public static final int DUPS_OK_ACKNOWLEDGE_MODE = 3;
/*     */   public static final int CLIENT_ACKNOWLEDGE_MODE = 2;
/*     */   public static final byte DURABLE_SUBSCRIPTION = 0;
/*     */   public static final byte NON_DURABLE_SUBSCRIPTION = 1;
/*     */   public static final byte TX_UNSET = 9;
/*     */   public static final String DEFAULT_MESSAGE_DRIVEN_BEAN_INVOKER_PROXY_BINDING = "message-driven-bean";
/*     */   public static final String DEFAULT_MESSAGING_TYPE = "javax.jms.MessageListener";
/*  80 */   private transient byte methodTransactionType = 9;
/*     */ 
/*     */   protected MessageDrivenMetaData(ApplicationMetaData app, JBossEnterpriseBeanMetaData delegate)
/*     */   {
/*  90 */     super(app, delegate);
/*     */   }
/*     */ 
/*     */   protected MessageDrivenMetaData(MetaData metaData)
/*     */   {
/* 102 */     super(metaData);
/*     */   }
/*     */ 
/*     */   public JBossMessageDrivenBeanMetaData getDelegate()
/*     */   {
/* 108 */     return (JBossMessageDrivenBeanMetaData)super.getDelegate();
/*     */   }
/*     */ 
/*     */   public String getHome()
/*     */   {
/* 114 */     return null;
/*     */   }
/*     */ 
/*     */   public String getLocal()
/*     */   {
/* 120 */     return null;
/*     */   }
/*     */ 
/*     */   public String getLocalHome()
/*     */   {
/* 126 */     return null;
/*     */   }
/*     */ 
/*     */   public String getRemote()
/*     */   {
/* 132 */     return null;
/*     */   }
/*     */ 
/*     */   public String getServiceEndpoint()
/*     */   {
/* 138 */     return null;
/*     */   }
/*     */ 
/*     */   public String getMessagingType()
/*     */   {
/* 148 */     return getDelegate().getMessagingType();
/*     */   }
/*     */ 
/*     */   public boolean isJMSMessagingType()
/*     */   {
/* 158 */     return getDelegate().isJMS();
/*     */   }
/*     */ 
/*     */   public String getDestinationType()
/*     */   {
/* 168 */     return getDelegate().getMessageDestinationType();
/*     */   }
/*     */ 
/*     */   public String getDestinationLink()
/*     */   {
/* 178 */     return getDelegate().getMessageDestinationLink();
/*     */   }
/*     */ 
/*     */   public HashMap<String, ActivationConfigPropertyMetaData> getActivationConfigProperties()
/*     */   {
/* 188 */     HashMap result = new LinkedHashMap();
/* 189 */     ActivationConfigMetaData config = getDelegate().getActivationConfig();
/* 190 */     if (config != null)
/*     */     {
/* 192 */       ActivationConfigPropertiesMetaData properties = config.getActivationConfigProperties();
/* 193 */       if (properties != null)
/*     */       {
/* 195 */         for (org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData property : properties)
/* 196 */           result.put(property.getName(), new ActivationConfigPropertyMetaData(property));
/*     */       }
/*     */     }
/* 199 */     return result;
/*     */   }
/*     */ 
/*     */   public ActivationConfigPropertyMetaData getActivationConfigProperty(String name)
/*     */   {
/* 210 */     ActivationConfigMetaData config = getDelegate().getActivationConfig();
/* 211 */     if (config != null)
/*     */     {
/* 213 */       ActivationConfigPropertiesMetaData properties = config.getActivationConfigProperties();
/* 214 */       if (properties != null)
/*     */       {
/* 216 */         org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData result = (org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData)properties.get(name);
/* 217 */         if (result != null)
/* 218 */           return new ActivationConfigPropertyMetaData(result);
/*     */       }
/*     */     }
/* 221 */     return null;
/*     */   }
/*     */ 
/*     */   public byte getMethodTransactionType()
/*     */   {
/* 231 */     if (this.methodTransactionType == 9)
/*     */     {
/* 233 */       Class[] sig = { Message.class };
/* 234 */       this.methodTransactionType = getMethodTransactionType("onMessage", sig);
/*     */     }
/* 236 */     return this.methodTransactionType;
/*     */   }
/*     */ 
/*     */   public byte getMethodTransactionType(String methodName, Class[] signature)
/*     */   {
/* 248 */     if (isContainerManagedTx())
/*     */     {
/* 250 */       if (super.getMethodTransactionType(methodName, signature, null) == 0) {
/* 251 */         return 0;
/*     */       }
/* 253 */       return 1;
/*     */     }
/*     */ 
/* 256 */     return 6;
/*     */   }
/*     */ 
/*     */   public byte getMethodTransactionType(String methodName, Class[] params, InvocationType iface)
/*     */   {
/* 263 */     if (isJMSMessagingType()) {
/* 264 */       return getMethodTransactionType();
/*     */     }
/* 266 */     return getMethodTransactionType(methodName, params);
/*     */   }
/*     */ 
/*     */   public int getAcknowledgeMode()
/*     */   {
/* 297 */     if (getMethodTransactionType() == 1)
/*     */     {
/* 299 */       return 2;
/*     */     }
/*     */ 
/* 304 */     String ack = getDelegate().getAcknowledgeMode();
/* 305 */     if ((ack == null) || (ack.equalsIgnoreCase("Auto-acknowledge")) || (ack.equalsIgnoreCase("AUTO_ACKNOWLEDGE")))
/* 306 */       return 1;
/* 307 */     if ((ack.equalsIgnoreCase("Dups-ok-acknowledge")) || (ack.equalsIgnoreCase("DUPS_OK_ACKNOWLEDGE")))
/* 308 */       return 3;
/* 309 */     throw new IllegalStateException("invalid acknowledge-mode: " + ack);
/*     */   }
/*     */ 
/*     */   public String getMessageSelector()
/*     */   {
/* 320 */     return getDelegate().getMessageSelector();
/*     */   }
/*     */ 
/*     */   public String getDestinationJndiName()
/*     */   {
/* 330 */     return getDelegate().getDestinationJndiName();
/*     */   }
/*     */ 
/*     */   public String getUser()
/*     */   {
/* 340 */     return getDelegate().getMdbUser();
/*     */   }
/*     */ 
/*     */   public String getPasswd()
/*     */   {
/* 350 */     return getDelegate().getMdbPassword();
/*     */   }
/*     */ 
/*     */   public String getClientId()
/*     */   {
/* 360 */     return getDelegate().getMdbClientId();
/*     */   }
/*     */ 
/*     */   public String getSubscriptionId()
/*     */   {
/* 370 */     return getDelegate().getMdbSubscriptionId();
/*     */   }
/*     */ 
/*     */   public byte getSubscriptionDurability()
/*     */   {
/* 381 */     SubscriptionDurability durability = getDelegate().getSubscriptionDurability();
/* 382 */     if (durability == SubscriptionDurability.Durable) {
/* 383 */       return 0;
/*     */     }
/* 385 */     return 1;
/*     */   }
/*     */ 
/*     */   public String getResourceAdapterName()
/*     */   {
/* 395 */     return getDelegate().getResourceAdapterName();
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/* 401 */     throw new UnsupportedOperationException("Message driven beans are not bound into remote jndi");
/*     */   }
/*     */ 
/*     */   public boolean isCallByValue()
/*     */   {
/* 407 */     throw new UnsupportedOperationException("Message driven beans do not have a call by value");
/*     */   }
/*     */ 
/*     */   public boolean isClustered()
/*     */   {
/* 413 */     throw new UnsupportedOperationException("Message driven beans are not clustered");
/*     */   }
/*     */ 
/*     */   public Iterator<SecurityRoleRefMetaData> getSecurityRoleReferences()
/*     */   {
/* 419 */     throw new UnsupportedOperationException("Message driven beans do not have security role references");
/*     */   }
/*     */ 
/*     */   public ClusterConfigMetaData getClusterConfigMetaData()
/*     */   {
/* 425 */     throw new UnsupportedOperationException("Message driven beans do not have clustering configuration");
/*     */   }
/*     */ 
/*     */   public SecurityIdentityMetaData getEjbTimeoutIdentity()
/*     */   {
/* 431 */     org.jboss.metadata.ejb.spec.SecurityIdentityMetaData securityIdentity = getDelegate().getEjbTimeoutIdentity();
/* 432 */     if (securityIdentity != null)
/* 433 */       return new SecurityIdentityMetaData(securityIdentity);
/* 434 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metadata.MessageDrivenMetaData
 * JD-Core Version:    0.6.0
 */