/*     */ package org.jboss.messaging.util;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.InputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.Properties;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class Version
/*     */   implements Streamable, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 3605477218138273630L;
/*  30 */   private static final Logger log = Logger.getLogger(Version.class);
/*     */ 
/*  36 */   private String jmsVersion = "UNKNOWN";
/*  37 */   private int jmsMajorVersion = 0;
/*  38 */   private int jmsMinorVersion = 0;
/*  39 */   private String jmsProviderName = "UNKNOWN";
/*  40 */   private String providerVersion = "UNKNOWN";
/*  41 */   private int providerMajorVersion = 0;
/*  42 */   private int providerMinorVersion = 0;
/*     */   private byte providerIncrementingVersion;
/*     */   private static Version singleton;
/*     */ 
/*     */   private Version(String versionFile)
/*     */   {
/*  56 */     load(versionFile);
/*     */   }
/*     */ 
/*     */   public Version()
/*     */   {
/*     */   }
/*     */ 
/*     */   public static synchronized Version instance()
/*     */   {
/*  67 */     if (singleton == null)
/*     */     {
/*  69 */       singleton = new Version("VERSION");
/*     */     }
/*  71 */     return singleton;
/*     */   }
/*     */ 
/*     */   public String getJMSVersion()
/*     */   {
/*  76 */     return this.jmsVersion;
/*     */   }
/*     */ 
/*     */   public int getJMSMajorVersion()
/*     */   {
/*  81 */     return this.jmsMajorVersion;
/*     */   }
/*     */ 
/*     */   public int getJMSMinorVersion()
/*     */   {
/*  86 */     return this.jmsMinorVersion;
/*     */   }
/*     */ 
/*     */   public String getJMSProviderName()
/*     */   {
/*  91 */     return this.jmsProviderName;
/*     */   }
/*     */ 
/*     */   public String getProviderVersion()
/*     */   {
/*  96 */     return this.providerVersion;
/*     */   }
/*     */ 
/*     */   public int getProviderMajorVersion()
/*     */   {
/* 101 */     return this.providerMajorVersion;
/*     */   }
/*     */ 
/*     */   public int getProviderMinorVersion()
/*     */   {
/* 106 */     return this.providerMinorVersion;
/*     */   }
/*     */ 
/*     */   public byte getProviderIncrementingVersion()
/*     */   {
/* 111 */     return this.providerIncrementingVersion;
/*     */   }
/*     */ 
/*     */   private void load(String versionFile)
/*     */   {
/* 122 */     InputStream is = null;
/*     */     try
/*     */     {
/* 126 */       Properties versionInfo = new Properties();
/*     */ 
/* 130 */       is = Thread.currentThread().getContextClassLoader().getResourceAsStream(versionFile);
/*     */ 
/* 132 */       versionInfo.load(is);
/*     */ 
/* 136 */       String s = versionInfo.getProperty("jboss.messaging.jmsVersion");
/* 137 */       if (s != null)
/*     */       {
/* 139 */         this.jmsVersion = s;
/*     */       }
/*     */ 
/* 142 */       s = versionInfo.getProperty("jboss.messaging.jmsMajorVersion");
/* 143 */       if (s != null)
/*     */       {
/*     */         try
/*     */         {
/* 147 */           this.jmsMajorVersion = Integer.parseInt(s);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 151 */           log.debug("failed to parse jmsMajorVersion: " + s);
/*     */         }
/*     */       }
/*     */ 
/* 155 */       s = versionInfo.getProperty("jboss.messaging.jmsMinorVersion");
/* 156 */       if (s != null)
/*     */       {
/*     */         try
/*     */         {
/* 160 */           this.jmsMinorVersion = Integer.parseInt(s);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 164 */           log.debug("failed to parse jmsMinorVersion: " + s);
/*     */         }
/*     */       }
/*     */ 
/* 168 */       s = versionInfo.getProperty("jboss.messaging.jmsProviderName");
/* 169 */       if (s != null)
/*     */       {
/* 171 */         this.jmsProviderName = s;
/*     */       }
/*     */ 
/* 174 */       s = versionInfo.getProperty("jboss.messaging.providerVersion");
/* 175 */       if (s != null)
/*     */       {
/* 177 */         this.providerVersion = s;
/*     */       }
/*     */ 
/* 180 */       s = versionInfo.getProperty("jboss.messaging.providerMajorVersion");
/* 181 */       if (s != null)
/*     */       {
/*     */         try
/*     */         {
/* 185 */           this.providerMajorVersion = Integer.parseInt(s);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 189 */           log.debug("failed to parse providerMajorVersion: " + s);
/*     */         }
/*     */       }
/*     */ 
/* 193 */       s = versionInfo.getProperty("jboss.messaging.providerMinorVersion");
/* 194 */       if (s != null)
/*     */       {
/*     */         try
/*     */         {
/* 198 */           this.providerMinorVersion = Integer.parseInt(s);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 202 */           log.debug("failed to parse providerMinorVersion: " + s);
/*     */         }
/*     */       }
/*     */ 
/* 206 */       s = versionInfo.getProperty("jboss.messaging.providerIncrementingVersion");
/* 207 */       if (s != null)
/*     */       {
/*     */         try
/*     */         {
/* 211 */           this.providerIncrementingVersion = Byte.parseByte(s);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 215 */           log.debug("failed to parse providerIncrementingVersion: " + s);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 221 */       log.warn("Unable to read version info: " + e.getMessage());
/* 222 */       log.debug("Unable to read version info", e);
/*     */     }
/*     */     finally
/*     */     {
/* 226 */       if (is != null)
/*     */       {
/*     */         try
/*     */         {
/* 230 */           is.close();
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 234 */           log.debug("failed to close the version info stream", e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in) throws Exception
/*     */   {
/* 242 */     this.jmsVersion = in.readUTF();
/*     */ 
/* 244 */     this.jmsMajorVersion = in.readInt();
/*     */ 
/* 246 */     this.jmsMinorVersion = in.readInt();
/*     */ 
/* 248 */     this.jmsProviderName = in.readUTF();
/*     */ 
/* 250 */     this.providerVersion = in.readUTF();
/*     */ 
/* 252 */     this.providerMajorVersion = in.readInt();
/*     */ 
/* 254 */     this.providerMinorVersion = in.readInt();
/*     */ 
/* 256 */     this.providerIncrementingVersion = in.readByte();
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out) throws Exception
/*     */   {
/* 261 */     out.writeUTF(this.jmsVersion);
/*     */ 
/* 263 */     out.writeInt(this.jmsMajorVersion);
/*     */ 
/* 265 */     out.writeInt(this.jmsMinorVersion);
/*     */ 
/* 267 */     out.writeUTF(this.jmsProviderName);
/*     */ 
/* 269 */     out.writeUTF(this.providerVersion);
/*     */ 
/* 271 */     out.writeInt(this.providerMajorVersion);
/*     */ 
/* 273 */     out.writeInt(this.providerMinorVersion);
/*     */ 
/* 275 */     out.writeByte(this.providerIncrementingVersion);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.util.Version
 * JD-Core Version:    0.6.0
 */