/*    */ package org.jboss.messaging.util;
/*    */ 
/*    */ import java.util.concurrent.Semaphore;
/*    */ import java.util.concurrent.TimeUnit;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class ClearableSemaphore
/*    */ {
/* 18 */   protected Logger log = Logger.getLogger(ClearableSemaphore.class);
/*    */   private volatile Semaphore semaphore;
/*    */   private int permits;
/*    */ 
/*    */   private void createSemaphore()
/*    */   {
/* 26 */     this.semaphore = new Semaphore(this.permits, true);
/*    */   }
/*    */ 
/*    */   public ClearableSemaphore(int permits)
/*    */   {
/* 31 */     this.permits = permits;
/*    */ 
/* 33 */     createSemaphore();
/*    */   }
/*    */ 
/*    */   public void acquire() throws InterruptedException
/*    */   {
/* 38 */     Semaphore sem = this.semaphore;
/*    */ 
/* 40 */     if (sem != null)
/*    */     {
/* 42 */       sem.acquire();
/*    */     }
/*    */   }
/*    */ 
/*    */   public boolean tryAcquire(long timeout) throws InterruptedException
/*    */   {
/* 48 */     Semaphore sem = this.semaphore;
/*    */ 
/* 50 */     if (sem != null)
/*    */     {
/* 52 */       return sem.tryAcquire(timeout, TimeUnit.MILLISECONDS);
/*    */     }
/*    */ 
/* 56 */     return true;
/*    */   }
/*    */ 
/*    */   public void release()
/*    */   {
/* 62 */     Semaphore sem = this.semaphore;
/*    */ 
/* 64 */     if (sem != null)
/*    */     {
/* 66 */       sem.release();
/*    */     }
/*    */   }
/*    */ 
/*    */   public synchronized void disable()
/*    */   {
/* 72 */     if (this.semaphore != null)
/*    */     {
/* 74 */       Semaphore oldSem = this.semaphore;
/*    */ 
/* 76 */       this.semaphore = null;
/*    */ 
/* 78 */       oldSem.release(this.permits);
/*    */     }
/*    */   }
/*    */ 
/*    */   public synchronized void enable()
/*    */   {
/* 84 */     if (this.semaphore == null)
/*    */     {
/* 86 */       createSemaphore();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.util.ClearableSemaphore
 * JD-Core Version:    0.6.0
 */