/*     */ package org.jboss.messaging.core.jmx;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.util.Properties;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.sql.DataSource;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.util.ExceptionUtil;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.tm.TransactionManagerLocator;
/*     */ 
/*     */ public abstract class JDBCServiceSupport extends ServiceMBeanSupport
/*     */ {
/*     */   protected DataSource ds;
/*     */   protected Properties sqlProperties;
/*  58 */   protected boolean createTablesOnStartup = true;
/*     */   private String dataSourceJNDIName;
/*     */   private ObjectName tmObjectName;
/*     */   private TransactionManager tm;
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/*  70 */     InitialContext ic = null;
/*     */     try
/*     */     {
/*  73 */       ic = new InitialContext();
/*  74 */       this.ds = ((DataSource)ic.lookup(this.dataSourceJNDIName));
/*  75 */       if (this.ds == null)
/*     */       {
/*  77 */         throw new IllegalStateException("No DataSource found. This service dependencies must have not been enforced correctly!");
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  84 */       throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
/*     */     }
/*     */     finally
/*     */     {
/*  88 */       if (ic != null)
/*     */       {
/*  90 */         ic.close();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/*  97 */     this.log.debug(this + " stopped");
/*     */   }
/*     */ 
/*     */   public String getSqlProperties()
/*     */   {
/*     */     try
/*     */     {
/* 106 */       ByteArrayOutputStream boa = new ByteArrayOutputStream();
/* 107 */       this.sqlProperties.store(boa, "");
/* 108 */       return new String(boa.toByteArray());
/*     */     }
/*     */     catch (IOException shouldnothappen) {
/*     */     }
/* 112 */     return "";
/*     */   }
/*     */ 
/*     */   public void setSqlProperties(String value)
/*     */   {
/*     */     try
/*     */     {
/* 120 */       ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes());
/* 121 */       this.sqlProperties = new Properties();
/* 122 */       this.sqlProperties.load(is);
/*     */     }
/*     */     catch (IOException shouldnothappen)
/*     */     {
/* 126 */       this.log.error("Caught IOException", shouldnothappen);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setDataSource(String dataSourceJNDIName) throws Exception
/*     */   {
/* 132 */     this.dataSourceJNDIName = dataSourceJNDIName;
/*     */   }
/*     */ 
/*     */   public String getDataSource()
/*     */   {
/* 137 */     return this.dataSourceJNDIName;
/*     */   }
/*     */ 
/*     */   public void setTransactionManager(ObjectName tmObjectName) throws Exception
/*     */   {
/* 142 */     this.tmObjectName = tmObjectName;
/*     */   }
/*     */ 
/*     */   public ObjectName getTransactionManager()
/*     */   {
/* 147 */     return this.tmObjectName;
/*     */   }
/*     */ 
/*     */   public boolean isCreateTablesOnStartup() throws Exception
/*     */   {
/* 152 */     return this.createTablesOnStartup;
/*     */   }
/*     */ 
/*     */   public void setCreateTablesOnStartup(boolean b) throws Exception
/*     */   {
/* 157 */     this.createTablesOnStartup = b;
/*     */   }
/*     */ 
/*     */   protected TransactionManager getTransactionManagerReference()
/*     */   {
/* 169 */     if (this.tm == null)
/*     */     {
/* 171 */       this.tm = TransactionManagerLocator.getInstance().locate();
/*     */     }
/*     */ 
/* 174 */     return this.tm;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.jmx.JDBCServiceSupport
 * JD-Core Version:    0.6.0
 */