/*     */ package org.jboss.messaging.core.jmx;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.util.Properties;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.sql.DataSource;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.util.ExceptionUtil;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.tm.TransactionManagerLocator;
/*     */ 
/*     */ public class JDBCMBeanSupport extends ServiceMBeanSupport
/*     */ {
/*     */   protected DataSource ds;
/*     */   protected Properties sqlProperties;
/*     */   protected TransactionManager tm;
/*     */   private String dataSourceJNDIName;
/*  58 */   private boolean createTablesOnStartup = true;
/*     */   private ObjectName tmObjectName;
/*     */ 
/*     */   public JDBCMBeanSupport()
/*     */   {
/*  64 */     this.sqlProperties = new Properties();
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/*  73 */       if (this.ds == null)
/*     */       {
/*  75 */         InitialContext ic = new InitialContext();
/*  76 */         this.ds = ((DataSource)ic.lookup(this.dataSourceJNDIName));
/*  77 */         ic.close();
/*     */       }
/*     */ 
/*  80 */       if (this.ds == null)
/*     */       {
/*  82 */         throw new IllegalStateException("No DataSource found. This service dependencies must have not been enforced correctly!");
/*     */       }
/*     */ 
/*  86 */       this.log.debug(this + " started");
/*     */ 
/*  88 */       this.tm = getTransactionManagerReference();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  92 */       throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/*  98 */     this.log.debug(this + " stopped");
/*     */   }
/*     */ 
/*     */   public String getSqlProperties()
/*     */   {
/*     */     try
/*     */     {
/* 107 */       ByteArrayOutputStream boa = new ByteArrayOutputStream();
/* 108 */       this.sqlProperties.store(boa, "");
/* 109 */       return new String(boa.toByteArray());
/*     */     }
/*     */     catch (IOException shouldnothappen) {
/*     */     }
/* 113 */     return "";
/*     */   }
/*     */ 
/*     */   public void setSqlProperties(String value)
/*     */   {
/*     */     try
/*     */     {
/* 121 */       ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes());
/* 122 */       this.sqlProperties = new Properties();
/* 123 */       this.sqlProperties.load(is);
/*     */     }
/*     */     catch (IOException shouldnothappen)
/*     */     {
/* 127 */       this.log.error("Caught IOException", shouldnothappen);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setDataSource(String dataSourceJNDIName) throws Exception
/*     */   {
/* 133 */     this.dataSourceJNDIName = dataSourceJNDIName;
/*     */   }
/*     */ 
/*     */   public String getDataSource()
/*     */   {
/* 138 */     return this.dataSourceJNDIName;
/*     */   }
/*     */ 
/*     */   public void setTransactionManager(ObjectName tmObjectName) throws Exception
/*     */   {
/* 143 */     this.tmObjectName = tmObjectName;
/*     */   }
/*     */ 
/*     */   public ObjectName getTransactionManager()
/*     */   {
/* 148 */     return this.tmObjectName;
/*     */   }
/*     */ 
/*     */   public boolean isCreateTablesOnStartup() throws Exception
/*     */   {
/* 153 */     return this.createTablesOnStartup;
/*     */   }
/*     */ 
/*     */   public void setCreateTablesOnStartup(boolean b) throws Exception
/*     */   {
/* 158 */     this.createTablesOnStartup = b;
/*     */   }
/*     */ 
/*     */   private TransactionManager getTransactionManagerReference()
/*     */   {
/* 168 */     if (this.tm == null)
/*     */     {
/* 170 */       this.tm = TransactionManagerLocator.getInstance().locate();
/*     */     }
/*     */ 
/* 173 */     return this.tm;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.jmx.JDBCMBeanSupport
 * JD-Core Version:    0.6.0
 */