/*     */ package org.jboss.messaging.core.impl.tx;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.transaction.xa.Xid;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Binding;
/*     */ import org.jboss.messaging.core.contract.Delivery;
/*     */ import org.jboss.messaging.core.contract.Message;
/*     */ import org.jboss.messaging.core.contract.MessageReference;
/*     */ import org.jboss.messaging.core.contract.MessageStore;
/*     */ import org.jboss.messaging.core.contract.MessagingComponent;
/*     */ import org.jboss.messaging.core.contract.PersistenceManager;
/*     */ import org.jboss.messaging.core.contract.PersistenceManager.MessageChannelPair;
/*     */ import org.jboss.messaging.core.contract.PostOffice;
/*     */ import org.jboss.messaging.core.contract.Queue;
/*     */ import org.jboss.messaging.core.impl.IDManager;
/*     */ import org.jboss.messaging.core.impl.SimpleDelivery;
/*     */ 
/*     */ public class TransactionRepository
/*     */   implements MessagingComponent
/*     */ {
/*  61 */   private static final Logger log = Logger.getLogger(TransactionRepository.class);
/*     */ 
/*  65 */   private boolean trace = log.isTraceEnabled();
/*     */   private Map map;
/*     */   private PersistenceManager persistenceManager;
/*     */   protected MessageStore messageStore;
/*     */   private IDManager idManager;
/*     */   private PostOffice postOffice;
/*     */ 
/*     */   public TransactionRepository(PersistenceManager persistenceManager, MessageStore store, IDManager idManager)
/*     */   {
/*  83 */     this.persistenceManager = persistenceManager;
/*     */ 
/*  85 */     this.messageStore = store;
/*     */ 
/*  87 */     this.idManager = idManager;
/*     */ 
/*  89 */     this.map = new ConcurrentHashMap();
/*     */   }
/*     */ 
/*     */   public void injectPostOffice(PostOffice po)
/*     */   {
/*  98 */     this.postOffice = po;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public synchronized List recoverPreparedTransactions()
/*     */   {
/* 126 */     if (this.trace) log.trace(this + " recoverPreparedTransactions()");
/*     */ 
/* 128 */     ArrayList prepared = new ArrayList();
/*     */ 
/* 130 */     Iterator iter = this.map.values().iterator();
/*     */ 
/* 132 */     while (iter.hasNext())
/*     */     {
/* 134 */       Transaction tx = (Transaction)iter.next();
/*     */ 
/* 136 */       if ((tx.getXid() != null) && (tx.getState() == 1))
/*     */       {
/*     */         try
/*     */         {
/* 140 */           if (this.trace) log.trace("Loading and handling refs and acks to the Tx " + tx);
/*     */ 
/* 147 */           if (tx.isRecoveredFromStorage())
/*     */           {
/* 149 */             tx.loadState();
/*     */           }
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 154 */           log.warn("Failed to replay transaction (XID: " + tx.getXid() + ", LocalID: " + tx.getId() + ") during recovery.", e);
/*     */         }
/*     */ 
/* 157 */         prepared.add(tx.getXid());
/*     */       }
/*     */     }
/*     */ 
/* 161 */     if (this.trace) log.trace("Returning " + prepared.size() + " transactions");
/*     */ 
/* 163 */     return prepared;
/*     */   }
/*     */ 
/*     */   public void loadPreparedTransactions()
/*     */     throws Exception
/*     */   {
/* 172 */     if (this.trace) log.trace("load prepared transactions...");
/*     */ 
/* 174 */     List prepared = null;
/*     */ 
/* 176 */     prepared = this.persistenceManager.retrievePreparedTransactions();
/*     */ 
/* 178 */     if (this.trace) log.trace("found " + prepared.size() + " transactions in prepared state");
/*     */ 
/* 180 */     if (prepared != null)
/*     */     {
/* 182 */       Iterator iter = prepared.iterator();
/*     */ 
/* 184 */       while (iter.hasNext())
/*     */       {
/* 186 */         PreparedTxInfo txInfo = (PreparedTxInfo)iter.next();
/*     */ 
/* 191 */         if (!this.map.containsKey(txInfo.getXid()))
/*     */         {
/* 193 */           Transaction tx = createTransaction(txInfo);
/*     */ 
/* 195 */           tx.setState(1);
/*     */ 
/* 197 */           tx.setRecoveredFromStorage(true);
/*     */ 
/* 199 */           if (this.trace) log.trace("reinstating TX(XID: " + txInfo.getXid() + ", LocalId " + txInfo.getTxId() + ")");
/*     */ 
/*     */         }
/* 204 */         else if (this.trace) { log.trace("Not adding to map since it's already in map");
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public List getPreparedTransactions()
/*     */   {
/* 212 */     return new ArrayList(this.map.keySet());
/*     */   }
/*     */ 
/*     */   public Transaction getPreparedTx(Xid xid) throws Exception
/*     */   {
/* 217 */     Transaction tx = (Transaction)this.map.get(xid);
/*     */ 
/* 219 */     if (tx == null)
/*     */     {
/* 221 */       throw new TransactionException("Cannot find entry for xid:" + xid);
/*     */     }
/* 223 */     if (tx.getState() != 1)
/*     */     {
/* 225 */       throw new TransactionException("Transaction with xid " + xid + " is not in prepared state");
/*     */     }
/* 227 */     return tx;
/*     */   }
/*     */ 
/*     */   public void deleteTransaction(Transaction transaction) throws Exception
/*     */   {
/* 232 */     Xid id = transaction.getXid();
/* 233 */     int state = transaction.getState();
/*     */ 
/* 235 */     if (id == null)
/*     */     {
/* 237 */       throw new IllegalArgumentException("DeleteTransaction was called for non XA transaction");
/*     */     }
/*     */ 
/* 240 */     if ((state != 2) && (state != 3))
/*     */     {
/* 242 */       throw new TransactionException("Transaction with xid " + id + " can't be removed as it's not yet commited or rolledback: (Current state is " + Transaction.stateToString(state));
/*     */     }
/*     */ 
/* 245 */     this.map.remove(id);
/*     */   }
/*     */ 
/*     */   public Transaction createTransaction(Xid xid) throws Exception
/*     */   {
/* 250 */     if (this.map.containsKey(xid))
/*     */     {
/* 252 */       throw new TransactionException("There is already an entry for xid " + xid);
/*     */     }
/* 254 */     Transaction tx = new Transaction(this.idManager.getID(), xid, this);
/*     */ 
/* 256 */     if (this.trace) log.trace("created transaction " + tx);
/*     */ 
/* 258 */     this.map.put(xid, tx);
/*     */ 
/* 260 */     return tx;
/*     */   }
/*     */ 
/*     */   public Transaction createTransaction() throws Exception
/*     */   {
/* 265 */     Transaction tx = new Transaction(this.idManager.getID());
/*     */ 
/* 267 */     if (this.trace) log.trace("created transaction " + tx);
/*     */ 
/* 269 */     return tx;
/*     */   }
/*     */ 
/*     */   public boolean removeTransaction(Xid xid)
/*     */   {
/* 274 */     return this.map.remove(xid) != null;
/*     */   }
/*     */ 
/*     */   public int getNumberOfRegisteredTransactions()
/*     */   {
/* 280 */     return this.map.size();
/*     */   }
/*     */ 
/*     */   void handleReferences(Transaction tx)
/*     */     throws Exception
/*     */   {
/* 292 */     if (this.trace) log.trace("Handle references for TX(XID: " + tx.getXid() + ", LocalID: " + tx.getId() + "):");
/*     */ 
/* 294 */     long txId = tx.getId();
/*     */ 
/* 296 */     List pairs = this.persistenceManager.getMessageChannelPairRefsForTx(txId);
/*     */ 
/* 298 */     if (this.trace) log.trace("Found " + pairs.size() + " unhandled references.");
/*     */ 
/* 300 */     for (Iterator iter = pairs.iterator(); iter.hasNext(); )
/*     */     {
/* 302 */       PersistenceManager.MessageChannelPair pair = (PersistenceManager.MessageChannelPair)iter.next();
/*     */ 
/* 304 */       Message msg = pair.getMessage();
/*     */ 
/* 306 */       long channelID = pair.getChannelId();
/*     */ 
/* 308 */       MessageReference ref = this.messageStore.reference(msg);
/*     */ 
/* 310 */       ref.getMessage().setPersisted(true);
/*     */ 
/* 312 */       Binding binding = this.postOffice.getBindingForChannelID(channelID);
/*     */ 
/* 314 */       if (binding == null)
/*     */       {
/* 316 */         throw new IllegalStateException("Cannot find binding for channel id " + channelID);
/*     */       }
/*     */ 
/* 319 */       Queue queue = binding.queue;
/*     */ 
/* 321 */       if (this.trace) log.trace("Destination for message[ID=" + ref.getMessage().getMessageID() + "] is: " + queue);
/*     */ 
/* 326 */       boolean deactivate = false;
/*     */ 
/* 328 */       if (!queue.isActive())
/*     */       {
/* 330 */         queue.activate();
/*     */ 
/* 332 */         deactivate = true;
/*     */       }
/*     */ 
/* 335 */       queue.handle(null, ref, tx);
/*     */ 
/* 337 */       if (deactivate)
/*     */       {
/* 339 */         queue.deactivate();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   void handleAcks(Transaction tx)
/*     */     throws Exception
/*     */   {
/* 349 */     long txId = tx.getId();
/*     */ 
/* 351 */     List pairs = this.persistenceManager.getMessageChannelPairAcksForTx(txId);
/*     */ 
/* 353 */     if (this.trace) log.trace("Found " + pairs.size() + " unhandled acks.");
/*     */ 
/* 355 */     List dels = new ArrayList();
/*     */ 
/* 357 */     for (Iterator iter = pairs.iterator(); iter.hasNext(); )
/*     */     {
/* 359 */       PersistenceManager.MessageChannelPair pair = (PersistenceManager.MessageChannelPair)iter.next();
/*     */ 
/* 361 */       Message msg = pair.getMessage();
/*     */ 
/* 363 */       long channelID = pair.getChannelId();
/*     */ 
/* 365 */       MessageReference ref = null;
/*     */ 
/* 367 */       ref = this.messageStore.reference(msg);
/*     */ 
/* 369 */       ref.getMessage().setPersisted(true);
/*     */ 
/* 371 */       Binding binding = this.postOffice.getBindingForChannelID(channelID);
/*     */ 
/* 373 */       if (binding == null)
/*     */       {
/* 375 */         throw new IllegalStateException("Cannot find binding for channel id " + channelID);
/*     */       }
/*     */ 
/* 378 */       Queue queue = binding.queue;
/*     */ 
/* 380 */       if (this.trace) log.trace("Destination for message[ID=" + ref.getMessage().getMessageID() + "] is: " + queue);
/*     */ 
/* 383 */       Delivery del = new SimpleDelivery(queue, ref, true, true);
/*     */ 
/* 385 */       if (this.trace) log.trace("Acknowledging..");
/*     */ 
/*     */       try
/*     */       {
/* 392 */         boolean deactivate = false;
/*     */ 
/* 394 */         if (!queue.isActive())
/*     */         {
/* 396 */           queue.activate();
/*     */ 
/* 398 */           deactivate = true;
/*     */         }
/*     */ 
/* 401 */         del.acknowledge(tx);
/*     */ 
/* 403 */         if (deactivate)
/*     */         {
/* 405 */           queue.deactivate();
/*     */         }
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 410 */         log.error("Failed to acknowledge " + del + " during recovery", t);
/*     */       }
/*     */ 
/* 413 */       dels.add(del);
/*     */     }
/*     */ 
/* 416 */     if (!dels.isEmpty())
/*     */     {
/* 419 */       tx.addCallback(new CancelCallback(dels, null), this);
/*     */     }
/*     */   }
/*     */ 
/*     */   private Transaction createTransaction(PreparedTxInfo txInfo)
/*     */     throws Exception
/*     */   {
/* 438 */     if (this.map.containsKey(txInfo.getXid()))
/*     */     {
/* 440 */       throw new TransactionException("There is already an entry for xid " + txInfo.getXid());
/*     */     }
/*     */ 
/* 445 */     Transaction tx = new Transaction(txInfo.getTxId(), txInfo.getXid(), this);
/*     */ 
/* 447 */     if (this.trace) {
/* 448 */       log.trace("created transaction " + tx);
/*     */     }
/*     */ 
/* 451 */     this.map.put(txInfo.getXid(), tx);
/*     */ 
/* 453 */     return tx;
/*     */   }
/*     */ 
/*     */   private class CancelCallback
/*     */     implements TxCallback
/*     */   {
/*     */     private List toCancel;
/*     */ 
/*     */     private CancelCallback(List toCancel)
/*     */     {
/* 464 */       this.toCancel = toCancel;
/*     */     }
/*     */ 
/*     */     public void afterCommit(boolean onePhase)
/*     */       throws Exception
/*     */     {
/*     */     }
/*     */ 
/*     */     public void afterPrepare()
/*     */       throws Exception
/*     */     {
/*     */     }
/*     */ 
/*     */     public void afterRollback(boolean onePhase)
/*     */       throws Exception
/*     */     {
/* 483 */       for (int i = this.toCancel.size() - 1; i >= 0; i--)
/*     */       {
/* 485 */         Delivery del = (Delivery)this.toCancel.get(i);
/*     */         try
/*     */         {
/* 489 */           del.cancel();
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 493 */           TransactionRepository.log.error("Failed to cancel delivery", t);
/* 494 */           throw new TransactionException(t.getMessage(), t);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public void beforeCommit(boolean onePhase)
/*     */       throws Exception
/*     */     {
/*     */     }
/*     */ 
/*     */     public void beforePrepare()
/*     */       throws Exception
/*     */     {
/*     */     }
/*     */ 
/*     */     public void beforeRollback(boolean onePhase)
/*     */       throws Exception
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.tx.TransactionRepository
 * JD-Core Version:    0.6.0
 */