/*    */ package org.jboss.messaging.core.impl.postoffice;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ class UnbindRequest extends ClusterRequest
/*    */ {
/* 40 */   private static final Logger log = Logger.getLogger(UnbindRequest.class);
/*    */   private MappingInfo mappingInfo;
/*    */   private boolean allNodes;
/*    */ 
/*    */   UnbindRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   UnbindRequest(MappingInfo mappingInfo, boolean allNodes)
/*    */   {
/* 52 */     this.mappingInfo = mappingInfo;
/*    */ 
/* 54 */     this.allNodes = allNodes;
/*    */   }
/*    */ 
/*    */   Object execute(RequestTarget office) throws Exception
/*    */   {
/*    */     try
/*    */     {
/* 61 */       office.removeBindingFromCluster(this.mappingInfo, this.allNodes);
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 65 */       String s = "Failed to remove binding";
/* 66 */       log.error("Failed to remove binding", t);
/* 67 */       throw new Exception("Failed to remove binding", t);
/*    */     }
/*    */ 
/* 70 */     return null;
/*    */   }
/*    */ 
/*    */   byte getType()
/*    */   {
/* 75 */     return 4;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream in) throws Exception
/*    */   {
/* 80 */     this.mappingInfo = new MappingInfo();
/*    */ 
/* 82 */     this.mappingInfo.read(in);
/*    */ 
/* 84 */     this.allNodes = in.readBoolean();
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream out) throws Exception
/*    */   {
/* 89 */     this.mappingInfo.write(out);
/*    */ 
/* 91 */     out.writeBoolean(this.allNodes);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.UnbindRequest
 * JD-Core Version:    0.6.0
 */