/*     */ package org.jboss.messaging.core.impl.postoffice;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import org.jgroups.Address;
/*     */ import org.jgroups.stack.IpAddress;
/*     */ 
/*     */ public class ReplicateDeliveryMessage extends ClusterRequest
/*     */ {
/*     */   private int nodeID;
/*     */   private String queueName;
/*     */   private String sessionID;
/*     */   private long messageID;
/*     */   private long deliveryID;
/*     */   private Address returnAddress;
/*     */ 
/*     */   public ReplicateDeliveryMessage()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ReplicateDeliveryMessage(int nodeID, String queueName, String sessionID, long messageID, long deliveryID, Address returnAddress)
/*     */   {
/*  59 */     this.nodeID = nodeID;
/*     */ 
/*  61 */     this.queueName = queueName;
/*     */ 
/*  63 */     this.sessionID = sessionID;
/*     */ 
/*  65 */     this.messageID = messageID;
/*     */ 
/*  67 */     this.deliveryID = deliveryID;
/*     */ 
/*  69 */     this.returnAddress = returnAddress;
/*     */   }
/*     */ 
/*     */   Object execute(RequestTarget office) throws Throwable
/*     */   {
/*  74 */     office.handleReplicateDelivery(this.nodeID, this.queueName, this.sessionID, this.messageID, this.deliveryID, this.returnAddress);
/*     */ 
/*  76 */     return null;
/*     */   }
/*     */ 
/*     */   byte getType()
/*     */   {
/*  81 */     return 8;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in) throws Exception
/*     */   {
/*  86 */     this.nodeID = in.readInt();
/*     */ 
/*  88 */     this.queueName = in.readUTF();
/*     */ 
/*  90 */     this.sessionID = in.readUTF();
/*     */ 
/*  92 */     this.messageID = in.readLong();
/*     */ 
/*  94 */     this.deliveryID = in.readLong();
/*     */ 
/*  96 */     byte b = in.readByte();
/*     */ 
/*  98 */     if (b != 0)
/*     */     {
/* 100 */       this.returnAddress = new IpAddress();
/*     */ 
/* 102 */       this.returnAddress.readFrom(in);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out) throws Exception
/*     */   {
/* 108 */     out.writeInt(this.nodeID);
/*     */ 
/* 110 */     out.writeUTF(this.queueName);
/*     */ 
/* 112 */     out.writeUTF(this.sessionID);
/*     */ 
/* 114 */     out.writeLong(this.messageID);
/*     */ 
/* 116 */     out.writeLong(this.deliveryID);
/*     */ 
/* 118 */     if (this.returnAddress == null)
/*     */     {
/* 120 */       out.writeByte(0);
/*     */     }
/*     */     else
/*     */     {
/* 124 */       out.writeByte(1);
/*     */ 
/* 126 */       if (!(this.returnAddress instanceof IpAddress))
/*     */       {
/* 128 */         throw new IllegalStateException("Address must be IpAddress");
/*     */       }
/*     */ 
/* 131 */       this.returnAddress.writeTo(out);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.ReplicateDeliveryMessage
 * JD-Core Version:    0.6.0
 */