/*    */ package org.jboss.messaging.core.impl.postoffice;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ 
/*    */ public class ReplicateDeliveryAckMessage extends ClusterRequest
/*    */ {
/*    */   private String sessionID;
/*    */   private long deliveryID;
/*    */ 
/*    */   public ReplicateDeliveryAckMessage()
/*    */   {
/*    */   }
/*    */ 
/*    */   public ReplicateDeliveryAckMessage(String sessionID, long deliveryID)
/*    */   {
/* 47 */     this.sessionID = sessionID;
/*    */ 
/* 49 */     this.deliveryID = deliveryID;
/*    */   }
/*    */ 
/*    */   Object execute(RequestTarget office) throws Throwable
/*    */   {
/* 54 */     office.handleReplicateDeliveryAck(this.sessionID, this.deliveryID);
/*    */ 
/* 56 */     return null;
/*    */   }
/*    */ 
/*    */   byte getType()
/*    */   {
/* 61 */     return 9;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream in) throws Exception
/*    */   {
/* 66 */     this.sessionID = in.readUTF();
/*    */ 
/* 68 */     this.deliveryID = in.readLong();
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream out) throws Exception
/*    */   {
/* 73 */     out.writeUTF(this.sessionID);
/*    */ 
/* 75 */     out.writeLong(this.deliveryID);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.ReplicateDeliveryAckMessage
 * JD-Core Version:    0.6.0
 */