/*    */ package org.jboss.messaging.core.impl.postoffice;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import java.io.Serializable;
/*    */ import org.jboss.messaging.util.StreamUtils;
/*    */ 
/*    */ class RemoveReplicantRequest extends ClusterRequest
/*    */ {
/*    */   private int nodeId;
/*    */   private Serializable key;
/*    */ 
/*    */   RemoveReplicantRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   RemoveReplicantRequest(int nodeId, Serializable key)
/*    */   {
/* 50 */     this.nodeId = nodeId;
/*    */ 
/* 52 */     this.key = key;
/*    */   }
/*    */ 
/*    */   Object execute(RequestTarget office) throws Exception
/*    */   {
/* 57 */     if (!office.removeReplicantLocally(this.nodeId, this.key))
/*    */     {
/* 59 */       throw new IllegalStateException("Failed to remove replicant locally: " + this.nodeId + " key: " + this.key);
/*    */     }
/*    */ 
/* 62 */     return null;
/*    */   }
/*    */ 
/*    */   byte getType()
/*    */   {
/* 67 */     return 7;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream in) throws Exception
/*    */   {
/* 72 */     this.nodeId = in.readInt();
/*    */ 
/* 74 */     this.key = ((Serializable)StreamUtils.readObject(in, true));
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream out) throws Exception
/*    */   {
/* 79 */     out.writeInt(this.nodeId);
/*    */ 
/* 81 */     StreamUtils.writeObject(out, this.key, true, true);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.RemoveReplicantRequest
 * JD-Core Version:    0.6.0
 */