/*    */ package org.jboss.messaging.core.impl.postoffice;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jgroups.Address;
/*    */ import org.jgroups.stack.IpAddress;
/*    */ 
/*    */ public class GetReplicatedDeliveriesRequest extends ClusterRequest
/*    */ {
/*    */   private String queueName;
/*    */   private Address returnAddress;
/*    */ 
/*    */   public GetReplicatedDeliveriesRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public GetReplicatedDeliveriesRequest(String queueName, Address returnAddress)
/*    */   {
/* 50 */     this.queueName = queueName;
/*    */ 
/* 52 */     this.returnAddress = returnAddress;
/*    */   }
/*    */ 
/*    */   Object execute(RequestTarget office) throws Throwable
/*    */   {
/* 57 */     office.handleGetReplicatedDeliveries(this.queueName, this.returnAddress);
/*    */ 
/* 59 */     return null;
/*    */   }
/*    */ 
/*    */   byte getType()
/*    */   {
/* 64 */     return 13;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream in) throws Exception
/*    */   {
/* 69 */     this.queueName = in.readUTF();
/*    */ 
/* 71 */     byte b = in.readByte();
/*    */ 
/* 73 */     if (b != 0)
/*    */     {
/* 75 */       this.returnAddress = new IpAddress();
/*    */ 
/* 77 */       this.returnAddress.readFrom(in);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream out) throws Exception
/*    */   {
/* 83 */     out.writeUTF(this.queueName);
/*    */ 
/* 85 */     if (this.returnAddress == null)
/*    */     {
/* 87 */       out.writeByte(0);
/*    */     }
/*    */     else
/*    */     {
/* 91 */       out.writeByte(1);
/*    */ 
/* 93 */       if (!(this.returnAddress instanceof IpAddress))
/*    */       {
/* 95 */         throw new IllegalStateException("Address must be IpAddress");
/*    */       }
/*    */ 
/* 98 */       this.returnAddress.writeTo(out);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.postoffice.GetReplicatedDeliveriesRequest
 * JD-Core Version:    0.6.0
 */