/*     */ package org.jboss.messaging.core.impl;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Delivery;
/*     */ import org.jboss.messaging.core.contract.DeliveryObserver;
/*     */ import org.jboss.messaging.core.contract.MessageReference;
/*     */ import org.jboss.messaging.core.impl.tx.Transaction;
/*     */ 
/*     */ public class SimpleDelivery
/*     */   implements Delivery
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(SimpleDelivery.class);
/*     */   private boolean selectorAccepted;
/*     */   private DeliveryObserver observer;
/*     */   private MessageReference reference;
/*     */   private boolean recovered;
/*  54 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public SimpleDelivery()
/*     */   {
/*  60 */     this(null, null);
/*     */   }
/*     */ 
/*     */   public SimpleDelivery(DeliveryObserver observer, MessageReference reference)
/*     */   {
/*  65 */     this(observer, reference, true, false);
/*     */   }
/*     */ 
/*     */   public SimpleDelivery(DeliveryObserver observer, MessageReference reference, boolean selectorAccepted, boolean recovered)
/*     */   {
/*  72 */     this.reference = reference;
/*  73 */     this.observer = observer;
/*  74 */     this.selectorAccepted = selectorAccepted;
/*  75 */     this.recovered = recovered;
/*     */   }
/*     */ 
/*     */   public MessageReference getReference()
/*     */   {
/*  82 */     return this.reference;
/*     */   }
/*     */ 
/*     */   public boolean isSelectorAccepted()
/*     */   {
/*  87 */     return this.selectorAccepted;
/*     */   }
/*     */ 
/*     */   public DeliveryObserver getObserver()
/*     */   {
/*  92 */     return this.observer;
/*     */   }
/*     */ 
/*     */   public void acknowledge(Transaction tx) throws Throwable
/*     */   {
/*  97 */     if (this.trace) log.trace(this + " acknowledging delivery " + (tx == null ? "non-transactionally" : new StringBuilder().append("in ").append(tx).toString()));
/*     */ 
/*  99 */     this.observer.acknowledge(this, tx);
/*     */   }
/*     */ 
/*     */   public void cancel() throws Throwable
/*     */   {
/* 104 */     if (this.trace) log.trace(this + " cancelling delivery");
/*     */ 
/* 106 */     this.observer.cancel(this);
/*     */   }
/*     */ 
/*     */   public boolean isRecovered()
/*     */   {
/* 111 */     return this.recovered;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 118 */     return "Delivery" + (this.reference == null ? "" : new StringBuilder().append("[").append(this.reference).append("]").toString());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.SimpleDelivery
 * JD-Core Version:    0.6.0
 */