/*      */ package org.jboss.messaging.core.impl;
/*      */ 
/*      */ import java.io.BufferedInputStream;
/*      */ import java.io.ByteArrayInputStream;
/*      */ import java.io.ByteArrayOutputStream;
/*      */ import java.io.DataInputStream;
/*      */ import java.io.DataOutputStream;
/*      */ import java.io.InputStream;
/*      */ import java.sql.Connection;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Statement;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collections;
/*      */ import java.util.Comparator;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.LinkedHashMap;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Properties;
/*      */ import java.util.Set;
/*      */ import javax.sql.DataSource;
/*      */ import javax.transaction.TransactionManager;
/*      */ import javax.transaction.xa.Xid;
/*      */ import org.jboss.jms.tx.MessagingXid;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.messaging.core.contract.Message;
/*      */ import org.jboss.messaging.core.contract.MessageReference;
/*      */ import org.jboss.messaging.core.contract.PersistenceManager;
/*      */ import org.jboss.messaging.core.contract.PersistenceManager.InitialLoadInfo;
/*      */ import org.jboss.messaging.core.contract.PersistenceManager.MessageChannelPair;
/*      */ import org.jboss.messaging.core.contract.PersistenceManager.ReferenceInfo;
/*      */ import org.jboss.messaging.core.impl.message.MessageFactory;
/*      */ import org.jboss.messaging.core.impl.message.MessageSupport;
/*      */ import org.jboss.messaging.core.impl.tx.PreparedTxInfo;
/*      */ import org.jboss.messaging.core.impl.tx.Transaction;
/*      */ import org.jboss.messaging.core.impl.tx.TxCallback;
/*      */ import org.jboss.messaging.util.JDBCUtil;
/*      */ import org.jboss.messaging.util.StreamUtils;
/*      */ import org.jboss.messaging.util.Util;
/*      */ 
/*      */ public class JDBCPersistenceManager extends JDBCSupport
/*      */   implements PersistenceManager
/*      */ {
/*   82 */   private static final Logger log = Logger.getLogger(JDBCPersistenceManager.class);
/*      */ 
/*   86 */   private boolean trace = log.isTraceEnabled();
/*      */ 
/*   88 */   private boolean usingBinaryStream = true;
/*      */ 
/*   90 */   private boolean usingTrailingByte = false;
/*      */   private int maxParams;
/*      */   private short orderCount;
/*      */   private int nodeID;
/*      */   private boolean nodeIDSet;
/*      */   private boolean supportsBlobSelect;
/*      */ 
/*      */   public JDBCPersistenceManager(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup, boolean usingBatchUpdates, boolean usingBinaryStream, boolean usingTrailingByte, int maxParams, boolean supportsBlobSelect)
/*      */   {
/*  111 */     super(ds, tm, sqlProperties, createTablesOnStartup);
/*      */ 
/*  115 */     this.usingBinaryStream = usingBinaryStream;
/*      */ 
/*  117 */     this.usingTrailingByte = usingTrailingByte;
/*      */ 
/*  119 */     this.maxParams = maxParams;
/*      */ 
/*  121 */     this.supportsBlobSelect = supportsBlobSelect;
/*      */   }
/*      */ 
/*      */   public void start()
/*      */     throws Exception
/*      */   {
/*  129 */     super.start();
/*      */ 
/*  131 */     Connection conn = null;
/*      */ 
/*  133 */     PreparedStatement ps = null;
/*      */ 
/*  135 */     JDBCSupport.TransactionWrapper wrap = new JDBCSupport.TransactionWrapper(this);
/*      */     try
/*      */     {
/*  139 */       conn = this.ds.getConnection();
/*      */ 
/*  142 */       if (conn.getTransactionIsolation() != 2)
/*      */       {
/*  144 */         int level = conn.getTransactionIsolation();
/*      */ 
/*  146 */         String warn = "\n\nJBoss Messaging Warning: DataSource connection transaction isolation should be READ_COMMITTED, but it is currently " + Util.transactionIsolationToString(level) + ".\n" + "                         Using an isolation level less strict than READ_COMMITTED may lead to data consistency problems.\n" + "                         Using an isolation level more strict than READ_COMMITTED may lead to deadlock.\n";
/*      */ 
/*  151 */         log.warn(warn);
/*      */       }
/*      */ 
/*  154 */       log.debug("Adding record on JBM_DUAL");
/*      */ 
/*  157 */       ps = conn.prepareStatement(getSQLStatement("INSERT_DUAL"));
/*      */       try
/*      */       {
/*  161 */         int rows = ps.executeUpdate();
/*      */ 
/*  163 */         if (this.trace) log.trace("Inserted " + rows + " rows into dual");
/*      */       }
/*      */       catch (SQLException e)
/*      */       {
/*  167 */         wrap.exceptionOccurred();
/*  168 */         wrap.end();
/*  169 */         wrap = new JDBCSupport.TransactionWrapper(this);
/*      */ 
/*  171 */         log.debug("Checking for existance on JBM_DUAL");
/*      */ 
/*  173 */         Statement selectCount = conn.createStatement();
/*  174 */         ResultSet rset = selectCount.executeQuery(getSQLStatement("CHECK_DUAL"));
/*      */         try
/*      */         {
/*  179 */           if (!rset.next())
/*      */           {
/*  181 */             log.debug("JBM_DUAL didn't have a record.. throwing exception", e);
/*  182 */             throw e;
/*      */           }
/*      */ 
/*  187 */           if (rset.next())
/*      */           {
/*  189 */             log.debug("duplicated record found on JBM_DUAL... throwing exception");
/*  190 */             throw new IllegalStateException("JBM_DUAL is missing a primary key as it allowed a duplicate value");
/*      */           }
/*      */         }
/*      */         finally
/*      */         {
/*      */           try
/*      */           {
/*  197 */             rset.close();
/*  198 */             selectCount.close();
/*      */           }
/*      */           catch (Throwable ignored)
/*      */           {
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  208 */       wrap.exceptionOccurred();
/*  209 */       throw e;
/*      */     }
/*      */     finally
/*      */     {
/*  213 */       closeStatement(ps);
/*  214 */       closeConnection(conn);
/*  215 */       wrap.end();
/*      */     }
/*      */ 
/*  218 */     log.debug(this + " started");
/*      */   }
/*      */ 
/*      */   public void injectNodeID(int nodeID)
/*      */   {
/*  227 */     this.nodeID = nodeID;
/*      */ 
/*  229 */     this.nodeIDSet = true;
/*      */   }
/*      */ 
/*      */   public List getMessageChannelPairRefsForTx(long transactionId)
/*      */     throws Exception
/*      */   {
/*  239 */     String sql = getSQLStatement("SELECT_MESSAGE_ID_FOR_REF");
/*  240 */     return getMessageChannelPair(sql, transactionId);
/*      */   }
/*      */ 
/*      */   public List getMessageChannelPairAcksForTx(long transactionId) throws Exception
/*      */   {
/*  245 */     String sql = getSQLStatement("SELECT_MESSAGE_ID_FOR_ACK");
/*  246 */     return getMessageChannelPair(sql, transactionId);
/*      */   }
/*      */ 
/*      */   public List retrievePreparedTransactions() throws Exception
/*      */   {
/*  251 */     if (!this.nodeIDSet)
/*      */     {
/*  254 */       throw new IllegalStateException("Node id has not been set");
/*      */     }
/*      */ 
/*  260 */     Connection conn = null;
/*  261 */     PreparedStatement st = null;
/*  262 */     ResultSet rs = null;
/*  263 */     PreparedTxInfo txInfo = null;
/*  264 */     JDBCSupport.TransactionWrapper wrap = new JDBCSupport.TransactionWrapper(this);
/*      */     try
/*      */     {
/*  268 */       List transactions = new ArrayList();
/*      */ 
/*  270 */       conn = this.ds.getConnection();
/*      */ 
/*  272 */       st = conn.prepareStatement(getSQLStatement("SELECT_PREPARED_TRANSACTIONS"));
/*      */ 
/*  274 */       st.setInt(1, this.nodeID);
/*      */ 
/*  276 */       rs = st.executeQuery();
/*      */ 
/*  278 */       while (rs.next())
/*      */       {
/*  281 */         txId = rs.getLong(1);
/*      */ 
/*  283 */         byte[] branchQual = getVarBinaryColumn(rs, 2);
/*      */ 
/*  285 */         int formatId = rs.getInt(3);
/*      */ 
/*  287 */         byte[] globalTxId = getVarBinaryColumn(rs, 4);
/*      */ 
/*  289 */         Xid xid = new MessagingXid(branchQual, formatId, globalTxId);
/*      */ 
/*  292 */         txInfo = new PreparedTxInfo(txId, xid);
/*      */ 
/*  294 */         transactions.add(txInfo);
/*      */       }
/*      */ 
/*  297 */       long txId = transactions;
/*      */       return txId;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  302 */       wrap.exceptionOccurred();
/*  303 */       throw e;
/*      */     }
/*      */     finally
/*      */     {
/*  307 */       closeResultSet(rs);
/*  308 */       closeStatement(st);
/*  309 */       closeConnection(conn);
/*  310 */       wrap.end();
/*  311 */     }throw localObject;
/*      */   }
/*      */ 
/*      */   public long reserveIDBlock(String counterName, int size)
/*      */     throws Exception
/*      */   {
/*  319 */     if (this.trace) log.trace("Getting ID block for counter " + counterName + ", size " + size);
/*      */ 
/*  321 */     if (size <= 0)
/*      */     {
/*  323 */       throw new IllegalArgumentException("block size must be > 0");
/*      */     }
/*      */ 
/*  396 */     return ((Long)new JDBCSupport.JDBCTxRunner2(counterName, size)
/*      */     {
/*      */       public Long doTransaction()
/*      */         throws Exception
/*      */       {
/*  332 */         String selectCounterSQL = this.this$0.getSQLStatement("SELECT_COUNTER");
/*      */ 
/*  334 */         PreparedStatement ps = null;
/*  335 */         ResultSet rs = null;
/*      */         try
/*      */         {
/*  339 */           ps = this.conn.prepareStatement(selectCounterSQL);
/*      */ 
/*  341 */           ps.setString(1, this.val$counterName);
/*      */ 
/*  343 */           rs = ps.executeQuery();
/*      */ 
/*  345 */           if (this.this$0.trace) JDBCPersistenceManager.log.trace(JDBCUtil.statementToString(selectCounterSQL, this.val$counterName));
/*      */ 
/*  347 */           if (!rs.next())
/*      */           {
/*  349 */             rs.close();
/*  350 */             rs = null;
/*      */ 
/*  352 */             ps.close();
/*      */ 
/*  358 */             String insertCounterSQL = this.this$0.getSQLStatement("INSERT_COUNTER");
/*      */ 
/*  360 */             ps = this.conn.prepareStatement(insertCounterSQL);
/*      */ 
/*  362 */             ps.setString(1, this.val$counterName);
/*  363 */             ps.setLong(2, this.val$size);
/*      */ 
/*  365 */             int rows = ps.executeUpdate();
/*  366 */             if (this.this$0.trace) JDBCPersistenceManager.log.trace(JDBCUtil.statementToString(insertCounterSQL, this.val$counterName, new Integer(this.val$size)) + " inserted " + rows + " rows");
/*      */ 
/*  368 */             Long localLong1 = Long.valueOf(0L);
/*      */             return localLong1;
/*      */           }
/*  371 */           long nextId = rs.getLong(1);
/*      */ 
/*  373 */           ps.close();
/*      */ 
/*  375 */           String updateCounterSQL = this.this$0.getSQLStatement("UPDATE_COUNTER");
/*      */ 
/*  377 */           ps = this.conn.prepareStatement(updateCounterSQL);
/*      */ 
/*  379 */           ps.setLong(1, nextId + this.val$size);
/*  380 */           ps.setString(2, this.val$counterName);
/*      */ 
/*  382 */           int rows = ps.executeUpdate();
/*      */ 
/*  384 */           if (this.this$0.trace) JDBCPersistenceManager.log.trace(JDBCUtil.statementToString(updateCounterSQL, new Long(nextId + this.val$size), this.val$counterName) + " updated " + rows + " rows");
/*      */ 
/*  386 */           Long localLong2 = Long.valueOf(nextId);
/*      */           return localLong2;
/*      */         }
/*      */         finally
/*      */         {
/*  390 */           this.this$0.closeResultSet(rs);
/*  391 */           this.this$0.closeStatement(ps);
/*  392 */         }throw localObject;
/*      */       }
/*      */     }
/*      */ 
/*  396 */     .executeWithRetry()).longValue();
/*      */   }
/*      */ 
/*      */   public List getMessages(List messageIds)
/*      */     throws Exception
/*      */   {
/*  410 */     if (this.trace) log.trace("Getting batch of messages for " + messageIds);
/*      */ 
/*  524 */     return (List)new JDBCSupport.JDBCTxRunner2(messageIds)
/*      */     {
/*      */       public List<Message> doTransaction()
/*      */         throws Exception
/*      */       {
/*  417 */         PreparedStatement ps = null;
/*  418 */         ResultSet rs = null;
/*      */         try
/*      */         {
/*  422 */           Iterator iter = this.val$messageIds.iterator();
/*      */ 
/*  424 */           int size = this.val$messageIds.size();
/*      */ 
/*  426 */           int count = 0;
/*      */ 
/*  428 */           List msgs = new ArrayList();
/*      */ 
/*  430 */           while (iter.hasNext())
/*      */           {
/*  432 */             if (ps == null)
/*      */             {
/*      */               int numParams;
/*      */               int numParams;
/*  437 */               if (count < size / this.this$0.maxParams * this.this$0.maxParams)
/*      */               {
/*  439 */                 numParams = this.this$0.maxParams;
/*      */               }
/*      */               else
/*      */               {
/*  443 */                 numParams = size % this.this$0.maxParams;
/*      */               }
/*  445 */               StringBuffer buff = new StringBuffer(this.this$0.getSQLStatement("LOAD_MESSAGES"));
/*  446 */               buff.append(" WHERE ").append(this.this$0.getSQLStatement("MESSAGE_ID_COLUMN")).append(" IN (");
/*  447 */               for (int i = 0; i < numParams; i++)
/*      */               {
/*  449 */                 buff.append("?");
/*  450 */                 if (i >= numParams - 1)
/*      */                   continue;
/*  452 */                 buff.append(",");
/*      */               }
/*      */ 
/*  455 */               buff.append(")");
/*  456 */               ps = this.conn.prepareStatement(buff.toString());
/*      */ 
/*  458 */               if (this.this$0.trace)
/*      */               {
/*  460 */                 JDBCPersistenceManager.log.trace(buff.toString());
/*      */               }
/*      */             }
/*      */ 
/*  464 */             msgId = ((Long)iter.next()).longValue();
/*      */ 
/*  466 */             ps.setLong(count % this.this$0.maxParams + 1, msgId);
/*      */ 
/*  468 */             count++;
/*      */ 
/*  470 */             if ((!iter.hasNext()) || (count % this.this$0.maxParams == 0))
/*      */             {
/*  472 */               rs = ps.executeQuery();
/*      */ 
/*  474 */               while (rs.next())
/*      */               {
/*  476 */                 long messageId = rs.getLong(1);
/*      */ 
/*  478 */                 boolean reliable = rs.getString(2).equals("Y");
/*      */ 
/*  480 */                 long expiration = rs.getLong(3);
/*      */ 
/*  482 */                 long timestamp = rs.getLong(4);
/*      */ 
/*  484 */                 byte priority = rs.getByte(5);
/*      */ 
/*  486 */                 byte[] bytes = this.this$0.getBytes(rs, 6);
/*      */ 
/*  488 */                 HashMap headers = this.this$0.bytesToMap(bytes);
/*      */ 
/*  490 */                 byte[] payload = this.this$0.getBytes(rs, 7);
/*      */ 
/*  492 */                 byte type = rs.getByte(8);
/*      */ 
/*  494 */                 Message m = MessageFactory.createMessage(messageId, reliable, expiration, timestamp, priority, headers, payload, type);
/*      */ 
/*  496 */                 msgs.add(m);
/*      */               }
/*      */ 
/*  499 */               rs.close();
/*  500 */               rs = null;
/*      */ 
/*  502 */               ps.close();
/*  503 */               ps = null;
/*      */             }
/*      */           }
/*      */ 
/*  507 */           if (this.this$0.trace) JDBCPersistenceManager.log.trace("Loaded " + msgs.size() + " messages in total");
/*      */ 
/*  509 */           long msgId = msgs;
/*      */           return msgId;
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/*  513 */           throw e;
/*      */         }
/*      */         finally
/*      */         {
/*  517 */           this.this$0.closeResultSet(rs);
/*  518 */           this.this$0.closeStatement(ps);
/*  519 */         }throw localObject;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  524 */     .executeWithRetry();
/*      */   }
/*      */ 
/*      */   public void pageReferences(long channelID, List references, boolean page)
/*      */     throws Exception
/*      */   {
/*  537 */     if (this.trace) log.trace("Paging references in channel " + channelID + " refs " + references.size());
/*      */ 
/*  602 */     new JDBCSupport.JDBCTxRunner2(references, channelID, page)
/*      */     {
/*      */       public Object doTransaction()
/*      */         throws Exception
/*      */       {
/*  543 */         PreparedStatement psInsertReference = null;
/*  544 */         PreparedStatement psInsertMessage = null;
/*  545 */         PreparedStatement psUpdateMessage = null;
/*      */         try
/*      */         {
/*  549 */           Iterator iter = this.val$references.iterator();
/*      */ 
/*  551 */           psInsertReference = this.conn.prepareStatement(this.this$0.getSQLStatement("INSERT_MESSAGE_REF"));
/*      */ 
/*  553 */           if (this.this$0.supportsBlobSelect)
/*      */           {
/*  555 */             psInsertMessage = this.conn.prepareStatement(this.this$0.getSQLStatement("INSERT_MESSAGE_CONDITIONAL_FULL"));
/*      */           }
/*      */           else
/*      */           {
/*  559 */             psInsertMessage = this.conn.prepareStatement(this.this$0.getSQLStatement("INSERT_MESSAGE_CONDITIONAL"));
/*  560 */             psUpdateMessage = this.conn.prepareStatement(this.this$0.getSQLStatement("UPDATE_MESSAGE_4CONDITIONAL"));
/*      */           }
/*      */ 
/*  563 */           while (iter.hasNext())
/*      */           {
/*  566 */             ref = (MessageReference)iter.next();
/*      */ 
/*  572 */             JDBCPersistenceManager.log.trace("Paged ref with page order " + ref.getPagingOrder());
/*      */ 
/*  574 */             this.this$0.addReference(this.val$channelID, ref, psInsertReference, this.val$page);
/*      */ 
/*  576 */             int rows = psInsertReference.executeUpdate();
/*      */ 
/*  578 */             if (this.this$0.trace)
/*      */             {
/*  580 */               JDBCPersistenceManager.log.trace("Inserted " + rows + " rows");
/*      */             }
/*      */ 
/*  584 */             Message m = ref.getMessage();
/*      */ 
/*  586 */             rows = this.this$0.storeMessage(m, psInsertMessage, psUpdateMessage);
/*      */ 
/*  588 */             if (this.this$0.trace) JDBCPersistenceManager.log.trace("Inserted " + rows + " rows");
/*      */           }
/*      */ 
/*  591 */           MessageReference ref = null;
/*      */           return ref;
/*      */         }
/*      */         finally
/*      */         {
/*  595 */           this.this$0.closeStatement(psInsertReference);
/*  596 */           this.this$0.closeStatement(psInsertMessage);
/*  597 */           this.this$0.closeStatement(psUpdateMessage);
/*  598 */         }throw localObject;
/*      */       }
/*      */     }
/*      */ 
/*  602 */     .executeWithRetry();
/*      */   }
/*      */ 
/*      */   public void removeDepagedReferences(long channelID, List references)
/*      */     throws Exception
/*      */   {
/*  608 */     if (this.trace) log.trace(this + " Removing depaged " + references.size() + " refs from channel " + channelID);
/*      */ 
/*  643 */     new JDBCSupport.JDBCTxRunner2(references, channelID)
/*      */     {
/*      */       public Object doTransaction()
/*      */         throws Exception
/*      */       {
/*  614 */         PreparedStatement psDeleteReference = null;
/*      */         try
/*      */         {
/*  618 */           psDeleteReference = this.conn.prepareStatement(this.this$0.getSQLStatement("DELETE_MESSAGE_REF"));
/*      */ 
/*  620 */           Iterator iter = this.val$references.iterator();
/*      */ 
/*  622 */           while (iter.hasNext())
/*      */           {
/*  624 */             ref = (MessageReference)iter.next();
/*      */ 
/*  626 */             this.this$0.removeReference(this.val$channelID, ref, psDeleteReference);
/*      */ 
/*  628 */             int rows = psDeleteReference.executeUpdate();
/*      */ 
/*  630 */             if (this.this$0.trace) JDBCPersistenceManager.log.trace("Deleted " + rows + " references");
/*      */ 
/*      */           }
/*      */ 
/*  634 */           MessageReference ref = null;
/*      */           return ref;
/*      */         }
/*      */         finally
/*      */         {
/*  638 */           this.this$0.closeStatement(psDeleteReference);
/*  639 */         }throw localObject;
/*      */       }
/*      */     }
/*      */ 
/*  643 */     .executeWithRetry();
/*      */ 
/*  645 */     deleteMessages(references);
/*      */   }
/*      */ 
/*      */   public void updateReferencesNotPagedInRange(long channelID, long orderStart, long orderEnd, long num)
/*      */     throws Exception
/*      */   {
/*  651 */     if (this.trace) log.trace("Updating paged references for channel " + channelID + " between " + orderStart + " and " + orderEnd);
/*      */ 
/*  689 */     new JDBCSupport.JDBCTxRunner2(orderStart, orderEnd, channelID, num)
/*      */     {
/*      */       public Object doTransaction()
/*      */         throws Exception
/*      */       {
/*  657 */         PreparedStatement ps = null;
/*      */         try
/*      */         {
/*  661 */           ps = this.conn.prepareStatement(this.this$0.getSQLStatement("UPDATE_REFS_NOT_PAGED"));
/*      */ 
/*  663 */           ps.setLong(1, this.val$orderStart);
/*      */ 
/*  665 */           ps.setLong(2, this.val$orderEnd);
/*      */ 
/*  667 */           ps.setLong(3, this.val$channelID);
/*      */ 
/*  669 */           int rows = ps.executeUpdate();
/*      */ 
/*  671 */           if (this.this$0.trace) JDBCPersistenceManager.log.trace(JDBCUtil.statementToString(this.this$0.getSQLStatement("UPDATE_REFS_NOT_PAGED"), new Long(this.val$channelID), new Long(this.val$orderStart), new Long(this.val$orderEnd)) + " updated " + rows + " rows");
/*      */ 
/*  675 */           if (rows != this.val$num)
/*      */           {
/*  677 */             throw new IllegalStateException("Did not update correct number of rows");
/*      */           }
/*      */ 
/*  680 */           Object localObject1 = null;
/*      */           return localObject1;
/*      */         }
/*      */         finally
/*      */         {
/*  684 */           this.this$0.closeStatement(ps);
/*  685 */         }throw localObject2;
/*      */       }
/*      */     }
/*      */ 
/*  689 */     .executeWithRetry();
/*      */   }
/*      */ 
/*      */   public void updatePageOrder(long channelID, List references) throws Exception
/*      */   {
/*  694 */     if (this.trace) log.trace("Updating page order for channel:" + channelID);
/*      */ 
/*  731 */     new JDBCSupport.JDBCTxRunner2(references, channelID)
/*      */     {
/*      */       public Object doTransaction()
/*      */         throws Exception
/*      */       {
/*  700 */         PreparedStatement psUpdateReference = null;
/*      */         try
/*      */         {
/*  703 */           Iterator iter = this.val$references.iterator();
/*      */ 
/*  705 */           psUpdateReference = this.conn.prepareStatement(this.this$0.getSQLStatement("UPDATE_PAGE_ORDER"));
/*      */ 
/*  707 */           while (iter.hasNext())
/*      */           {
/*  709 */             ref = (MessageReference)iter.next();
/*      */ 
/*  711 */             psUpdateReference.setLong(1, ref.getPagingOrder());
/*      */ 
/*  713 */             psUpdateReference.setLong(2, ref.getMessage().getMessageID());
/*      */ 
/*  715 */             psUpdateReference.setLong(3, this.val$channelID);
/*      */ 
/*  717 */             int rows = psUpdateReference.executeUpdate();
/*      */ 
/*  719 */             if (this.this$0.trace) JDBCPersistenceManager.log.trace("Updated " + rows + " rows");
/*      */           }
/*      */ 
/*  722 */           MessageReference ref = null;
/*      */           return ref;
/*      */         }
/*      */         finally
/*      */         {
/*  726 */           this.this$0.closeStatement(psUpdateReference);
/*  727 */         }throw localObject;
/*      */       }
/*      */     }
/*      */ 
/*  731 */     .executeWithRetry();
/*      */   }
/*      */ 
/*      */   public List getPagedReferenceInfos(long channelID, long orderStart, int number) throws Exception
/*      */   {
/*  736 */     if (this.trace) log.trace("loading message reference info for channel " + channelID + " from " + orderStart + " number " + number);
/*      */ 
/*  738 */     List refs = new ArrayList();
/*      */ 
/*  740 */     Connection conn = null;
/*  741 */     PreparedStatement ps = null;
/*  742 */     ResultSet rs = null;
/*  743 */     JDBCSupport.TransactionWrapper wrap = new JDBCSupport.TransactionWrapper(this);
/*      */     try
/*      */     {
/*  747 */       conn = this.ds.getConnection();
/*      */ 
/*  749 */       ps = conn.prepareStatement(getSQLStatement("LOAD_PAGED_REFS"));
/*      */ 
/*  751 */       ps.setLong(1, channelID);
/*      */ 
/*  753 */       ps.setLong(2, orderStart);
/*      */ 
/*  755 */       ps.setLong(3, orderStart + number - 1L);
/*      */ 
/*  757 */       rs = ps.executeQuery();
/*      */ 
/*  759 */       long ord = orderStart;
/*      */ 
/*  761 */       while (rs.next())
/*      */       {
/*  763 */         msgId = rs.getLong(1);
/*  764 */         int deliveryCount = rs.getInt(2);
/*  765 */         int pageOrd = rs.getInt(3);
/*  766 */         long sched = rs.getLong(4);
/*      */ 
/*  769 */         if (pageOrd != ord)
/*      */         {
/*  771 */           throw new IllegalStateException("Unexpected pageOrd: " + pageOrd + " expected: " + ord);
/*      */         }
/*      */ 
/*  774 */         PersistenceManager.ReferenceInfo ri = new PersistenceManager.ReferenceInfo(msgId, deliveryCount, sched);
/*      */ 
/*  776 */         refs.add(ri);
/*  777 */         ord += 1L;
/*      */       }
/*      */ 
/*  781 */       if (ord != orderStart + number)
/*      */       {
/*  783 */         throw new IllegalStateException("Didn't load expected number of references, loaded: " + (ord - orderStart) + " expected: " + number);
/*      */       }
/*      */ 
/*  787 */       long msgId = refs;
/*      */       return msgId;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  791 */       wrap.exceptionOccurred();
/*  792 */       throw e;
/*      */     }
/*      */     finally
/*      */     {
/*  796 */       closeResultSet(rs);
/*  797 */       closeStatement(ps);
/*  798 */       closeConnection(conn);
/*  799 */       wrap.end();
/*  800 */     }throw localObject;
/*      */   }
/*      */ 
/*      */   public PersistenceManager.InitialLoadInfo loadFromStart(long channelID, int number)
/*      */     throws Exception
/*      */   {
/*  808 */     if (this.trace) log.trace("loading initial reference infos for channel " + channelID);
/*      */ 
/*  810 */     Connection conn = null;
/*  811 */     PreparedStatement ps = null;
/*  812 */     ResultSet rs = null;
/*  813 */     JDBCSupport.TransactionWrapper wrap = new JDBCSupport.TransactionWrapper(this);
/*      */     try
/*      */     {
/*  817 */       conn = this.ds.getConnection();
/*      */ 
/*  820 */       ps = conn.prepareStatement(getSQLStatement("SELECT_MIN_MAX_PAGE_ORD"));
/*      */ 
/*  822 */       ps.setLong(1, channelID);
/*      */ 
/*  824 */       rs = ps.executeQuery();
/*      */ 
/*  826 */       rs.next();
/*      */ 
/*  828 */       Long minOrdering = new Long(rs.getLong(1));
/*      */ 
/*  830 */       if (rs.wasNull())
/*      */       {
/*  832 */         minOrdering = null;
/*      */       }
/*      */ 
/*  835 */       Long maxOrdering = new Long(rs.getLong(2));
/*      */ 
/*  837 */       if (rs.wasNull())
/*      */       {
/*  839 */         maxOrdering = null;
/*      */       }
/*      */ 
/*  842 */       ps.close();
/*      */ 
/*  844 */       ps = null;
/*      */ 
/*  846 */       ps = conn.prepareStatement(getSQLStatement("LOAD_UNPAGED_REFS"));
/*      */ 
/*  848 */       ps.setLong(1, channelID);
/*      */ 
/*  850 */       rs = ps.executeQuery();
/*      */ 
/*  852 */       List refs = new ArrayList();
/*      */ 
/*  854 */       int count = 0;
/*  855 */       while (rs.next())
/*      */       {
/*  857 */         msgId = rs.getLong(1);
/*  858 */         int deliveryCount = rs.getInt(2);
/*  859 */         long sched = rs.getLong(3);
/*      */ 
/*  861 */         PersistenceManager.ReferenceInfo ri = new PersistenceManager.ReferenceInfo(msgId, deliveryCount, sched);
/*      */ 
/*  863 */         if (count < number)
/*      */         {
/*  865 */           refs.add(ri);
/*      */         }
/*      */ 
/*  868 */         count++;
/*      */       }
/*      */ 
/*  873 */       if (count > number)
/*      */       {
/*  875 */         throw new IllegalStateException("Cannot load channel " + channelID + " since the fullSize parameter is too small to load " + " all the required references, fullSize needs to be at least " + count + " it is currently " + number);
/*      */       }
/*      */ 
/*  879 */       long msgId = new PersistenceManager.InitialLoadInfo(minOrdering, maxOrdering, refs);
/*      */       return msgId;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  883 */       wrap.exceptionOccurred();
/*  884 */       throw e;
/*      */     }
/*      */     finally
/*      */     {
/*  888 */       closeResultSet(rs);
/*  889 */       closeStatement(ps);
/*  890 */       closeConnection(conn);
/*  891 */       wrap.end();
/*  892 */     }throw localObject;
/*      */   }
/*      */ 
/*      */   public void mergeTransactions(long fromChannelID, long toChannelID)
/*      */     throws Exception
/*      */   {
/*  901 */     if (this.trace) log.trace("Merging transactions from channel " + fromChannelID + " to " + toChannelID);
/*      */ 
/*  905 */     if (fromChannelID == toChannelID)
/*      */     {
/*  907 */       throw new IllegalArgumentException("Cannot merge transactions - they have the same channel id!!");
/*      */     }
/*      */ 
/*  933 */     new JDBCSupport.JDBCTxRunner2(toChannelID, fromChannelID)
/*      */     {
/*      */       public Object doTransaction()
/*      */         throws Exception
/*      */       {
/*  914 */         PreparedStatement statement = null;
/*      */         try
/*      */         {
/*  917 */           statement = this.conn.prepareStatement(this.this$0.getSQLStatement("UPDATE_TX"));
/*  918 */           statement.setLong(1, this.val$toChannelID);
/*  919 */           statement.setLong(2, this.val$fromChannelID);
/*  920 */           int affected = statement.executeUpdate();
/*      */ 
/*  922 */           JDBCPersistenceManager.log.debug("Merged " + affected + " transactions from channel " + this.val$fromChannelID + " into node " + this.val$toChannelID);
/*      */ 
/*  924 */           Object localObject1 = null;
/*      */           return localObject1;
/*      */         }
/*      */         finally
/*      */         {
/*  928 */           this.this$0.closeStatement(statement);
/*  929 */         }throw localObject2;
/*      */       }
/*      */     }
/*      */ 
/*  933 */     .executeWithRetry();
/*      */   }
/*      */ 
/*      */   public PersistenceManager.InitialLoadInfo mergeAndLoad(long fromChannelID, long toChannelID, int numberToLoad, long firstPagingOrder, long nextPagingOrder) throws Exception
/*      */   {
/*  938 */     if (this.trace) log.trace("Merging channel from " + fromChannelID + " to " + toChannelID + " numberToLoad:" + numberToLoad + " firstPagingOrder:" + firstPagingOrder + " nextPagingOrder:" + nextPagingOrder);
/*      */ 
/*  942 */     if (fromChannelID == toChannelID)
/*      */     {
/*  944 */       throw new IllegalArgumentException("Cannot merge queues - they have the same channel id!!");
/*      */     }
/*      */ 
/* 1101 */     return (PersistenceManager.InitialLoadInfo)new JDBCSupport.JDBCTxRunner2(fromChannelID, nextPagingOrder, numberToLoad, toChannelID, firstPagingOrder)
/*      */     {
/*      */       public Object doTransaction()
/*      */         throws Exception
/*      */       {
/*  951 */         PreparedStatement ps = null;
/*  952 */         ResultSet rs = null;
/*  953 */         PreparedStatement ps2 = null;
/*      */         try
/*      */         {
/* 1006 */           List refs = new ArrayList();
/*      */ 
/* 1008 */           ps = this.conn.prepareStatement(this.this$0.getSQLStatement("LOAD_REFS"));
/*      */ 
/* 1010 */           ps.setLong(1, this.val$fromChannelID);
/*      */ 
/* 1012 */           rs = ps.executeQuery();
/*      */ 
/* 1014 */           int count = 0;
/*      */ 
/* 1016 */           boolean arePaged = false;
/*      */ 
/* 1018 */           long pageOrd = this.val$nextPagingOrder;
/*      */ 
/* 1020 */           while (rs.next())
/*      */           {
/* 1022 */             long msgId = rs.getLong(1);
/* 1023 */             int deliveryCount = rs.getInt(2);
/* 1024 */             long sched = rs.getLong(3);
/*      */ 
/* 1026 */             if (count < this.val$numberToLoad)
/*      */             {
/* 1028 */               PersistenceManager.ReferenceInfo ri = new PersistenceManager.ReferenceInfo(msgId, deliveryCount, sched);
/*      */ 
/* 1030 */               refs.add(ri);
/*      */             }
/*      */ 
/* 1035 */             if (ps2 == null)
/*      */             {
/* 1037 */               ps2 = this.conn.prepareStatement(this.this$0.getSQLStatement("UPDATE_PAGE_ORDER"));
/*      */             }
/*      */ 
/* 1040 */             if (count < this.val$numberToLoad)
/*      */             {
/* 1042 */               ps2.setNull(1, -5);
/*      */ 
/* 1044 */               if (this.this$0.trace) JDBCPersistenceManager.log.trace("Set page ord to null");
/*      */             }
/*      */             else
/*      */             {
/* 1048 */               ps2.setLong(1, pageOrd);
/*      */ 
/* 1050 */               if (this.this$0.trace) JDBCPersistenceManager.log.trace("Set page ord to " + pageOrd);
/*      */ 
/* 1052 */               arePaged = true;
/*      */ 
/* 1054 */               pageOrd += 1L;
/*      */             }
/*      */ 
/* 1057 */             ps2.setLong(2, msgId);
/*      */ 
/* 1059 */             ps2.setLong(3, this.val$fromChannelID);
/*      */ 
/* 1061 */             int rows = ps2.executeUpdate();
/*      */ 
/* 1063 */             if (this.this$0.trace) JDBCPersistenceManager.log.trace("Update page ord updated " + rows + " rows");
/*      */ 
/* 1065 */             count++;
/*      */           }
/*      */ 
/* 1068 */           ps.close();
/*      */ 
/* 1070 */           ps = null;
/*      */ 
/* 1074 */           ps = this.conn.prepareStatement(this.this$0.getSQLStatement("UPDATE_CHANNEL_ID"));
/*      */ 
/* 1076 */           ps.setLong(1, this.val$toChannelID);
/*      */ 
/* 1078 */           ps.setLong(2, this.val$fromChannelID);
/*      */ 
/* 1080 */           int rows = ps.executeUpdate();
/*      */ 
/* 1082 */           if (this.this$0.trace) JDBCPersistenceManager.log.trace("Update channel id updated " + rows + " rows");
/*      */ 
/* 1084 */           if (arePaged)
/*      */           {
/* 1086 */             localInitialLoadInfo = new PersistenceManager.InitialLoadInfo(new Long(this.val$firstPagingOrder), new Long(pageOrd - 1L), refs);
/*      */             return localInitialLoadInfo;
/*      */           }
/* 1090 */           PersistenceManager.InitialLoadInfo localInitialLoadInfo = new PersistenceManager.InitialLoadInfo(null, null, refs);
/*      */           return localInitialLoadInfo;
/*      */         }
/*      */         finally
/*      */         {
/* 1095 */           this.this$0.closeResultSet(rs);
/* 1096 */           this.this$0.closeStatement(ps);
/* 1097 */           this.this$0.closeStatement(ps2);
/* 1098 */         }throw localObject;
/*      */       }
/*      */     }
/* 1101 */     .executeWithRetry();
/*      */   }
/*      */ 
/*      */   public void testSpeed()
/*      */     throws Exception
/*      */   {
/*      */   }
/*      */ 
/*      */   public void addReference(long channelID, MessageReference ref, Transaction tx)
/*      */     throws Exception
/*      */   {
/* 1160 */     if (tx != null)
/*      */     {
/* 1163 */       TransactionCallback callback = getCallback(tx);
/*      */ 
/* 1165 */       callback.addReferenceToAdd(channelID, ref);
/*      */     }
/*      */     else
/*      */     {
/* 1170 */       new JDBCSupport.JDBCTxRunner2(ref, channelID)
/*      */       {
/*      */         public Object doTransaction()
/*      */           throws Exception
/*      */         {
/* 1118 */           PreparedStatement psReference = null;
/* 1119 */           PreparedStatement psInsertMessage = null;
/*      */ 
/* 1121 */           Message m = this.val$ref.getMessage();
/*      */           try
/*      */           {
/* 1125 */             psReference = this.conn.prepareStatement(this.this$0.getSQLStatement("INSERT_MESSAGE_REF"));
/*      */ 
/* 1128 */             this.this$0.addReference(this.val$channelID, this.val$ref, psReference, false);
/*      */ 
/* 1130 */             int rows = psReference.executeUpdate();
/*      */ 
/* 1132 */             if (this.this$0.trace) JDBCPersistenceManager.log.trace("Inserted " + rows + " rows");
/*      */ 
/* 1134 */             if (!m.isPersisted())
/*      */             {
/* 1137 */               psInsertMessage = this.conn.prepareStatement(this.this$0.getSQLStatement("INSERT_MESSAGE"));
/*      */ 
/* 1139 */               this.this$0.storeMessage(m, psInsertMessage, true);
/* 1140 */               rows = psInsertMessage.executeUpdate();
/*      */ 
/* 1142 */               if (this.this$0.trace) JDBCPersistenceManager.log.trace("Inserted/updated " + rows + " rows");
/*      */ 
/* 1144 */               JDBCPersistenceManager.log.trace("message Inserted/updated " + rows + " rows");
/*      */ 
/* 1147 */               m.setPersisted(true);
/*      */             }
/*      */ 
/* 1150 */             Object localObject1 = null;
/*      */             return localObject1;
/*      */           }
/*      */           finally
/*      */           {
/* 1154 */             this.this$0.closeStatement(psReference);
/* 1155 */             this.this$0.closeStatement(psInsertMessage);
/* 1156 */           }throw localObject2;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1170 */       .executeWithRetry();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateDeliveryCount(long channelID, MessageReference ref)
/*      */     throws Exception
/*      */   {
/* 1205 */     new JDBCSupport.JDBCTxRunner2(ref, channelID)
/*      */     {
/*      */       public Object doTransaction()
/*      */         throws Exception
/*      */       {
/* 1180 */         PreparedStatement psReference = null;
/*      */         try
/*      */         {
/* 1184 */           psReference = this.conn.prepareStatement(this.this$0.getSQLStatement("UPDATE_DELIVERY_COUNT"));
/*      */ 
/* 1186 */           psReference.setInt(1, this.val$ref.getDeliveryCount());
/*      */ 
/* 1188 */           psReference.setLong(2, this.val$channelID);
/*      */ 
/* 1190 */           psReference.setLong(3, this.val$ref.getMessage().getMessageID());
/*      */ 
/* 1192 */           int rows = psReference.executeUpdate();
/*      */ 
/* 1194 */           if (this.this$0.trace) JDBCPersistenceManager.log.trace("Updated " + rows + " rows");
/*      */ 
/* 1196 */           Object localObject1 = null;
/*      */           return localObject1;
/*      */         }
/*      */         finally
/*      */         {
/* 1200 */           this.this$0.closeStatement(psReference);
/* 1201 */         }throw localObject2;
/*      */       }
/*      */     }
/*      */ 
/* 1205 */     .executeWithRetry();
/*      */   }
/*      */ 
/*      */   public void removeReference(long channelID, MessageReference ref, Transaction tx)
/*      */     throws Exception
/*      */   {
/* 1242 */     if (tx != null)
/*      */     {
/* 1246 */       TransactionCallback callback = getCallback(tx);
/*      */ 
/* 1248 */       callback.addReferenceToRemove(channelID, ref);
/*      */     }
/*      */     else
/*      */     {
/* 1254 */       new JDBCSupport.JDBCTxRunner2(channelID, ref)
/*      */       {
/*      */         public Object doTransaction()
/*      */           throws Exception
/*      */         {
/* 1214 */           PreparedStatement psReference = null;
/*      */           try
/*      */           {
/* 1218 */             psReference = this.conn.prepareStatement(this.this$0.getSQLStatement("DELETE_MESSAGE_REF"));
/*      */ 
/* 1221 */             this.this$0.removeReference(this.val$channelID, this.val$ref, psReference);
/*      */ 
/* 1223 */             int rows = psReference.executeUpdate();
/*      */ 
/* 1225 */             if (rows != 1)
/*      */             {
/* 1227 */               JDBCPersistenceManager.log.warn("Failed to remove row for: " + this.val$ref);
/* 1228 */               localObject1 = null;
/*      */               return localObject1;
/*      */             }
/* 1231 */             if (this.this$0.trace) JDBCPersistenceManager.log.trace("Deleted " + rows + " references");
/*      */ 
/* 1233 */             Object localObject1 = null;
/*      */             return localObject1;
/*      */           }
/*      */           finally
/*      */           {
/* 1237 */             this.this$0.closeStatement(psReference);
/* 1238 */           }throw localObject2;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1254 */       .executeWithRetry();
/*      */ 
/* 1256 */       deleteMessage(ref.getMessage().getMessageID());
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean referenceExists(long messageID)
/*      */     throws Exception
/*      */   {
/* 1263 */     Connection conn = null;
/* 1264 */     PreparedStatement st = null;
/* 1265 */     ResultSet rs = null;
/* 1266 */     JDBCSupport.TransactionWrapper wrap = new JDBCSupport.TransactionWrapper(this);
/*      */     try
/*      */     {
/* 1270 */       conn = this.ds.getConnection();
/*      */ 
/* 1272 */       st = conn.prepareStatement(getSQLStatement("SELECT_EXISTS_REF_MESSAGE_ID"));
/* 1273 */       st.setLong(1, messageID);
/*      */ 
/* 1275 */       rs = st.executeQuery();
/*      */ 
/* 1277 */       if (rs.next())
/*      */       {
/* 1279 */         i = 1;
/*      */         return i;
/*      */       }
/* 1283 */       int i = 0;
/*      */       return i;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1288 */       wrap.exceptionOccurred();
/* 1289 */       throw e;
/*      */     }
/*      */     finally
/*      */     {
/* 1293 */       closeResultSet(rs);
/* 1294 */       closeStatement(st);
/* 1295 */       closeConnection(conn);
/* 1296 */       wrap.end();
/* 1297 */     }throw localObject;
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/* 1304 */     return "JDBCPersistenceManager[" + Integer.toHexString(hashCode()) + "]";
/*      */   }
/*      */ 
/*      */   protected TransactionCallback getCallback(Transaction tx)
/*      */   {
/* 1313 */     TransactionCallback callback = (TransactionCallback)tx.getCallback(this);
/*      */ 
/* 1315 */     if (callback == null)
/*      */     {
/* 1317 */       callback = new TransactionCallback(tx, null);
/*      */ 
/* 1319 */       tx.addCallback(callback, this);
/*      */     }
/*      */ 
/* 1322 */     return callback;
/*      */   }
/*      */ 
/*      */   protected void handleBeforeCommit1PC(List refsToAdd, List refsToRemove, Transaction tx)
/*      */     throws Exception
/*      */   {
/* 1426 */     new JDBCSupport.JDBCTxRunner2(refsToAdd, refsToRemove)
/*      */     {
/*      */       public Object doTransaction()
/*      */         throws Exception
/*      */       {
/* 1336 */         PreparedStatement psReference = null;
/* 1337 */         PreparedStatement psInsertMessage = null;
/* 1338 */         PreparedStatement psDeleteReference = null;
/*      */ 
/* 1340 */         List messagesStored = new ArrayList();
/*      */         try
/*      */         {
/* 1346 */           for (Iterator i = this.val$refsToAdd.iterator(); i.hasNext(); )
/*      */           {
/* 1348 */             JDBCPersistenceManager.ChannelRefPair pair = (JDBCPersistenceManager.ChannelRefPair)i.next();
/* 1349 */             MessageReference ref = pair.ref;
/*      */ 
/* 1351 */             psReference = this.conn.prepareStatement(this.this$0.getSQLStatement("INSERT_MESSAGE_REF"));
/*      */ 
/* 1354 */             this.this$0.addReference(pair.channelID, ref, psReference, false);
/*      */ 
/* 1356 */             int rows = psReference.executeUpdate();
/*      */ 
/* 1358 */             if (this.this$0.trace) JDBCPersistenceManager.log.trace("Inserted " + rows + " rows");
/*      */ 
/* 1360 */             Message m = ref.getMessage();
/*      */ 
/* 1362 */             synchronized (m)
/*      */             {
/* 1364 */               if (!m.isPersisted())
/*      */               {
/* 1366 */                 if (psInsertMessage == null)
/*      */                 {
/* 1368 */                   psInsertMessage = this.conn.prepareStatement(this.this$0.getSQLStatement("INSERT_MESSAGE"));
/*      */                 }
/*      */ 
/* 1374 */                 if (this.this$0.trace) JDBCPersistenceManager.log.trace("Message does not already exist so inserting it");
/* 1375 */                 this.this$0.storeMessage(m, psInsertMessage, true);
/* 1376 */                 rows = psInsertMessage.executeUpdate();
/* 1377 */                 if (this.this$0.trace) JDBCPersistenceManager.log.trace("Inserted " + rows + " rows");
/*      */ 
/* 1379 */                 m.setPersisted(true);
/*      */ 
/* 1381 */                 messagesStored.add(m);
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 1388 */           for (Iterator i = this.val$refsToRemove.iterator(); i.hasNext(); )
/*      */           {
/* 1390 */             JDBCPersistenceManager.ChannelRefPair pair = (JDBCPersistenceManager.ChannelRefPair)i.next();
/*      */ 
/* 1392 */             if (psDeleteReference == null)
/*      */             {
/* 1394 */               psDeleteReference = this.conn.prepareStatement(this.this$0.getSQLStatement("DELETE_MESSAGE_REF"));
/*      */             }
/*      */ 
/* 1397 */             this.this$0.removeReference(pair.channelID, pair.ref, psDeleteReference);
/*      */ 
/* 1399 */             int rows = psDeleteReference.executeUpdate();
/*      */ 
/* 1401 */             if (this.this$0.trace) JDBCPersistenceManager.log.trace("Deleted " + rows + " references");
/*      */ 
/*      */           }
/*      */ 
/* 1405 */           i = null;
/*      */           return i;
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/* 1409 */           for (Iterator i = messagesStored.iterator(); i.hasNext(); )
/*      */           {
/* 1411 */             Message msg = (Message)i.next();
/*      */ 
/* 1413 */             msg.setPersisted(false);
/*      */           }
/* 1415 */           throw e;
/*      */         }
/*      */         finally
/*      */         {
/* 1419 */           this.this$0.closeStatement(psReference);
/* 1420 */           this.this$0.closeStatement(psDeleteReference);
/* 1421 */           this.this$0.closeStatement(psInsertMessage);
/* 1422 */         }throw localObject2;
/*      */       }
/*      */     }
/*      */ 
/* 1426 */     .executeWithRetry();
/*      */ 
/* 1428 */     deleteMessages(refsToRemove);
/*      */   }
/*      */ 
/*      */   protected void handleBeforeCommit2PC(List refsToRemove, Transaction tx)
/*      */     throws Exception
/*      */   {
/* 1472 */     new JDBCSupport.JDBCTxRunner2(tx)
/*      */     {
/*      */       public Object doTransaction()
/*      */         throws Exception
/*      */       {
/* 1437 */         PreparedStatement ps = null;
/*      */ 
/* 1439 */         if (this.this$0.trace) JDBCPersistenceManager.log.trace(this + " commitPreparedTransaction, tx= " + this.val$tx);
/*      */ 
/*      */         try
/*      */         {
/* 1443 */           ps = this.conn.prepareStatement(this.this$0.getSQLStatement("COMMIT_MESSAGE_REF1"));
/*      */ 
/* 1445 */           ps.setLong(1, this.val$tx.getId());
/*      */ 
/* 1447 */           int rows = ps.executeUpdate();
/*      */ 
/* 1449 */           if (this.this$0.trace) JDBCPersistenceManager.log.trace(JDBCUtil.statementToString(this.this$0.getSQLStatement("COMMIT_MESSAGE_REF1"), new Long(this.val$tx.getId())) + " removed " + rows + " row(s)");
/*      */ 
/* 1451 */           ps.close();
/* 1452 */           ps = null;
/*      */ 
/* 1454 */           ps = this.conn.prepareStatement(this.this$0.getSQLStatement("COMMIT_MESSAGE_REF2"));
/* 1455 */           ps.setLong(1, this.val$tx.getId());
/*      */ 
/* 1457 */           rows = ps.executeUpdate();
/*      */ 
/* 1459 */           if (this.this$0.trace) JDBCPersistenceManager.log.trace(JDBCUtil.statementToString(this.this$0.getSQLStatement("COMMIT_MESSAGE_REF2"), new Long(this.val$tx.getId())) + " updated " + rows + " row(s)");
/*      */ 
/* 1461 */           this.this$0.removeTXRecord(this.conn, this.val$tx);
/*      */ 
/* 1463 */           Object localObject1 = null;
/*      */           return localObject1;
/*      */         }
/*      */         finally
/*      */         {
/* 1467 */           this.this$0.closeStatement(ps);
/* 1468 */         }throw localObject2;
/*      */       }
/*      */     }
/*      */ 
/* 1472 */     .executeWithRetry();
/*      */ 
/* 1474 */     deleteMessages(refsToRemove);
/*      */   }
/*      */ 
/*      */   protected void handleBeforePrepare(List refsToAdd, List refsToRemove, Transaction tx)
/*      */     throws Exception
/*      */   {
/* 1582 */     new JDBCSupport.JDBCTxRunner2(refsToAdd, refsToRemove, tx)
/*      */     {
/*      */       public Object doTransaction()
/*      */         throws Exception
/*      */       {
/* 1487 */         PreparedStatement psReference = null;
/* 1488 */         PreparedStatement psInsertMessage = null;
/* 1489 */         PreparedStatement psUpdateReference = null;
/*      */ 
/* 1491 */         List messagesStored = new ArrayList();
/*      */         try
/*      */         {
/* 1496 */           if ((!this.val$refsToAdd.isEmpty()) || (!this.val$refsToRemove.isEmpty()))
/*      */           {
/* 1498 */             this.this$0.addTXRecord(this.conn, this.val$tx);
/*      */           }
/*      */ 
/* 1501 */           Iterator iter = this.val$refsToAdd.iterator();
/*      */ 
/* 1503 */           while (iter.hasNext())
/*      */           {
/* 1505 */             JDBCPersistenceManager.ChannelRefPair pair = (JDBCPersistenceManager.ChannelRefPair)iter.next();
/*      */ 
/* 1507 */             if (psReference == null)
/*      */             {
/* 1509 */               psReference = this.conn.prepareStatement(this.this$0.getSQLStatement("INSERT_MESSAGE_REF"));
/*      */             }
/*      */ 
/* 1512 */             this.this$0.prepareToAddReference(pair.channelID, pair.ref, this.val$tx, psReference);
/*      */ 
/* 1514 */             int rows = psReference.executeUpdate();
/*      */ 
/* 1516 */             if (this.this$0.trace) JDBCPersistenceManager.log.trace("Inserted " + rows + " rows");
/*      */ 
/* 1518 */             Message m = pair.ref.getMessage();
/*      */ 
/* 1520 */             synchronized (m)
/*      */             {
/* 1522 */               if (!m.isPersisted())
/*      */               {
/* 1524 */                 if (psInsertMessage == null)
/*      */                 {
/* 1526 */                   psInsertMessage = this.conn.prepareStatement(this.this$0.getSQLStatement("INSERT_MESSAGE"));
/*      */                 }
/*      */ 
/* 1529 */                 this.this$0.storeMessage(m, psInsertMessage, true);
/* 1530 */                 rows = psInsertMessage.executeUpdate();
/*      */ 
/* 1532 */                 if (this.this$0.trace) JDBCPersistenceManager.log.trace("Inserted " + rows + " rows");
/*      */ 
/* 1534 */                 m.setPersisted(true);
/*      */ 
/* 1536 */                 messagesStored.add(m);
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 1543 */           iter = this.val$refsToRemove.iterator();
/*      */ 
/* 1545 */           while (iter.hasNext())
/*      */           {
/* 1547 */             if (psUpdateReference == null)
/*      */             {
/* 1549 */               psUpdateReference = this.conn.prepareStatement(this.this$0.getSQLStatement("UPDATE_MESSAGE_REF"));
/*      */             }
/*      */ 
/* 1552 */             pair = (JDBCPersistenceManager.ChannelRefPair)iter.next();
/*      */ 
/* 1554 */             this.this$0.prepareToRemoveReference(pair.channelID, pair.ref, this.val$tx, psUpdateReference);
/*      */ 
/* 1556 */             int rows = psUpdateReference.executeUpdate();
/*      */ 
/* 1558 */             if (this.this$0.trace) JDBCPersistenceManager.log.trace("updated " + rows + " rows");
/*      */           }
/*      */ 
/* 1561 */           JDBCPersistenceManager.ChannelRefPair pair = null;
/*      */           return pair;
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/* 1565 */           for (Iterator i = messagesStored.iterator(); i.hasNext(); )
/*      */           {
/* 1567 */             Message msg = (Message)i.next();
/*      */ 
/* 1569 */             msg.setPersisted(false);
/*      */           }
/* 1571 */           throw e;
/*      */         }
/*      */         finally
/*      */         {
/* 1575 */           this.this$0.closeStatement(psReference);
/* 1576 */           this.this$0.closeStatement(psInsertMessage);
/* 1577 */           this.this$0.closeStatement(psUpdateReference);
/* 1578 */         }throw localObject2;
/*      */       }
/*      */     }
/*      */ 
/* 1582 */     .executeWithRetry();
/*      */   }
/*      */ 
/*      */   protected void handleBeforeRollback(List refsToAdd, Transaction tx)
/*      */     throws Exception
/*      */   {
/* 1631 */     new JDBCSupport.JDBCTxRunner2(tx)
/*      */     {
/*      */       public Object doTransaction()
/*      */         throws Exception
/*      */       {
/* 1591 */         PreparedStatement ps = null;
/*      */         try
/*      */         {
/* 1595 */           ps = this.conn.prepareStatement(this.this$0.getSQLStatement("ROLLBACK_MESSAGE_REF1"));
/*      */ 
/* 1597 */           ps.setLong(1, this.val$tx.getId());
/*      */ 
/* 1599 */           int rows = ps.executeUpdate();
/*      */ 
/* 1601 */           if (this.this$0.trace)
/*      */           {
/* 1603 */             JDBCPersistenceManager.log.trace(JDBCUtil.statementToString(this.this$0.getSQLStatement("ROLLBACK_MESSAGE_REF1"), new Long(this.val$tx.getId())) + " removed " + rows + " row(s)");
/*      */           }
/*      */ 
/* 1606 */           ps.close();
/* 1607 */           ps = null;
/*      */ 
/* 1609 */           ps = this.conn.prepareStatement(this.this$0.getSQLStatement("ROLLBACK_MESSAGE_REF2"));
/* 1610 */           ps.setLong(1, this.val$tx.getId());
/*      */ 
/* 1612 */           rows = ps.executeUpdate();
/*      */ 
/* 1614 */           if (this.this$0.trace)
/*      */           {
/* 1616 */             JDBCPersistenceManager.log.trace(JDBCUtil.statementToString(this.this$0.getSQLStatement("ROLLBACK_MESSAGE_REF2"), new Long(this.val$tx.getId())) + " updated " + rows + " row(s)");
/*      */           }
/*      */ 
/* 1620 */           this.this$0.removeTXRecord(this.conn, this.val$tx);
/*      */ 
/* 1622 */           Object localObject1 = null;
/*      */           return localObject1;
/*      */         }
/*      */         finally
/*      */         {
/* 1626 */           this.this$0.closeStatement(ps);
/* 1627 */         }throw localObject2;
/*      */       }
/*      */     }
/*      */ 
/* 1631 */     .executeWithRetry();
/*      */ 
/* 1633 */     deleteMessages(refsToAdd);
/*      */   }
/*      */ 
/*      */   protected void addTXRecord(Connection conn, Transaction tx)
/*      */     throws Exception
/*      */   {
/* 1639 */     if (this.trace)
/*      */     {
/* 1641 */       log.trace("Inserting tx record for " + tx);
/*      */     }
/*      */ 
/* 1644 */     if (!this.nodeIDSet)
/*      */     {
/* 1647 */       throw new IllegalStateException("Node id has not been set");
/*      */     }
/*      */ 
/* 1650 */     PreparedStatement ps = null;
/* 1651 */     String statement = "UNDEFINED";
/* 1652 */     int rows = -1;
/* 1653 */     int formatID = -1;
/*      */     try
/*      */     {
/* 1656 */       statement = getSQLStatement("INSERT_TRANSACTION");
/*      */ 
/* 1658 */       ps = conn.prepareStatement(statement);
/*      */ 
/* 1660 */       ps.setInt(1, this.nodeID);
/*      */ 
/* 1662 */       ps.setLong(2, tx.getId());
/*      */ 
/* 1664 */       Xid xid = tx.getXid();
/*      */ 
/* 1666 */       formatID = xid.getFormatId();
/*      */ 
/* 1668 */       setVarBinaryColumn(3, ps, xid.getBranchQualifier());
/*      */ 
/* 1670 */       ps.setInt(4, formatID);
/*      */ 
/* 1672 */       setVarBinaryColumn(5, ps, xid.getGlobalTransactionId());
/*      */ 
/* 1674 */       rows = ps.executeUpdate();
/*      */     }
/*      */     finally
/*      */     {
/*      */       String s;
/* 1678 */       if (this.trace)
/*      */       {
/* 1680 */         String s = JDBCUtil.statementToString(statement, new Integer(this.nodeID), new Long(tx.getId()), "<byte-array>", new Integer(formatID), "<byte-array>");
/*      */ 
/* 1682 */         log.trace(s + (rows == -1 ? " failed!" : new StringBuilder().append(" inserted ").append(rows).append(" row(s)").toString()));
/*      */       }
/* 1684 */       closeStatement(ps);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void removeTXRecord(Connection conn, Transaction tx) throws Exception
/*      */   {
/* 1690 */     if (!this.nodeIDSet)
/*      */     {
/* 1693 */       throw new IllegalStateException("Node id has not been set");
/*      */     }
/*      */ 
/* 1696 */     PreparedStatement ps = null;
/*      */     try
/*      */     {
/* 1699 */       ps = conn.prepareStatement(getSQLStatement("DELETE_TRANSACTION"));
/*      */ 
/* 1701 */       ps.setInt(1, this.nodeID);
/*      */ 
/* 1703 */       ps.setLong(2, tx.getId());
/*      */ 
/* 1705 */       int rows = ps.executeUpdate();
/*      */ 
/* 1707 */       if (this.trace)
/*      */       {
/* 1709 */         log.trace(JDBCUtil.statementToString(getSQLStatement("DELETE_TRANSACTION"), new Integer(this.nodeID), new Long(tx.getId())) + " removed " + rows + " row(s)");
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/* 1714 */       closeStatement(ps);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void addReference(long channelID, MessageReference ref, PreparedStatement ps, boolean paged)
/*      */     throws Exception
/*      */   {
/* 1721 */     if (this.trace) log.trace("adding " + ref + " to channel " + channelID);
/*      */ 
/* 1723 */     ps.setLong(1, channelID);
/* 1724 */     ps.setLong(2, ref.getMessage().getMessageID());
/* 1725 */     ps.setNull(3, -5);
/* 1726 */     ps.setString(4, "C");
/* 1727 */     ps.setLong(5, getOrdering());
/* 1728 */     if (paged)
/*      */     {
/* 1730 */       ps.setLong(6, ref.getPagingOrder());
/*      */     }
/*      */     else
/*      */     {
/* 1734 */       ps.setNull(6, -5);
/*      */     }
/* 1736 */     ps.setInt(7, ref.getDeliveryCount());
/* 1737 */     ps.setLong(8, ref.getScheduledDeliveryTime());
/*      */   }
/*      */ 
/*      */   protected void removeReference(long channelID, MessageReference ref, PreparedStatement ps)
/*      */     throws Exception
/*      */   {
/* 1743 */     if (this.trace) log.trace("removing " + ref + " from channel " + channelID);
/*      */ 
/* 1745 */     ps.setLong(1, ref.getMessage().getMessageID());
/* 1746 */     ps.setLong(2, channelID);
/*      */   }
/*      */ 
/*      */   protected void prepareToAddReference(long channelID, MessageReference ref, Transaction tx, PreparedStatement ps)
/*      */     throws Exception
/*      */   {
/* 1752 */     if (this.trace) log.trace("adding " + ref + " to channel " + channelID + (tx == null ? " non-transactionally" : new StringBuilder().append(" on transaction: ").append(tx).toString()));
/*      */ 
/* 1754 */     ps.setLong(1, channelID);
/* 1755 */     ps.setLong(2, ref.getMessage().getMessageID());
/* 1756 */     ps.setLong(3, tx.getId());
/* 1757 */     ps.setString(4, "+");
/* 1758 */     ps.setLong(5, getOrdering());
/* 1759 */     ps.setNull(6, -5);
/* 1760 */     ps.setInt(7, ref.getDeliveryCount());
/* 1761 */     ps.setLong(8, ref.getScheduledDeliveryTime());
/*      */   }
/*      */ 
/*      */   protected void prepareToRemoveReference(long channelID, MessageReference ref, Transaction tx, PreparedStatement ps)
/*      */     throws Exception
/*      */   {
/* 1767 */     if (this.trace)
/*      */     {
/* 1769 */       log.trace("removing " + ref + " from channel " + channelID + (tx == null ? " non-transactionally" : new StringBuilder().append(" on transaction: ").append(tx).toString()));
/*      */     }
/*      */ 
/* 1773 */     ps.setLong(1, tx.getId());
/* 1774 */     ps.setLong(2, ref.getMessage().getMessageID());
/* 1775 */     ps.setLong(3, channelID);
/*      */   }
/*      */ 
/*      */   protected byte[] mapToBytes(Map map) throws Exception
/*      */   {
/* 1780 */     if ((map == null) || (map.isEmpty()))
/*      */     {
/* 1782 */       return null;
/*      */     }
/*      */ 
/* 1785 */     int BUFFER_SIZE = 1024;
/*      */ 
/* 1787 */     ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
/*      */ 
/* 1789 */     DataOutputStream oos = new DataOutputStream(bos);
/*      */ 
/* 1791 */     StreamUtils.writeMap(oos, map, true);
/*      */ 
/* 1793 */     oos.close();
/*      */ 
/* 1795 */     return bos.toByteArray();
/*      */   }
/*      */ 
/*      */   protected HashMap bytesToMap(byte[] bytes) throws Exception
/*      */   {
/* 1800 */     if (bytes == null)
/*      */     {
/* 1802 */       return new HashMap();
/*      */     }
/*      */ 
/* 1805 */     ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
/*      */ 
/* 1807 */     DataInputStream dais = new DataInputStream(bis);
/*      */ 
/* 1809 */     HashMap map = StreamUtils.readMap(dais, true);
/*      */ 
/* 1811 */     dais.close();
/*      */ 
/* 1813 */     return map;
/*      */   }
/*      */ 
/*      */   protected void storeMessage(Message m, PreparedStatement ps, boolean bindBlobs)
/*      */     throws Exception
/*      */   {
/* 1823 */     ps.setLong(1, m.getMessageID());
/* 1824 */     ps.setString(2, m.isReliable() ? "Y" : "N");
/* 1825 */     ps.setLong(3, m.getExpiration());
/* 1826 */     ps.setLong(4, m.getTimestamp());
/* 1827 */     ps.setByte(5, m.getPriority());
/* 1828 */     ps.setByte(6, m.getType());
/* 1829 */     ps.setLong(7, System.currentTimeMillis());
/*      */ 
/* 1831 */     if (bindBlobs)
/*      */     {
/* 1833 */       bindBlobs(m, ps, 8, 9);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected int storeMessage(Message message, PreparedStatement psInsertMessage, PreparedStatement psUpdateMessage)
/*      */     throws Exception
/*      */   {
/*      */     int rows;
/* 1843 */     if (!this.supportsBlobSelect)
/*      */     {
/* 1846 */       storeMessage(message, psInsertMessage, false);
/* 1847 */       psInsertMessage.setLong(8, message.getMessageID());
/* 1848 */       int rows = psInsertMessage.executeUpdate();
/*      */ 
/* 1850 */       if (rows == 1)
/*      */       {
/* 1852 */         bindBlobs(message, psUpdateMessage, 1, 2);
/* 1853 */         psUpdateMessage.setLong(3, message.getMessageID());
/* 1854 */         rows = psUpdateMessage.executeUpdate();
/* 1855 */         if (rows != 1)
/*      */         {
/* 1857 */           throw new IllegalStateException("Couldn't update messageId=" + message.getMessageID() + " on paging");
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1865 */       storeMessage(message, psInsertMessage, true);
/* 1866 */       psInsertMessage.setLong(10, message.getMessageID());
/* 1867 */       rows = psInsertMessage.executeUpdate();
/*      */     }
/* 1869 */     return rows;
/*      */   }
/*      */ 
/*      */   private void bindBlobs(Message m, PreparedStatement ps, int headerPosition, int payloadPosition)
/*      */     throws Exception
/*      */   {
/* 1877 */     byte[] bytes = mapToBytes(((MessageSupport)m).getHeaders());
/* 1878 */     if (bytes != null)
/*      */     {
/* 1880 */       setBytes(ps, headerPosition, bytes);
/*      */     }
/*      */     else
/*      */     {
/* 1884 */       ps.setNull(headerPosition, -4);
/*      */     }
/*      */ 
/* 1888 */     byte[] payload = m.getPayloadAsByteArray();
/* 1889 */     if (payload != null)
/*      */     {
/* 1891 */       setBytes(ps, payloadPosition, payload);
/*      */     }
/*      */     else
/*      */     {
/* 1895 */       ps.setNull(payloadPosition, -4);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void setVarBinaryColumn(int column, PreparedStatement ps, byte[] bytes) throws Exception
/*      */   {
/* 1901 */     if (this.usingTrailingByte)
/*      */     {
/* 1909 */       byte[] res = new byte[bytes.length + 1];
/*      */ 
/* 1911 */       System.arraycopy(bytes, 0, res, 0, bytes.length);
/*      */ 
/* 1913 */       res[bytes.length] = 127;
/*      */ 
/* 1915 */       bytes = res;
/*      */     }
/*      */ 
/* 1918 */     ps.setBytes(column, bytes);
/*      */ 
/* 1920 */     if (this.trace) log.trace("Setting varbinary column of length: " + bytes.length); 
/*      */   }
/*      */ 
/*      */   protected byte[] getVarBinaryColumn(ResultSet rs, int columnIndex)
/*      */     throws Exception
/*      */   {
/* 1925 */     byte[] bytes = rs.getBytes(columnIndex);
/*      */ 
/* 1927 */     if (this.usingTrailingByte)
/*      */     {
/* 1933 */       byte[] newBytes = new byte[bytes.length - 1];
/*      */ 
/* 1935 */       System.arraycopy(bytes, 0, newBytes, 0, bytes.length - 1);
/*      */ 
/* 1937 */       bytes = newBytes;
/*      */     }
/*      */ 
/* 1940 */     return bytes;
/*      */   }
/*      */ 
/*      */   protected void setBytes(PreparedStatement ps, int columnIndex, byte[] bytes)
/*      */     throws Exception
/*      */   {
/* 1946 */     if (this.usingBinaryStream)
/*      */     {
/* 1950 */       InputStream is = null;
/*      */       try
/*      */       {
/* 1954 */         is = new ByteArrayInputStream(bytes);
/*      */ 
/* 1956 */         ps.setBinaryStream(columnIndex, is, bytes.length);
/*      */       }
/*      */       finally
/*      */       {
/* 1960 */         if (is != null)
/*      */         {
/* 1962 */           is.close();
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1970 */       setVarBinaryColumn(columnIndex, ps, bytes);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected byte[] getBytes(ResultSet rs, int columnIndex) throws Exception
/*      */   {
/* 1976 */     if (this.usingBinaryStream)
/*      */     {
/* 1980 */       InputStream is = null;
/* 1981 */       ByteArrayOutputStream os = null;
/*      */ 
/* 1983 */       int BUFFER_SIZE = 4096;
/*      */       try
/*      */       {
/* 1987 */         InputStream i = rs.getBinaryStream(columnIndex);
/*      */ 
/* 1989 */         if (i == null)
/*      */         {
/* 1991 */           Object localObject1 = null;
/*      */           return localObject1;
/*      */         }
/* 1994 */         is = new BufferedInputStream(rs.getBinaryStream(columnIndex), 4096);
/*      */ 
/* 1996 */         os = new ByteArrayOutputStream(4096);
/*      */         int b;
/* 1999 */         while ((b = is.read()) != -1)
/*      */         {
/* 2001 */           os.write(b);
/*      */         }
/*      */ 
/* 2004 */         byte[] arrayOfByte = os.toByteArray();
/*      */         return arrayOfByte;
/*      */       }
/*      */       finally
/*      */       {
/* 2008 */         if (is != null)
/*      */         {
/* 2010 */           is.close();
/*      */         }
/* 2012 */         if (os != null)
/*      */         {
/* 2014 */           os.close();
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2021 */     return getVarBinaryColumn(rs, columnIndex);
/*      */   }
/*      */ 
/*      */   protected void logBatchUpdate(String name, int[] rows, String action)
/*      */   {
/* 2027 */     int count = 0;
/* 2028 */     for (int i = 0; i < rows.length; i++)
/*      */     {
/* 2030 */       count += rows[i];
/*      */     }
/* 2032 */     log.trace("Batch update " + name + ", " + action + " total of " + count + " rows");
/*      */   }
/*      */ 
/*      */   protected Map getDefaultDDLStatements()
/*      */   {
/* 2039 */     Map map = new LinkedHashMap();
/* 2040 */     map.put("CREATE_DUAL", "CREATE TABLE JBM_DUAL (DUMMY INTEGER)");
/*      */ 
/* 2042 */     map.put("CREATE_MESSAGE_REFERENCE", "CREATE TABLE JBM_MSG_REF (CHANNEL_ID BIGINT, MESSAGE_ID BIGINT, TRANSACTION_ID BIGINT, STATE CHAR(1), ORD BIGINT, PAGE_ORD BIGINT, DELIVERY_COUNT INTEGER, SCHED_DELIVERY BIGINT, PRIMARY KEY(CHANNEL_ID, MESSAGE_ID))");
/*      */ 
/* 2046 */     map.put("CREATE_IDX_MESSAGE_REF_TX", "CREATE INDEX JBM_MSG_REF_TX ON JBM_MSG_REF (TRANSACTION_ID)");
/* 2047 */     map.put("CREATE_IDX_MESSAGE_REF_ORD", "CREATE INDEX JBM_MSG_REF_ORD ON JBM_MSG_REF (ORD)");
/* 2048 */     map.put("CREATE_IDX_MESSAGE_REF_PAGE_ORD", "CREATE INDEX JBM_MSG_REF__PAGE_ORD ON JBM_MSG_REF (PAGE_ORD)");
/* 2049 */     map.put("CREATE_IDX_MESSAGE_REF_MESSAGE_ID", "CREATE INDEX JBM_MSG_REF_MESSAGE_ID ON JBM_MSG_REF (MESSAGE_ID)");
/* 2050 */     map.put("CREATE_IDX_MESSAGE_REF_SCHED_DELIVERY", "CREATE INDEX JBM_MSG_REF_SCHED_DELIVERY ON JBM_MSG_REF (SCHED_DELIVERY)");
/*      */ 
/* 2052 */     map.put("CREATE_MESSAGE", "CREATE TABLE JBM_MSG (MESSAGE_ID BIGINT, RELIABLE CHAR(1), EXPIRATION BIGINT, TIMESTAMP BIGINT, PRIORITY TINYINT, TYPE TINYINT, INS_TIME BIGINT, HEADERS LONGVARBINARY, PAYLOAD LONGVARBINARY, PRIMARY KEY (MESSAGE_ID))");
/*      */ 
/* 2057 */     map.put("CREATE_IDX_MESSAGE_TIMESTAMP", "CREATE INDEX JBM_MSG_REF_TIMESTAMP ON JBM_MSG (TIMESTAMP)");
/*      */ 
/* 2059 */     map.put("CREATE_TRANSACTION", "CREATE TABLE JBM_TX (NODE_ID INTEGER, TRANSACTION_ID BIGINT, BRANCH_QUAL VARBINARY(254), FORMAT_ID INTEGER, GLOBAL_TXID VARBINARY(254), PRIMARY KEY (TRANSACTION_ID))");
/*      */ 
/* 2064 */     map.put("CREATE_COUNTER", "CREATE TABLE JBM_COUNTER (NAME VARCHAR(255), NEXT_ID BIGINT, PRIMARY KEY(NAME))");
/*      */ 
/* 2066 */     return map;
/*      */   }
/*      */ 
/*      */   protected Map getDefaultDMLStatements()
/*      */   {
/* 2071 */     Map map = new LinkedHashMap();
/* 2072 */     map.put("INSERT_DUAL", "INSERT INTO JBM_DUAL VALUES (1)");
/* 2073 */     map.put("CHECK_DUAL", "SELECT 1 FROM JBM_DUAL");
/*      */ 
/* 2075 */     map.put("INSERT_MESSAGE_REF", "INSERT INTO JBM_MSG_REF (CHANNEL_ID, MESSAGE_ID, TRANSACTION_ID, STATE, ORD, PAGE_ORD, DELIVERY_COUNT, SCHED_DELIVERY) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
/*      */ 
/* 2078 */     map.put("DELETE_MESSAGE_REF", "DELETE FROM JBM_MSG_REF WHERE MESSAGE_ID=? AND CHANNEL_ID=? AND STATE='C'");
/* 2079 */     map.put("UPDATE_MESSAGE_REF", "UPDATE JBM_MSG_REF SET TRANSACTION_ID=?, STATE='-' WHERE MESSAGE_ID=? AND CHANNEL_ID=? AND STATE='C'");
/*      */ 
/* 2082 */     map.put("UPDATE_PAGE_ORDER", "UPDATE JBM_MSG_REF SET PAGE_ORD = ? WHERE MESSAGE_ID=? AND CHANNEL_ID=?");
/* 2083 */     map.put("COMMIT_MESSAGE_REF1", "UPDATE JBM_MSG_REF SET STATE='C', TRANSACTION_ID = NULL WHERE TRANSACTION_ID=? AND STATE='+'");
/* 2084 */     map.put("COMMIT_MESSAGE_REF2", "DELETE FROM JBM_MSG_REF WHERE TRANSACTION_ID=? AND STATE='-'");
/* 2085 */     map.put("ROLLBACK_MESSAGE_REF1", "DELETE FROM JBM_MSG_REF WHERE TRANSACTION_ID=? AND STATE='+'");
/* 2086 */     map.put("ROLLBACK_MESSAGE_REF2", "UPDATE JBM_MSG_REF SET STATE='C', TRANSACTION_ID = NULL WHERE TRANSACTION_ID=? AND STATE='-'");
/* 2087 */     map.put("LOAD_PAGED_REFS", "SELECT MESSAGE_ID, DELIVERY_COUNT, PAGE_ORD, SCHED_DELIVERY FROM JBM_MSG_REF WHERE CHANNEL_ID = ? AND PAGE_ORD BETWEEN ? AND ? ORDER BY PAGE_ORD");
/*      */ 
/* 2090 */     map.put("LOAD_UNPAGED_REFS", "SELECT MESSAGE_ID, DELIVERY_COUNT, SCHED_DELIVERY FROM JBM_MSG_REF WHERE STATE = 'C' AND CHANNEL_ID = ? AND PAGE_ORD IS NULL ORDER BY ORD");
/*      */ 
/* 2093 */     map.put("LOAD_REFS", "SELECT MESSAGE_ID, DELIVERY_COUNT, SCHED_DELIVERY FROM JBM_MSG_REF WHERE STATE = 'C' AND CHANNEL_ID = ? ORDER BY ORD");
/*      */ 
/* 2097 */     map.put("UPDATE_REFS_NOT_PAGED", "UPDATE JBM_MSG_REF SET PAGE_ORD = NULL WHERE PAGE_ORD BETWEEN ? AND ? AND CHANNEL_ID=?");
/* 2098 */     map.put("SELECT_MIN_MAX_PAGE_ORD", "SELECT MIN(PAGE_ORD), MAX(PAGE_ORD) FROM JBM_MSG_REF WHERE CHANNEL_ID = ?");
/* 2099 */     map.put("SELECT_EXISTS_REF_MESSAGE_ID", "SELECT MESSAGE_ID FROM JBM_MSG_REF WHERE MESSAGE_ID = ?");
/* 2100 */     map.put("UPDATE_DELIVERY_COUNT", "UPDATE JBM_MSG_REF SET DELIVERY_COUNT = ? WHERE CHANNEL_ID = ? AND MESSAGE_ID = ?");
/* 2101 */     map.put("UPDATE_CHANNEL_ID", "UPDATE JBM_MSG_REF SET CHANNEL_ID = ? WHERE CHANNEL_ID = ?");
/*      */ 
/* 2104 */     map.put("LOAD_MESSAGES", "SELECT MESSAGE_ID, RELIABLE, EXPIRATION, TIMESTAMP, PRIORITY, HEADERS, PAYLOAD, TYPE FROM JBM_MSG");
/*      */ 
/* 2108 */     map.put("INSERT_MESSAGE", "INSERT INTO JBM_MSG (MESSAGE_ID, RELIABLE, EXPIRATION, TIMESTAMP, PRIORITY, TYPE, INS_TIME, HEADERS, PAYLOAD) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
/*      */ 
/* 2112 */     map.put("INSERT_MESSAGE_CONDITIONAL", "INSERT INTO JBM_MSG (MESSAGE_ID, RELIABLE, EXPIRATION, TIMESTAMP, PRIORITY, TYPE, INS_TIME) SELECT ?, ?, ?, ?, ?, ?, ? FROM JBM_DUAL WHERE NOT EXISTS (SELECT MESSAGE_ID FROM JBM_MSG WHERE MESSAGE_ID = ?)");
/*      */ 
/* 2117 */     map.put("INSERT_MESSAGE_CONDITIONAL_FULL", "INSERT INTO JBM_MSG (MESSAGE_ID, RELIABLE, EXPIRATION, TIMESTAMP, PRIORITY, TYPE, INS_TIME, HEADERS, PAYLOAD) SELECT ?, ?, ?, ?, ?, ?, ?, ?, ? FROM JBM_DUAL WHERE NOT EXISTS (SELECT MESSAGE_ID FROM JBM_MSG WHERE MESSAGE_ID = ?)");
/* 2118 */     map.put("UPDATE_MESSAGE_4CONDITIONAL", "UPDATE JBM_MSG SET HEADERS=?, PAYLOAD=? WHERE MESSAGE_ID=?");
/* 2119 */     map.put("MESSAGE_ID_COLUMN", "MESSAGE_ID");
/* 2120 */     map.put("REAP_MESSAGES", "DELETE FROM JBM_MSG WHERE INS_TIME <= ? AND NOT EXISTS (SELECT * FROM JBM_MSG_REF WHERE JBM_MSG_REF.MESSAGE_ID = JBM_MSG.MESSAGE_ID)");
/* 2121 */     map.put("DELETE_MESSAGE", "DELETE FROM JBM_MSG WHERE MESSAGE_ID = ? AND NOT EXISTS (SELECT * FROM JBM_MSG_REF WHERE JBM_MSG_REF.MESSAGE_ID = ?)");
/*      */ 
/* 2123 */     map.put("INSERT_TRANSACTION", "INSERT INTO JBM_TX (NODE_ID, TRANSACTION_ID, BRANCH_QUAL, FORMAT_ID, GLOBAL_TXID) VALUES(?, ?, ?, ?, ?)");
/*      */ 
/* 2126 */     map.put("DELETE_TRANSACTION", "DELETE FROM JBM_TX WHERE NODE_ID = ? AND TRANSACTION_ID = ?");
/* 2127 */     map.put("SELECT_PREPARED_TRANSACTIONS", "SELECT TRANSACTION_ID, BRANCH_QUAL, FORMAT_ID, GLOBAL_TXID FROM JBM_TX WHERE NODE_ID = ?");
/* 2128 */     map.put("SELECT_MESSAGE_ID_FOR_REF", "SELECT MESSAGE_ID, CHANNEL_ID FROM JBM_MSG_REF WHERE TRANSACTION_ID = ? AND STATE = '+' ORDER BY ORD");
/* 2129 */     map.put("SELECT_MESSAGE_ID_FOR_ACK", "SELECT MESSAGE_ID, CHANNEL_ID FROM JBM_MSG_REF WHERE TRANSACTION_ID = ? AND STATE = '-' ORDER BY ORD");
/* 2130 */     map.put("UPDATE_TX", "UPDATE JBM_TX SET NODE_ID=? WHERE NODE_ID=?");
/*      */ 
/* 2133 */     map.put("UPDATE_COUNTER", "UPDATE JBM_COUNTER SET NEXT_ID = ? WHERE NAME=?");
/* 2134 */     map.put("SELECT_COUNTER", "SELECT NEXT_ID FROM JBM_COUNTER WHERE NAME=?");
/* 2135 */     map.put("INSERT_COUNTER", "INSERT INTO JBM_COUNTER (NAME, NEXT_ID) VALUES (?, ?)");
/*      */ 
/* 2137 */     map.put("SELECT_ALL_CHANNELS", "SELECT DISTINCT(CHANNEL_ID) FROM JBM_MSG_REF");
/*      */ 
/* 2139 */     return map;
/*      */   }
/*      */ 
/*      */   private void deleteMessages(List references)
/*      */     throws Exception
/*      */   {
/* 2192 */     orderReferences(references);
/*      */ 
/* 2194 */     new JDBCSupport.JDBCTxRunner2(references)
/*      */     {
/*      */       public Object doTransaction()
/*      */         throws Exception
/*      */       {
/* 2151 */         PreparedStatement psMessage = null;
/*      */         try
/*      */         {
/* 2155 */           psMessage = this.conn.prepareStatement(this.this$0.getSQLStatement("DELETE_MESSAGE"));
/*      */ 
/* 2157 */           Iterator iter = this.val$references.iterator();
/*      */ 
/* 2159 */           while (iter.hasNext())
/*      */           {
/* 2161 */             obj = iter.next();
/*      */             MessageReference ref;
/*      */             MessageReference ref;
/* 2164 */             if ((obj instanceof MessageReference))
/*      */             {
/* 2166 */               ref = (MessageReference)obj;
/*      */             }
/*      */             else
/*      */             {
/* 2170 */               ref = ((JDBCPersistenceManager.ChannelRefPair)obj).ref;
/*      */             }
/*      */ 
/* 2173 */             psMessage.setLong(1, ref.getMessage().getMessageID());
/* 2174 */             psMessage.setLong(2, ref.getMessage().getMessageID());
/*      */ 
/* 2176 */             int rows = psMessage.executeUpdate();
/*      */ 
/* 2178 */             if (this.this$0.trace) JDBCPersistenceManager.log.trace("Deleted " + rows + " messages");
/*      */ 
/*      */           }
/*      */ 
/* 2182 */           Object obj = null;
/*      */           return obj;
/*      */         }
/*      */         finally
/*      */         {
/* 2186 */           this.this$0.closeStatement(psMessage);
/* 2187 */         }throw localObject1;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2194 */     .executeWithRetry();
/*      */   }
/*      */ 
/*      */   private void deleteMessage(long messageID)
/*      */     throws Exception
/*      */   {
/* 2227 */     new JDBCSupport.JDBCTxRunner2(messageID)
/*      */     {
/*      */       public Object doTransaction()
/*      */         throws Exception
/*      */       {
/* 2205 */         PreparedStatement psMessage = null;
/*      */         try
/*      */         {
/* 2209 */           psMessage = this.conn.prepareStatement(this.this$0.getSQLStatement("DELETE_MESSAGE"));
/*      */ 
/* 2211 */           psMessage.setLong(1, this.val$messageID);
/* 2212 */           psMessage.setLong(2, this.val$messageID);
/*      */ 
/* 2214 */           int rows = psMessage.executeUpdate();
/*      */ 
/* 2216 */           if (this.this$0.trace) JDBCPersistenceManager.log.trace("Deleted " + rows + " messages");
/*      */ 
/* 2218 */           Object localObject1 = null;
/*      */           return localObject1;
/*      */         }
/*      */         finally
/*      */         {
/* 2222 */           this.this$0.closeStatement(psMessage);
/* 2223 */         }throw localObject2;
/*      */       }
/*      */     }
/*      */ 
/* 2227 */     .executeWithRetry();
/*      */   }
/*      */ 
/*      */   private List getMessageChannelPair(String sqlQuery, long transactionId)
/*      */     throws Exception
/*      */   {
/* 2233 */     if (this.trace) log.trace("loading message and channel ids for tx [" + transactionId + "]");
/*      */ 
/* 2235 */     if (!this.nodeIDSet)
/*      */     {
/* 2238 */       throw new IllegalStateException("Node id has not been set");
/*      */     }
/*      */ 
/* 2241 */     Connection conn = null;
/* 2242 */     PreparedStatement ps = null;
/* 2243 */     ResultSet rs = null;
/* 2244 */     JDBCSupport.TransactionWrapper wrap = new JDBCSupport.TransactionWrapper(this);
/*      */     try
/*      */     {
/* 2248 */       conn = this.ds.getConnection();
/*      */ 
/* 2250 */       ps = conn.prepareStatement(sqlQuery);
/*      */ 
/* 2252 */       ps.setLong(1, transactionId);
/*      */ 
/* 2254 */       rs = ps.executeQuery();
/*      */ 
/* 2270 */       List holders = new ArrayList();
/*      */ 
/* 2273 */       Set msgIds = new HashSet();
/*      */ 
/* 2278 */       while (rs.next())
/*      */       {
/* 2280 */         long messageId = rs.getLong(1);
/* 2281 */         long channelId = rs.getLong(2);
/*      */ 
/* 2283 */         1Holder holder = new Object(messageId, channelId)
/*      */         {
/*      */           long messageId;
/*      */           long channelId;
/*      */         };
/* 2285 */         holders.add(holder);
/*      */ 
/* 2287 */         msgIds.add(Long.valueOf(messageId));
/*      */ 
/* 2289 */         if (this.trace) log.trace("Loaded MsgID: " + messageId + " and ChannelID: " + channelId);
/*      */       }
/*      */ 
/* 2292 */       Map messageMap = new HashMap();
/*      */ 
/* 2294 */       List messages = getMessages(new ArrayList(msgIds));
/*      */ 
/* 2296 */       for (Iterator iter = messages.iterator(); iter.hasNext(); )
/*      */       {
/* 2298 */         Message msg = (Message)iter.next();
/*      */ 
/* 2300 */         messageMap.put(new Long(msg.getMessageID()), msg);
/*      */       }
/*      */ 
/* 2303 */       List returnList = new ArrayList();
/*      */ 
/* 2305 */       for (Iterator iter = holders.iterator(); iter.hasNext(); )
/*      */       {
/* 2307 */         1Holder holder = (1Holder)iter.next();
/*      */ 
/* 2309 */         Message msg = (Message)messageMap.get(new Long(holder.messageId));
/*      */ 
/* 2311 */         if (msg == null)
/*      */         {
/* 2313 */           throw new IllegalStateException("Cannot find message " + holder.messageId);
/*      */         }
/*      */ 
/* 2316 */         PersistenceManager.MessageChannelPair pair = new PersistenceManager.MessageChannelPair(msg, holder.channelId);
/*      */ 
/* 2318 */         returnList.add(pair);
/*      */       }
/*      */ 
/* 2321 */       iter = returnList;
/*      */       return iter;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 2325 */       wrap.exceptionOccurred();
/* 2326 */       throw e;
/*      */     }
/*      */     finally
/*      */     {
/* 2330 */       closeResultSet(rs);
/* 2331 */       closeStatement(ps);
/* 2332 */       closeConnection(conn);
/* 2333 */       wrap.end();
/* 2334 */     }throw localObject;
/*      */   }
/*      */ 
/*      */   private synchronized long getOrdering()
/*      */   {
/* 2353 */     long order = System.currentTimeMillis();
/*      */ 
/* 2355 */     order <<= 15;
/*      */ 
/* 2357 */     order |= this.orderCount;
/*      */ 
/* 2359 */     if (this.orderCount == 32767)
/*      */     {
/* 2361 */       this.orderCount = 0;
/*      */     }
/*      */     else
/*      */     {
/* 2365 */       this.orderCount = (short)(this.orderCount + 1);
/*      */     }
/*      */ 
/* 2368 */     return order;
/*      */   }
/*      */ 
/*      */   private void orderReferences(List references)
/*      */   {
/* 2459 */     Collections.sort(references, MessageOrderComparator.instance);
/*      */   }
/*      */ 
/*      */   private static class MessageOrderComparator implements Comparator
/*      */   {
/* 2464 */     static MessageOrderComparator instance = new MessageOrderComparator();
/*      */ 
/*      */     public int compare(Object o1, Object o2)
/*      */     {
/*      */       MessageReference ref2;
/*      */       MessageReference ref1;
/*      */       MessageReference ref2;
/* 2471 */       if ((o1 instanceof MessageReference))
/*      */       {
/* 2473 */         MessageReference ref1 = (MessageReference)o1;
/* 2474 */         ref2 = (MessageReference)o2;
/*      */       }
/*      */       else
/*      */       {
/* 2478 */         ref1 = JDBCPersistenceManager.ChannelRefPair.access$700((JDBCPersistenceManager.ChannelRefPair)o1);
/* 2479 */         ref2 = JDBCPersistenceManager.ChannelRefPair.access$700((JDBCPersistenceManager.ChannelRefPair)o2);
/*      */       }
/*      */ 
/* 2482 */       long id1 = ref1.getMessage().getMessageID();
/* 2483 */       long id2 = ref2.getMessage().getMessageID();
/*      */ 
/* 2485 */       return id1 == id2 ? 0 : id1 < id2 ? -1 : 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   private class TransactionCallback
/*      */     implements TxCallback
/*      */   {
/*      */     private Transaction tx;
/*      */     private List refsToAdd;
/*      */     private List refsToRemove;
/*      */ 
/*      */     private TransactionCallback(Transaction tx)
/*      */     {
/* 2395 */       this.tx = tx;
/*      */ 
/* 2397 */       this.refsToAdd = new ArrayList();
/*      */ 
/* 2399 */       this.refsToRemove = new ArrayList();
/*      */     }
/*      */ 
/*      */     private void addReferenceToAdd(long channelId, MessageReference ref)
/*      */     {
/* 2404 */       this.refsToAdd.add(new JDBCPersistenceManager.ChannelRefPair(channelId, ref, null));
/*      */     }
/*      */ 
/*      */     private void addReferenceToRemove(long channelId, MessageReference ref)
/*      */     {
/* 2409 */       this.refsToRemove.add(new JDBCPersistenceManager.ChannelRefPair(channelId, ref, null));
/*      */     }
/*      */ 
/*      */     public void afterCommit(boolean onePhase)
/*      */     {
/*      */     }
/*      */ 
/*      */     public void afterPrepare()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void afterRollback(boolean onePhase)
/*      */     {
/*      */     }
/*      */ 
/*      */     public void beforeCommit(boolean onePhase)
/*      */       throws Exception
/*      */     {
/* 2429 */       if (onePhase)
/*      */       {
/* 2431 */         JDBCPersistenceManager.this.handleBeforeCommit1PC(this.refsToAdd, this.refsToRemove, this.tx);
/*      */       }
/*      */       else
/*      */       {
/* 2435 */         JDBCPersistenceManager.this.handleBeforeCommit2PC(this.refsToRemove, this.tx);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void beforePrepare() throws Exception
/*      */     {
/* 2441 */       JDBCPersistenceManager.this.handleBeforePrepare(this.refsToAdd, this.refsToRemove, this.tx);
/*      */     }
/*      */ 
/*      */     public void beforeRollback(boolean onePhase) throws Exception
/*      */     {
/* 2446 */       if (!onePhase)
/*      */       {
/* 2452 */         JDBCPersistenceManager.this.handleBeforeRollback(this.refsToAdd, this.tx);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class ChannelRefPair
/*      */   {
/*      */     private long channelID;
/*      */     private MessageReference ref;
/*      */ 
/*      */     private ChannelRefPair(long channelID, MessageReference ref)
/*      */     {
/* 2380 */       this.channelID = channelID;
/* 2381 */       this.ref = ref;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.JDBCPersistenceManager
 * JD-Core Version:    0.6.0
 */