/*     */ package org.jboss.messaging.core.impl;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Delivery;
/*     */ import org.jboss.messaging.core.contract.DeliveryObserver;
/*     */ import org.jboss.messaging.core.contract.Distributor;
/*     */ import org.jboss.messaging.core.contract.MessageReference;
/*     */ import org.jboss.messaging.core.contract.Receiver;
/*     */ import org.jboss.messaging.core.impl.tx.Transaction;
/*     */ 
/*     */ public class FirstReceiverDistributor
/*     */   implements Distributor
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(FirstReceiverDistributor.class);
/*     */ 
/*  58 */   private boolean trace = log.isTraceEnabled();
/*     */   private List receivers;
/*     */   private volatile boolean makeCopy;
/*     */   private ArrayList receiversCopy;
/*     */ 
/*     */   public FirstReceiverDistributor()
/*     */   {
/*  70 */     this.receivers = new ArrayList();
/*     */ 
/*  72 */     this.makeCopy = true;
/*     */   }
/*     */ 
/*     */   public Delivery handle(DeliveryObserver observer, MessageReference ref, Transaction tx)
/*     */   {
/*  79 */     if (this.makeCopy)
/*     */     {
/*  81 */       synchronized (this)
/*     */       {
/*  87 */         this.receiversCopy = new ArrayList(this.receivers);
/*     */ 
/*  89 */         this.makeCopy = false;
/*     */       }
/*     */     }
/*     */ 
/*  93 */     Delivery del = null;
/*     */ 
/*  95 */     boolean selectorRejected = false;
/*     */ 
/*  97 */     for (Iterator i = this.receiversCopy.iterator(); i.hasNext(); )
/*     */     {
/*  99 */       Receiver receiver = (Receiver)i.next();
/*     */       try
/*     */       {
/* 103 */         Delivery d = receiver.handle(observer, ref, tx);
/*     */ 
/* 105 */         if (this.trace) log.trace("receiver " + receiver + " handled " + ref + " and returned " + d);
/*     */ 
/* 107 */         if (d != null)
/*     */         {
/* 109 */           if (d.isSelectorAccepted())
/*     */           {
/* 112 */             del = d;
/* 113 */             break;
/*     */           }
/*     */ 
/* 117 */           selectorRejected = true;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 124 */         log.error("The receiver " + receiver + " is broken", t);
/*     */       }
/*     */     }
/*     */ 
/* 128 */     if ((del == null) && (selectorRejected))
/*     */     {
/* 130 */       del = new SimpleDelivery(null, null, false, false);
/*     */     }
/*     */ 
/* 133 */     return del;
/*     */   }
/*     */ 
/*     */   public synchronized boolean add(Receiver r)
/*     */   {
/* 139 */     if (this.receivers.contains(r))
/*     */     {
/* 141 */       return false;
/*     */     }
/*     */ 
/* 144 */     this.receivers.add(r);
/*     */ 
/* 146 */     this.makeCopy = true;
/*     */ 
/* 148 */     return true;
/*     */   }
/*     */ 
/*     */   public synchronized boolean remove(Receiver r)
/*     */   {
/* 154 */     boolean removed = this.receivers.remove(r);
/*     */ 
/* 156 */     if (removed)
/*     */     {
/* 158 */       this.makeCopy = true;
/*     */     }
/*     */ 
/* 161 */     return removed;
/*     */   }
/*     */ 
/*     */   public synchronized void clear()
/*     */   {
/* 166 */     this.receivers.clear();
/*     */ 
/* 168 */     this.makeCopy = true;
/*     */   }
/*     */ 
/*     */   public synchronized boolean contains(Receiver r)
/*     */   {
/* 173 */     return this.receivers.contains(r);
/*     */   }
/*     */ 
/*     */   public synchronized Iterator iterator()
/*     */   {
/* 178 */     return this.receivers.iterator();
/*     */   }
/*     */ 
/*     */   public synchronized int getNumberOfReceivers()
/*     */   {
/* 183 */     return this.receivers.size();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.messaging.core.impl.FirstReceiverDistributor
 * JD-Core Version:    0.6.0
 */