/*    */ package org.jboss.managed.plugins.advice;
/*    */ 
/*    */ import java.util.Iterator;
/*    */ 
/*    */ public class WrapperIterator<T>
/*    */   implements Iterator<T>
/*    */ {
/*    */   private Iterator<T> delegate;
/*    */   private Class<T> interfaceClass;
/*    */ 
/*    */   public WrapperIterator(Iterator<T> delegate, Class<T> interfaceClass)
/*    */   {
/* 49 */     if (delegate == null)
/* 50 */       throw new IllegalArgumentException("Null delegate");
/* 51 */     if (interfaceClass == null) {
/* 52 */       throw new IllegalArgumentException("Null interface class");
/*    */     }
/* 54 */     this.delegate = delegate;
/* 55 */     this.interfaceClass = interfaceClass;
/*    */   }
/*    */ 
/*    */   public boolean hasNext()
/*    */   {
/* 60 */     return this.delegate.hasNext();
/*    */   }
/*    */ 
/*    */   public T next()
/*    */   {
/* 65 */     Object next = this.delegate.next();
/* 66 */     return WrapperAdvice.createProxy(next, this.interfaceClass);
/*    */   }
/*    */ 
/*    */   public void remove()
/*    */   {
/* 71 */     throw new UnsupportedOperationException();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.managed.plugins.advice.WrapperIterator
 * JD-Core Version:    0.6.0
 */