/*     */ package org.jboss.managed.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ import org.jboss.managed.api.ManagedOperation;
/*     */ import org.jboss.managed.api.ManagedProperty;
/*     */ 
/*     */ public class ManagedObjectImpl
/*     */   implements ManagedObject
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   private String name;
/*     */   private String nameType;
/*     */   private String attachmentName;
/*     */   private Serializable attachment;
/*  58 */   private Map<String, Annotation> annotations = Collections.emptyMap();
/*     */   private Map<String, ManagedProperty> properties;
/*     */   private Set<ManagedOperation> operations;
/*     */   private transient Object componentName;
/*     */ 
/*     */   public ManagedObjectImpl(String name)
/*     */   {
/*  74 */     this(name, name, null, toMap(null), new HashSet(), null);
/*     */   }
/*     */ 
/*     */   public ManagedObjectImpl(String name, Set<ManagedProperty> properties)
/*     */   {
/*  85 */     this(name, name, null, properties, new HashSet(), null);
/*     */   }
/*     */ 
/*     */   public ManagedObjectImpl(String name, Set<ManagedProperty> properties, HashSet<ManagedOperation> operations)
/*     */   {
/*  98 */     this(name, name, null, properties, operations, null);
/*     */   }
/*     */ 
/*     */   public ManagedObjectImpl(String name, String nameType, String attachmentName, Set<ManagedProperty> properties, HashSet<ManagedOperation> operations, Serializable attachment)
/*     */   {
/* 120 */     this(name, nameType, attachmentName, toMap(properties), operations, attachment);
/*     */   }
/*     */ 
/*     */   public ManagedObjectImpl(String name, String nameType, String attachmentName, Map<String, ManagedProperty> properties, HashSet<ManagedOperation> operations, Serializable attachment)
/*     */   {
/* 142 */     if (name == null)
/* 143 */       throw new IllegalArgumentException("Null name");
/* 144 */     if (properties == null) {
/* 145 */       throw new IllegalArgumentException("Null properties");
/*     */     }
/* 147 */     this.name = name;
/*     */ 
/* 149 */     this.nameType = nameType;
/* 150 */     this.attachmentName = attachmentName;
/* 151 */     this.properties = properties;
/* 152 */     this.operations = operations;
/* 153 */     setAttachment(attachment);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 158 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 163 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getNameType()
/*     */   {
/* 168 */     return this.nameType;
/*     */   }
/*     */ 
/*     */   public void setNameType(String nameType)
/*     */   {
/* 173 */     this.nameType = nameType;
/*     */   }
/*     */ 
/*     */   public String getAttachmentName()
/*     */   {
/* 178 */     return this.attachmentName;
/*     */   }
/*     */ 
/*     */   public void setAttachmentName(String attachmentName)
/*     */   {
/* 183 */     this.attachmentName = attachmentName;
/*     */   }
/*     */ 
/*     */   public Map<String, Annotation> getAnnotations()
/*     */   {
/* 192 */     return this.annotations;
/*     */   }
/*     */ 
/*     */   public void setAnnotations(Map<String, Annotation> annotations)
/*     */   {
/* 197 */     if (this.annotations.isEmpty())
/* 198 */       this.annotations = new HashMap();
/*     */     else
/* 200 */       this.annotations.clear();
/* 201 */     this.annotations.putAll(annotations);
/*     */   }
/*     */ 
/*     */   public Set<String> getPropertyNames()
/*     */   {
/* 206 */     return this.properties.keySet();
/*     */   }
/*     */ 
/*     */   public ManagedProperty getProperty(String name)
/*     */   {
/* 211 */     if (name == null) {
/* 212 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 214 */     return (ManagedProperty)this.properties.get(name);
/*     */   }
/*     */ 
/*     */   public Map<String, ManagedProperty> getProperties()
/*     */   {
/* 219 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public void setProperties(Map<String, ManagedProperty> properties)
/*     */   {
/* 224 */     this.properties = properties;
/*     */   }
/*     */ 
/*     */   public Serializable getAttachment()
/*     */   {
/* 229 */     return this.attachment;
/*     */   }
/*     */ 
/*     */   public void setAttachment(Serializable attachment)
/*     */   {
/* 239 */     this.attachment = attachment;
/*     */   }
/*     */ 
/*     */   public Set<ManagedOperation> getOperations()
/*     */   {
/* 248 */     return this.operations;
/*     */   }
/*     */ 
/*     */   public void setOperations(Set<ManagedOperation> operations)
/*     */   {
/* 253 */     this.operations = operations;
/*     */   }
/*     */ 
/*     */   public Object getComponentName()
/*     */   {
/* 258 */     return this.componentName;
/*     */   }
/*     */ 
/*     */   public void setComponentName(Object name)
/*     */   {
/* 263 */     this.componentName = name;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 269 */     if (obj == this)
/* 270 */       return true;
/* 271 */     if ((obj == null) || (!(obj instanceof ManagedObject))) {
/* 272 */       return false;
/*     */     }
/* 274 */     ManagedObject other = (ManagedObject)obj;
/* 275 */     return (getName().equals(other.getName())) && (getProperties().equals(other.getProperties()));
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 281 */     return this.name.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 287 */     return "ManagedObject{" + this.name + "}";
/*     */   }
/*     */ 
/*     */   protected void toString(StringBuilder sb)
/*     */   {
/* 296 */     sb.append("name=");
/* 297 */     sb.append(this.name);
/* 298 */     sb.append(", nameType=");
/* 299 */     sb.append(this.nameType);
/* 300 */     sb.append(", attachmentName=");
/* 301 */     sb.append(this.attachmentName);
/* 302 */     sb.append(", properties=");
/* 303 */     sb.append(this.properties);
/*     */   }
/*     */ 
/*     */   private static Map<String, ManagedProperty> toMap(Set<ManagedProperty> props)
/*     */   {
/* 308 */     HashMap properties = new HashMap();
/* 309 */     if ((props != null) && (!props.isEmpty()))
/*     */     {
/* 311 */       for (ManagedProperty prop : props)
/*     */       {
/* 313 */         properties.put(prop.getName(), prop);
/*     */       }
/*     */     }
/* 316 */     return properties;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.managed.plugins.ManagedObjectImpl
 * JD-Core Version:    0.6.0
 */