/*     */ package org.jboss.logging.util;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import org.apache.log4j.Category;
/*     */ import org.apache.log4j.Priority;
/*     */ 
/*     */ /** @deprecated */
/*     */ public class CategoryStream extends PrintStream
/*     */ {
/*  51 */   public static final boolean TRACE = getBoolean(CategoryStream.class.getName() + ".trace", false);
/*     */   private Category category;
/*     */   private Priority priority;
/*     */   private boolean issuedWarning;
/* 110 */   private ThreadLocal recursiveCheck = new ThreadLocal();
/*     */ 
/*     */   private static boolean getBoolean(String name, boolean defaultValue)
/*     */   {
/*  57 */     String value = System.getProperty(name, null);
/*  58 */     if (value == null)
/*  59 */       return defaultValue;
/*  60 */     return new Boolean(value).booleanValue();
/*     */   }
/*     */ 
/*     */   public CategoryStream(Category category)
/*     */   {
/*  72 */     this(category, Priority.INFO, System.out);
/*     */   }
/*     */ 
/*     */   public CategoryStream(Category category, Priority priority, PrintStream ps)
/*     */   {
/*  83 */     super(ps);
/*  84 */     this.category = category;
/*  85 */     this.priority = priority;
/*     */   }
/*     */ 
/*     */   public void println(String msg)
/*     */   {
/*  90 */     if (msg == null)
/*  91 */       msg = "null";
/*  92 */     byte[] bytes = msg.getBytes();
/*  93 */     write(bytes, 0, bytes.length);
/*     */   }
/*     */ 
/*     */   public void println(Object msg)
/*     */   {
/*  98 */     if (msg == null)
/*  99 */       msg = "null";
/* 100 */     byte[] bytes = msg.toString().getBytes();
/* 101 */     write(bytes, 0, bytes.length);
/*     */   }
/*     */ 
/*     */   public void write(byte b)
/*     */   {
/* 106 */     byte[] bytes = { b };
/* 107 */     write(bytes, 0, 1);
/*     */   }
/*     */ 
/*     */   public void write(byte[] b, int off, int len)
/*     */   {
/* 113 */     Boolean recursed = (Boolean)this.recursiveCheck.get();
/* 114 */     if ((recursed != null) && (recursed.equals(Boolean.TRUE)))
/*     */     {
/* 120 */       if (!this.issuedWarning)
/*     */       {
/* 122 */         String msg = "ERROR: invalid console appender config detected, console stream is looping";
/*     */         try
/*     */         {
/* 125 */           this.out.write(msg.getBytes());
/*     */         }
/*     */         catch (IOException ignore)
/*     */         {
/*     */         }
/* 130 */         this.issuedWarning = true;
/*     */       }
/* 132 */       return;
/*     */     }
/*     */ 
/* 136 */     while ((len > 0) && ((b[(len - 1)] == 10) || (b[(len - 1)] == 13)) && (len > off)) {
/* 137 */       len--;
/*     */     }
/*     */ 
/* 142 */     if (len != 0)
/*     */     {
/* 144 */       String msg = new String(b, off, len);
/* 145 */       this.recursiveCheck.set(Boolean.TRUE);
/* 146 */       if (TRACE)
/*     */       {
/* 148 */         this.category.log(this.priority, msg, new Throwable());
/*     */       }
/*     */       else
/*     */       {
/* 152 */         this.category.log(this.priority, msg);
/*     */       }
/* 154 */       this.recursiveCheck.set(Boolean.FALSE);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.logging.util.CategoryStream
 * JD-Core Version:    0.6.0
 */