/*     */ package org.jboss.logging.log4j;
/*     */ 
/*     */ import org.apache.log4j.Category;
/*     */ import org.apache.log4j.Level;
/*     */ import org.apache.log4j.LogManager;
/*     */ import org.apache.log4j.Priority;
/*     */ import org.jboss.logging.LoggerPlugin;
/*     */ import org.jboss.logging.XLevel;
/*     */ 
/*     */ public class Log4jLoggerPlugin
/*     */   implements LoggerPlugin
/*     */ {
/*  65 */   private static final String FQCN = org.jboss.logging.Logger.class.getName();
/*     */   private transient org.apache.log4j.Logger log;
/*     */ 
/*     */   public void init(String name)
/*     */   {
/*  80 */     this.log = LogManager.getLogger(name);
/*     */   }
/*     */ 
/*     */   public Category getCategory()
/*     */   {
/*  87 */     return this.log;
/*     */   }
/*     */ 
/*     */   public org.apache.log4j.Logger getLogger()
/*     */   {
/*  95 */     return this.log;
/*     */   }
/*     */ 
/*     */   public boolean isTraceEnabled()
/*     */   {
/* 102 */     if (!this.log.isEnabledFor(XLevel.TRACE))
/* 103 */       return false;
/* 104 */     return XLevel.TRACE.isGreaterOrEqual(this.log.getEffectiveLevel());
/*     */   }
/*     */ 
/*     */   public void trace(Object message)
/*     */   {
/* 113 */     this.log.log(FQCN, XLevel.TRACE, message, null);
/*     */   }
/*     */ 
/*     */   public void trace(Object message, Throwable t)
/*     */   {
/* 122 */     this.log.log(FQCN, XLevel.TRACE, message, t);
/*     */   }
/*     */ 
/*     */   public boolean isDebugEnabled()
/*     */   {
/* 133 */     Level l = Level.DEBUG;
/* 134 */     if (!this.log.isEnabledFor(l))
/* 135 */       return false;
/* 136 */     return l.isGreaterOrEqual(this.log.getEffectiveLevel());
/*     */   }
/*     */ 
/*     */   public void debug(Object message)
/*     */   {
/* 145 */     this.log.log(FQCN, Level.DEBUG, message, null);
/*     */   }
/*     */ 
/*     */   public void debug(Object message, Throwable t)
/*     */   {
/* 154 */     this.log.log(FQCN, Level.DEBUG, message, t);
/*     */   }
/*     */ 
/*     */   public boolean isInfoEnabled()
/*     */   {
/* 165 */     Level l = Level.INFO;
/* 166 */     if (!this.log.isEnabledFor(l))
/* 167 */       return false;
/* 168 */     return l.isGreaterOrEqual(this.log.getEffectiveLevel());
/*     */   }
/*     */ 
/*     */   public void info(Object message)
/*     */   {
/* 177 */     this.log.log(FQCN, Level.INFO, message, null);
/*     */   }
/*     */ 
/*     */   public void info(Object message, Throwable t)
/*     */   {
/* 186 */     this.log.log(FQCN, Level.INFO, message, t);
/*     */   }
/*     */ 
/*     */   public void warn(Object message)
/*     */   {
/* 195 */     this.log.log(FQCN, Level.WARN, message, null);
/*     */   }
/*     */ 
/*     */   public void warn(Object message, Throwable t)
/*     */   {
/* 204 */     this.log.log(FQCN, Level.WARN, message, t);
/*     */   }
/*     */ 
/*     */   public void error(Object message)
/*     */   {
/* 213 */     this.log.log(FQCN, Level.ERROR, message, null);
/*     */   }
/*     */ 
/*     */   public void error(Object message, Throwable t)
/*     */   {
/* 222 */     this.log.log(FQCN, Level.ERROR, message, t);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message)
/*     */   {
/* 231 */     this.log.log(FQCN, Level.FATAL, message, null);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message, Throwable t)
/*     */   {
/* 240 */     this.log.log(FQCN, Level.FATAL, message, t);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void log(Priority p, Object message)
/*     */   {
/* 251 */     this.log.log(FQCN, p, message, null);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void log(Priority p, Object message, Throwable t)
/*     */   {
/* 262 */     this.log.log(FQCN, p, message, t);
/*     */   }
/*     */ 
/*     */   public void log(Level l, Object message)
/*     */   {
/* 271 */     this.log.log(FQCN, l, message, null);
/*     */   }
/*     */ 
/*     */   public void log(Level l, Object message, Throwable t)
/*     */   {
/* 280 */     this.log.log(FQCN, l, message, t);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.logging.log4j.Log4jLoggerPlugin
 * JD-Core Version:    0.6.0
 */