/*    */ package org.jboss.kernel.spi.dependency.helpers;
/*    */ 
/*    */ import org.jboss.beans.info.spi.BeanInfo;
/*    */ import org.jboss.beans.info.spi.helpers.UnmodifiableBeanInfo;
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.dependency.spi.helpers.UnmodifiableControllerContext;
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ 
/*    */ public class UnmodifiableKernelControllerContext extends UnmodifiableControllerContext<KernelControllerContext>
/*    */   implements KernelControllerContext
/*    */ {
/*    */   public UnmodifiableKernelControllerContext(KernelControllerContext delegate)
/*    */   {
/* 41 */     super(delegate);
/*    */   }
/*    */ 
/*    */   public Kernel getKernel()
/*    */   {
/* 46 */     return ((KernelControllerContext)this.delegate).getKernel();
/*    */   }
/*    */ 
/*    */   public BeanInfo getBeanInfo()
/*    */   {
/* 51 */     BeanInfo beanInfo = ((KernelControllerContext)this.delegate).getBeanInfo();
/* 52 */     return beanInfo != null ? new UnmodifiableBeanInfo(beanInfo) : null;
/*    */   }
/*    */ 
/*    */   public void setBeanInfo(BeanInfo info)
/*    */   {
/* 57 */     throw new UnsupportedOperationException("Cannot execute set on unmodifiable wrapper.");
/*    */   }
/*    */ 
/*    */   public BeanMetaData getBeanMetaData()
/*    */   {
/* 62 */     return ((KernelControllerContext)this.delegate).getBeanMetaData();
/*    */   }
/*    */ 
/*    */   public void setTarget(Object target)
/*    */   {
/* 67 */     throw new UnsupportedOperationException("Cannot execute set on unmodifiable wrapper.");
/*    */   }
/*    */ 
/*    */   public void setName(Object name)
/*    */   {
/* 72 */     throw new UnsupportedOperationException("Cannot execute set on unmodifiable wrapper.");
/*    */   }
/*    */ 
/*    */   public Object invoke(String name, Object[] parameters, String[] signature) throws Throwable
/*    */   {
/* 77 */     return ((KernelControllerContext)this.delegate).invoke(name, parameters, signature);
/*    */   }
/*    */ 
/*    */   public ClassLoader getClassLoader() throws Throwable
/*    */   {
/* 82 */     return ((KernelControllerContext)this.delegate).getClassLoader();
/*    */   }
/*    */ 
/*    */   public Object get(String name) throws Throwable
/*    */   {
/* 87 */     return ((KernelControllerContext)this.delegate).get(name);
/*    */   }
/*    */ 
/*    */   public void set(String name, Object value) throws Throwable
/*    */   {
/* 92 */     ((KernelControllerContext)this.delegate).set(name, value);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.spi.dependency.helpers.UnmodifiableKernelControllerContext
 * JD-Core Version:    0.6.0
 */