/*     */ package org.jboss.kernel.plugins.registry.basic;
/*     */ 
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.dispatch.AttributeDispatchContext;
/*     */ import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
/*     */ import org.jboss.kernel.plugins.registry.AbstractKernelBus;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ 
/*     */ public class BasicKernelBus extends AbstractKernelBus
/*     */ {
/*     */   protected <T> Object execute(Object name, Class<T> clazz, Dispatcher<T> dispatcher)
/*     */     throws Throwable
/*     */   {
/*  49 */     ControllerContext context = this.controller.getInstalledContext(name);
/*  50 */     if (context == null)
/*  51 */       throw new IllegalArgumentException("No such context: " + name);
/*  52 */     if (!clazz.isAssignableFrom(context.getClass()))
/*  53 */       throw new IllegalArgumentException("Cannot execute " + dispatcher + " on non " + clazz.getSimpleName() + " context: " + context);
/*  54 */     return dispatcher.dispatch(clazz.cast(context));
/*     */   }
/*     */ 
/*     */   public Object get(Object name, String getter) throws Throwable
/*     */   {
/*  59 */     return execute(name, AttributeDispatchContext.class, new Dispatcher(getter)
/*     */     {
/*     */       public Object dispatch(AttributeDispatchContext context) throws Throwable
/*     */       {
/*  63 */         return context.get(this.val$getter);
/*     */       }
/*     */ 
/*     */       public String toString()
/*     */       {
/*  68 */         return "get";
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public void set(Object name, String setter, Object value) throws Throwable {
/*  75 */     execute(name, AttributeDispatchContext.class, new Dispatcher(setter, value)
/*     */     {
/*     */       public Object dispatch(AttributeDispatchContext context) throws Throwable
/*     */       {
/*  79 */         context.set(this.val$setter, this.val$value);
/*  80 */         return null;
/*     */       }
/*     */ 
/*     */       public String toString()
/*     */       {
/*  85 */         return "set";
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public Object invoke(Object name, String methodName, Object[] parameters, String[] signature) throws Throwable {
/*  92 */     return execute(name, InvokeDispatchContext.class, new Dispatcher(methodName, parameters, signature)
/*     */     {
/*     */       public Object dispatch(InvokeDispatchContext context) throws Throwable
/*     */       {
/*  96 */         return context.invoke(this.val$methodName, this.val$parameters, this.val$signature);
/*     */       }
/*     */ 
/*     */       public String toString()
/*     */       {
/* 101 */         return "invoke";
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   private static abstract interface Dispatcher<T>
/*     */   {
/*     */     public abstract Object dispatch(T paramT)
/*     */       throws Throwable;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.registry.basic.BasicKernelBus
 * JD-Core Version:    0.6.0
 */