/*    */ package org.jboss.kernel.plugins.registry;
/*    */ 
/*    */ import org.jboss.beans.info.spi.BeanInfo;
/*    */ import org.jboss.dependency.spi.dispatch.AttributeDispatchContext;
/*    */ 
/*    */ public class BeanKernelRegistryEntry extends AbstractKernelRegistryEntry
/*    */   implements AttributeDispatchContext
/*    */ {
/*    */   private BeanInfo beanInfo;
/*    */ 
/*    */   public BeanKernelRegistryEntry(Object target, BeanInfo beanInfo)
/*    */   {
/* 38 */     super(target);
/* 39 */     if (beanInfo == null)
/* 40 */       throw new IllegalArgumentException("Null bean info.");
/* 41 */     this.beanInfo = beanInfo;
/*    */   }
/*    */ 
/*    */   public BeanKernelRegistryEntry(Object name, Object target, BeanInfo beanInfo)
/*    */   {
/* 46 */     super(name, target);
/* 47 */     this.beanInfo = beanInfo;
/*    */   }
/*    */ 
/*    */   public Object get(String name) throws Throwable
/*    */   {
/* 52 */     return this.beanInfo.getProperty(this.target, name);
/*    */   }
/*    */ 
/*    */   public void set(String name, Object value) throws Throwable
/*    */   {
/* 57 */     this.beanInfo.setProperty(this.target, name, value);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.registry.BeanKernelRegistryEntry
 * JD-Core Version:    0.6.0
 */