/*     */ package org.jboss.kernel.plugins.registry;
/*     */ 
/*     */ import java.util.Set;
/*     */ import org.jboss.dependency.plugins.AbstractScopeInfo;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.dependency.spi.ScopeInfo;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryEntry;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ 
/*     */ public class AbstractKernelRegistryEntry extends JBossObject
/*     */   implements KernelRegistryEntry
/*     */ {
/*     */   protected Object name;
/*     */   protected Object target;
/*     */ 
/*     */   public AbstractKernelRegistryEntry(Object target)
/*     */   {
/*  58 */     this.target = target;
/*     */   }
/*     */ 
/*     */   public AbstractKernelRegistryEntry(Object name, Object target)
/*     */   {
/*  69 */     this.name = name;
/*  70 */     this.target = target;
/*     */   }
/*     */ 
/*     */   public Object getName()
/*     */   {
/*  75 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(Object name)
/*     */   {
/*  80 */     this.name = name;
/*  81 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public Set<Object> getAliases()
/*     */   {
/*  86 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getTarget()
/*     */   {
/*  91 */     return this.target;
/*     */   }
/*     */ 
/*     */   public Controller getController()
/*     */   {
/*  98 */     throw new NotImplementedException("getController");
/*     */   }
/*     */ 
/*     */   public DependencyInfo getDependencyInfo()
/*     */   {
/* 103 */     return null;
/*     */   }
/*     */ 
/*     */   public ScopeInfo getScopeInfo()
/*     */   {
/* 108 */     String className = null;
/* 109 */     Object target = getTarget();
/* 110 */     if (target != null)
/* 111 */       className = target.getClass().getName();
/* 112 */     return new AbstractScopeInfo(getName(), className);
/*     */   }
/*     */ 
/*     */   public Throwable getError()
/*     */   {
/* 117 */     throw new NotImplementedException("getError");
/*     */   }
/*     */ 
/*     */   public ControllerState getState()
/*     */   {
/* 122 */     return ControllerState.ERROR;
/*     */   }
/*     */ 
/*     */   public void setState(ControllerState state)
/*     */   {
/* 127 */     throw new NotImplementedException("setState");
/*     */   }
/*     */ 
/*     */   public ControllerState getRequiredState()
/*     */   {
/* 132 */     throw new NotImplementedException("getRequiredState");
/*     */   }
/*     */ 
/*     */   public void setRequiredState(ControllerState state)
/*     */   {
/* 137 */     throw new NotImplementedException("setRequiredState");
/*     */   }
/*     */ 
/*     */   public ControllerMode getMode()
/*     */   {
/* 142 */     return ControllerMode.MANUAL;
/*     */   }
/*     */ 
/*     */   public void setMode(ControllerMode mode)
/*     */   {
/* 147 */     throw new NotImplementedException("setMode");
/*     */   }
/*     */ 
/*     */   public void install(ControllerState fromState, ControllerState toState) throws Throwable
/*     */   {
/* 152 */     throw new NotImplementedException("install");
/*     */   }
/*     */ 
/*     */   public void setController(Controller controller)
/*     */   {
/* 158 */     throw new NotImplementedException("setController");
/*     */   }
/*     */ 
/*     */   public void setError(Throwable error)
/*     */   {
/* 164 */     throw new NotImplementedException("NYI setError");
/*     */   }
/*     */ 
/*     */   public void uninstall(ControllerState fromState, ControllerState toState)
/*     */   {
/* 170 */     throw new NotImplementedException("uninstall");
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 176 */     buffer.append("target=").append(this.target);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 181 */     buffer.append(this.target);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.registry.AbstractKernelRegistryEntry
 * JD-Core Version:    0.6.0
 */