/*     */ package org.jboss.kernel.plugins.registry;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.ListIterator;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import org.jboss.kernel.plugins.AbstractKernelObject;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistry;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryEntry;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryEntryNotFoundException;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class AbstractKernelRegistry extends AbstractKernelObject
/*     */   implements KernelRegistry
/*     */ {
/*  45 */   protected List<KernelRegistryPlugin> factories = new CopyOnWriteArrayList();
/*     */ 
/*     */   public AbstractKernelRegistry()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void addKernelRegistryFactory(KernelRegistryPlugin factory)
/*     */   {
/*  63 */     this.factories.add(factory);
/*  64 */     if (this.log.isTraceEnabled())
/*  65 */       this.log.trace("Registry " + this + " added registry factory " + factory);
/*     */   }
/*     */ 
/*     */   public void removeKernelRegistryFactory(KernelRegistryPlugin factory)
/*     */   {
/*  75 */     this.factories.remove(factory);
/*  76 */     if (this.log.isTraceEnabled())
/*  77 */       this.log.trace("Registry " + this + " removed registry factory " + factory);
/*     */   }
/*     */ 
/*     */   public KernelRegistryEntry getEntry(Object name)
/*     */   {
/*  82 */     for (ListIterator i = this.factories.listIterator(); i.hasNext(); )
/*     */     {
/*  84 */       KernelRegistryPlugin factory = (KernelRegistryPlugin)i.next();
/*  85 */       KernelRegistryEntry entry = factory.getEntry(name);
/*  86 */       if (entry != null)
/*  87 */         return entry;
/*     */     }
/*  89 */     throw new KernelRegistryEntryNotFoundException("Entry not found with name: " + name);
/*     */   }
/*     */ 
/*     */   public boolean containsEntry(Object name)
/*     */   {
/*  94 */     Iterator i = this.factories.iterator();
/*  95 */     while (i.hasNext())
/*     */     {
/*  97 */       KernelRegistryPlugin factory = (KernelRegistryPlugin)i.next();
/*  98 */       KernelRegistryEntry entry = factory.getEntry(name);
/*  99 */       if (entry != null)
/* 100 */         return true;
/*     */     }
/* 102 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.registry.AbstractKernelRegistry
 * JD-Core Version:    0.6.0
 */