/*     */ package org.jboss.kernel.plugins.metadata.basic;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ScopeInfo;
/*     */ import org.jboss.kernel.plugins.metadata.AbstractKernelMetaDataRepository;
/*     */ import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
/*     */ import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
/*     */ import org.jboss.metadata.plugins.repository.basic.BasicMetaDataRepository;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.scope.Scope;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ 
/*     */ public class BasicKernelMetaDataRepository extends AbstractKernelMetaDataRepository
/*     */ {
/*     */   public BasicKernelMetaDataRepository()
/*     */   {
/*  51 */     super(new BasicMetaDataRepository());
/*     */   }
/*     */ 
/*     */   public MetaData getMetaData(ControllerContext context)
/*     */   {
/*  56 */     MutableMetaDataRepository repository = getMetaDataRepository();
/*  57 */     ScopeKey scope = context.getScopeInfo().getScope();
/*  58 */     MetaData metaData = repository.getMetaData(scope);
/*  59 */     if (metaData == null)
/*     */     {
/*  61 */       initMetaDataRetrieval(context);
/*  62 */       metaData = repository.getMetaData(scope);
/*  63 */       if (metaData == null)
/*  64 */         throw new IllegalStateException("Error initialising metadata state: " + scope);
/*     */     }
/*  66 */     return metaData;
/*     */   }
/*     */ 
/*     */   public void addMetaData(ControllerContext context)
/*     */   {
/*  71 */     MutableMetaDataRepository repository = getMetaDataRepository();
/*  72 */     ScopeInfo scopeInfo = context.getScopeInfo();
/*  73 */     scopeInfo.addMetaData(repository, context);
/*     */   }
/*     */ 
/*     */   public void removeMetaData(ControllerContext context)
/*     */   {
/*  78 */     MutableMetaDataRepository repository = getMetaDataRepository();
/*  79 */     ScopeInfo scopeInfo = context.getScopeInfo();
/*  80 */     scopeInfo.removeMetaData(repository, context);
/*     */   }
/*     */ 
/*     */   public ScopeKey getFullScope(ControllerContext context)
/*     */   {
/*  85 */     return context.getScopeInfo().getScope();
/*     */   }
/*     */ 
/*     */   public ScopeKey getMutableScope(ControllerContext context)
/*     */   {
/*  90 */     return context.getScopeInfo().getMutableScope();
/*     */   }
/*     */ 
/*     */   protected MetaDataRetrieval initMetaDataRetrieval(ControllerContext context)
/*     */   {
/* 101 */     MutableMetaDataRepository repository = getMetaDataRepository();
/* 102 */     ScopeInfo scopeInfo = context.getScopeInfo();
/* 103 */     ScopeKey scopeKey = scopeInfo.getScope();
/* 104 */     ArrayList retrievals = new ArrayList();
/* 105 */     for (Scope scope : scopeKey.getScopes())
/*     */     {
/* 107 */       ScopeKey thisScope = new ScopeKey(scope);
/* 108 */       MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(thisScope);
/* 109 */       if (retrieval == null)
/*     */       {
/* 111 */         retrieval = scopeInfo.initMetaDataRetrieval(repository, context, scope);
/* 112 */         if (retrieval == null)
/*     */         {
/* 114 */           retrieval = new MemoryMetaDataLoader(thisScope);
/* 115 */           repository.addMetaDataRetrieval(retrieval);
/*     */         }
/*     */       }
/* 118 */       retrievals.add(0, retrieval);
/*     */     }
/* 120 */     AbstractMetaDataContext metaDataContext = new AbstractMetaDataContext(null, retrievals);
/* 121 */     repository.addMetaDataRetrieval(metaDataContext);
/* 122 */     return metaDataContext;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.metadata.basic.BasicKernelMetaDataRepository
 * JD-Core Version:    0.6.0
 */