/*    */ package org.jboss.kernel.plugins.event;
/*    */ 
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.kernel.plugins.AbstractKernelObject;
/*    */ import org.jboss.kernel.spi.event.KernelEventEmitter;
/*    */ import org.jboss.kernel.spi.event.KernelEventFilter;
/*    */ import org.jboss.kernel.spi.event.KernelEventListener;
/*    */ import org.jboss.kernel.spi.event.KernelEventManager;
/*    */ import org.jboss.kernel.spi.registry.KernelRegistry;
/*    */ import org.jboss.kernel.spi.registry.KernelRegistryEntry;
/*    */ 
/*    */ public class AbstractEventManager extends AbstractKernelObject
/*    */   implements KernelEventManager
/*    */ {
/*    */   protected KernelRegistry registry;
/*    */ 
/*    */   public AbstractEventManager()
/*    */     throws Throwable
/*    */   {
/*    */   }
/*    */ 
/*    */   public void setKernel(Kernel kernel)
/*    */     throws Throwable
/*    */   {
/* 55 */     super.setKernel(kernel);
/* 56 */     this.registry = kernel.getRegistry();
/*    */   }
/*    */ 
/*    */   public void registerListener(Object name, KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable
/*    */   {
/* 61 */     getEmitter(name).registerListener(listener, filter, handback);
/*    */   }
/*    */ 
/*    */   public void unregisterListener(Object name, KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable
/*    */   {
/* 66 */     getEmitter(name).unregisterListener(listener, filter, handback);
/*    */   }
/*    */ 
/*    */   protected KernelEventEmitter getEmitter(Object name) throws Throwable
/*    */   {
/* 71 */     KernelRegistryEntry entry = this.registry.getEntry(name);
/*    */ 
/* 73 */     Object object = entry.getTarget();
/* 74 */     if ((object == null) || (!(object instanceof KernelEventEmitter))) {
/* 75 */       throw new ClassCastException(name + " is not a " + KernelEventEmitter.class.getName());
/*    */     }
/* 77 */     return (KernelEventEmitter)object;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.event.AbstractEventManager
 * JD-Core Version:    0.6.0
 */