/*    */ package org.jboss.kernel.plugins.deployment.props.vertex;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import java.util.Map;
/*    */ import java.util.Set;
/*    */ import java.util.TreeSet;
/*    */ import org.jboss.kernel.plugins.deployment.props.DeploymentVertex;
/*    */ import org.jboss.kernel.plugins.deployment.props.TreeVertex;
/*    */ import org.jboss.kernel.plugins.deployment.props.VertexFactory;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.util.graph.Graph;
/*    */ import org.jboss.util.graph.Vertex;
/*    */ import org.jboss.util.graph.Visitor;
/*    */ 
/*    */ public class DefaultVertexFactory
/*    */   implements VertexFactory
/*    */ {
/* 45 */   protected Logger logger = Logger.getLogger(getClass());
/*    */ 
/* 47 */   protected Map<Integer, Set<LevelVertexFactory>> levelFactories = new HashMap();
/*    */ 
/*    */   public DefaultVertexFactory()
/*    */   {
/* 51 */     addLevelFactory(0, new BeanVertexFactory());
/* 52 */     addLevelFactory(1, new ClassVertexFactory());
/* 53 */     addLevelFactory(1, new PropertyVertexFactory());
/* 54 */     addLevelFactory(2, new HolderVertexFactory());
/*    */   }
/*    */ 
/*    */   public void addLevelFactory(int level, LevelVertexFactory factory)
/*    */   {
/* 59 */     Set factories = (Set)this.levelFactories.get(Integer.valueOf(level));
/* 60 */     if (factories == null)
/*    */     {
/* 62 */       factories = new TreeSet(LevelVertexFactory.COMPARATOR);
/* 63 */       this.levelFactories.put(Integer.valueOf(level), factories);
/*    */     }
/* 65 */     factories.add(factory);
/*    */   }
/*    */ 
/*    */   public DeploymentVertex rootVertex()
/*    */   {
/* 70 */     return new BaseDeploymentVertex();
/*    */   }
/*    */ 
/*    */   public TreeVertex createVertex(int level, String name)
/*    */   {
/* 75 */     Set factories = (Set)this.levelFactories.get(Integer.valueOf(level));
/* 76 */     if (factories == null) {
/* 77 */       throw new IllegalArgumentException("No matching level factories: " + name + " / " + level);
/*    */     }
/* 79 */     for (LevelVertexFactory factory : factories)
/*    */     {
/* 81 */       TreeVertex vertex = factory.createVertex(name);
/* 82 */       if (vertex != null)
/* 83 */         return vertex;
/*    */     }
/* 85 */     throw new IllegalArgumentException("No matching level factory: " + name + " / " + level);
/*    */   }
/*    */ 
/*    */   public TreeVertex valueVertex(String value)
/*    */   {
/* 90 */     return new ValueVertex(value);
/*    */   }
/*    */ 
/*    */   public Visitor<String> visitor()
/*    */   {
/* 95 */     return new Visitor()
/*    */     {
/*    */       public void visit(Graph<String> g, Vertex<String> v)
/*    */       {
/* 99 */         if (DefaultVertexFactory.this.logger.isTraceEnabled())
/* 100 */           DefaultVertexFactory.this.logger.trace(v);
/*    */       }
/*    */     };
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.props.vertex.DefaultVertexFactory
 * JD-Core Version:    0.6.0
 */