/*     */ package org.jboss.kernel.plugins.deployment.props;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.graph.Edge;
/*     */ import org.jboss.util.graph.Vertex;
/*     */ 
/*     */ public abstract class TreeVertex<T extends Vertex<String>> extends Vertex<String>
/*     */ {
/*  41 */   protected Logger log = Logger.getLogger(getClass());
/*     */   private String lastToken;
/*     */ 
/*     */   protected TreeVertex(String name)
/*     */   {
/*  47 */     super(name);
/*     */   }
/*     */ 
/*     */   public void visit()
/*     */   {
/*  53 */     Vertex parent = getParent(this);
/*  54 */     Set children = getChildren(this);
/*     */ 
/*  56 */     if (this.log.isTraceEnabled()) {
/*  57 */       this.log.trace("Structure visit, parent: " + parent + ", children: " + children);
/*     */     }
/*  59 */     visit(parent, children);
/*     */   }
/*     */ 
/*     */   protected String getLastToken()
/*     */   {
/*  69 */     if (this.lastToken == null)
/*     */     {
/*  71 */       String fullName = getName();
/*  72 */       int p = fullName.lastIndexOf('.') + 1;
/*  73 */       this.lastToken = fullName.substring(p);
/*     */     }
/*  75 */     return this.lastToken;
/*     */   }
/*     */ 
/*     */   protected static Vertex<String> getParent(Vertex<String> vertex)
/*     */   {
/*  87 */     List edges = vertex.getIncomingEdges();
/*     */ 
/*  89 */     Vertex parent = null;
/*  90 */     if (!edges.isEmpty())
/*     */     {
/*  92 */       Set previous = new HashSet();
/*  93 */       for (Edge edge : edges) {
/*  94 */         previous.add(edge.getFrom());
/*     */       }
/*  96 */       if (previous.size() > 1) {
/*  97 */         throw new IllegalArgumentException("Multiple parents: " + vertex);
/*     */       }
/*  99 */       return (Vertex)previous.iterator().next();
/*     */     }
/* 101 */     return parent;
/*     */   }
/*     */ 
/*     */   protected static Set<Vertex<String>> getChildren(Vertex<String> vertex)
/*     */   {
/* 112 */     Set children = new HashSet();
/* 113 */     for (int i = 0; i < vertex.getOutgoingEdgeCount(); i++)
/*     */     {
/* 115 */       Edge edge = vertex.getOutgoingEdge(i);
/* 116 */       children.add(edge.getTo());
/*     */     }
/* 118 */     return children;
/*     */   }
/*     */ 
/*     */   protected static Vertex<String> getPrevious(Vertex<String> vertex)
/*     */   {
/* 129 */     return getParent(vertex);
/*     */   }
/*     */ 
/*     */   protected static Vertex<String> getNext(Vertex<String> vertex)
/*     */   {
/* 140 */     Set children = getChildren(vertex);
/*     */ 
/* 142 */     if (children.isEmpty()) {
/* 143 */       return null;
/*     */     }
/* 145 */     if (children.size() > 1) {
/* 146 */       throw new IllegalArgumentException("Multiple children: " + vertex);
/*     */     }
/* 148 */     return (Vertex)children.iterator().next();
/*     */   }
/*     */ 
/*     */   public abstract void visit(T paramT, Set<Vertex<String>> paramSet);
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.props.TreeVertex
 * JD-Core Version:    0.6.0
 */