/*    */ package org.jboss.kernel.plugins.deployment;
/*    */ 
/*    */ import java.util.List;
/*    */ import java.util.ListIterator;
/*    */ import java.util.concurrent.CopyOnWriteArrayList;
/*    */ import org.jboss.dependency.spi.ControllerMode;
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.kernel.spi.deployment.KernelDeployment;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class BasicKernelDeployer extends AbstractKernelDeployer
/*    */ {
/* 45 */   private static final Logger log = Logger.getLogger(BasicKernelDeployer.class);
/*    */ 
/* 48 */   protected List<KernelDeployment> deployments = new CopyOnWriteArrayList();
/*    */ 
/*    */   public BasicKernelDeployer(Kernel kernel)
/*    */   {
/* 57 */     this(kernel, null);
/*    */   }
/*    */ 
/*    */   public BasicKernelDeployer(Kernel kernel, ControllerMode mode)
/*    */   {
/* 68 */     super(kernel, mode);
/*    */   }
/*    */ 
/*    */   public void deploy(KernelDeployment deployment) throws Throwable
/*    */   {
/* 73 */     boolean trace = log.isTraceEnabled();
/* 74 */     if (trace)
/* 75 */       log.trace("Deploying " + deployment);
/* 76 */     super.deploy(deployment);
/* 77 */     this.deployments.add(deployment);
/* 78 */     if (trace)
/* 79 */       log.trace("Deployed " + deployment);
/*    */   }
/*    */ 
/*    */   public void undeploy(KernelDeployment deployment)
/*    */   {
/* 84 */     boolean trace = log.isTraceEnabled();
/* 85 */     if (trace)
/* 86 */       log.trace("Undeploying " + deployment);
/* 87 */     this.deployments.remove(deployment);
/* 88 */     super.undeploy(deployment);
/* 89 */     if (trace)
/* 90 */       log.trace("Undeployed " + deployment);
/*    */   }
/*    */ 
/*    */   public void shutdown()
/*    */   {
/* 98 */     ListIterator iterator = this.deployments.listIterator(this.deployments.size());
/* 99 */     while (iterator.hasPrevious())
/*    */     {
/* 101 */       KernelDeployment deployment = (KernelDeployment)iterator.previous();
/* 102 */       undeploy(deployment);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.BasicKernelDeployer
 * JD-Core Version:    0.6.0
 */