/*     */ package org.jboss.kernel.plugins.deployment;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.ListIterator;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.kernel.spi.deployment.KernelDeployment;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AbstractKernelDeployer
/*     */ {
/*  57 */   private static final Logger log = Logger.getLogger(AbstractKernelDeployer.class);
/*     */   protected Kernel kernel;
/*     */   protected KernelController controller;
/*     */   protected ControllerState requiredState;
/*     */   protected ControllerMode mode;
/*     */ 
/*     */   public AbstractKernelDeployer(Kernel kernel)
/*     */   {
/*  78 */     this(kernel, null, null);
/*     */   }
/*     */ 
/*     */   public AbstractKernelDeployer(Kernel kernel, ControllerMode mode)
/*     */   {
/*  89 */     this(kernel, null, mode);
/*     */   }
/*     */ 
/*     */   public AbstractKernelDeployer(Kernel kernel, ControllerState requiredState, ControllerMode mode)
/*     */   {
/* 101 */     if (kernel == null)
/* 102 */       throw new IllegalArgumentException("Null kernel");
/* 103 */     this.kernel = kernel;
/* 104 */     PrivilegedAction action = new PrivilegedAction(kernel)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 108 */         AbstractKernelDeployer.this.controller = this.val$kernel.getController();
/* 109 */         return null;
/*     */       }
/*     */     };
/* 112 */     AccessController.doPrivileged(action);
/* 113 */     this.requiredState = requiredState;
/* 114 */     this.mode = mode;
/*     */   }
/*     */ 
/*     */   public void deploy(KernelDeployment deployment)
/*     */     throws Throwable
/*     */   {
/* 125 */     if (deployment.isInstalled()) {
/* 126 */       throw new IllegalArgumentException("Already installed " + deployment.getName());
/*     */     }
/*     */     try
/*     */     {
/* 130 */       deployBeans(this.controller, deployment);
/* 131 */       deployment.setInstalled(true);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 135 */       undeploy(deployment);
/* 136 */       throw t;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void change(KernelDeployment deployment, ControllerState state)
/*     */     throws Throwable
/*     */   {
/* 149 */     if (!deployment.isInstalled()) {
/* 150 */       throw new IllegalStateException("Not installed " + deployment.getName());
/*     */     }
/* 152 */     changeBeans(this.controller, deployment, state);
/*     */   }
/*     */ 
/*     */   public void undeploy(KernelDeployment deployment)
/*     */   {
/* 162 */     undeployBeans(this.controller, deployment);
/* 163 */     deployment.setInstalled(false);
/*     */   }
/*     */ 
/*     */   public void validate()
/*     */     throws Throwable
/*     */   {
/* 173 */     Set notInstalled = this.controller.getNotInstalled();
/* 174 */     internalValidate(notInstalled);
/*     */   }
/*     */ 
/*     */   public void validate(KernelDeployment deployment)
/*     */     throws Throwable
/*     */   {
/* 185 */     Set notInstalled = new HashSet(deployment.getInstalledContexts());
/* 186 */     internalValidate(notInstalled);
/*     */   }
/*     */ 
/*     */   protected void internalValidate(Set<ControllerContext> notInstalled)
/*     */     throws Throwable
/*     */   {
/* 197 */     if (!notInstalled.isEmpty())
/*     */     {
/* 199 */       for (Iterator i = notInstalled.iterator(); i.hasNext(); )
/*     */       {
/* 201 */         ControllerContext context = (ControllerContext)i.next();
/* 202 */         if (context.getState().equals(context.getRequiredState()))
/* 203 */           i.remove();
/*     */       }
/* 205 */       if (!notInstalled.isEmpty())
/*     */       {
/* 207 */         HashSet errors = new HashSet();
/* 208 */         HashSet incomplete = new HashSet();
/* 209 */         for (ControllerContext ctx : notInstalled)
/*     */         {
/* 211 */           if (ctx.getState().equals(ControllerState.ERROR))
/* 212 */             errors.add(ctx);
/*     */           else
/* 214 */             incomplete.add(ctx);
/*     */         }
/* 216 */         JBossStringBuilder buffer = new JBossStringBuilder();
/* 217 */         buffer.append("Incompletely deployed:\n");
/* 218 */         if (errors.size() != 0)
/*     */         {
/* 220 */           buffer.append("\n*** DEPLOYMENTS IN ERROR: Name -> Error\n");
/* 221 */           for (ControllerContext ctx : errors)
/*     */           {
/* 223 */             buffer.append(ctx.getName()).append(" -> ").append(ctx.getError().toString()).append('\n');
/*     */           }
/*     */         }
/* 226 */         if (incomplete.size() != 0)
/*     */         {
/* 228 */           buffer.append("\n*** DEPLOYMENTS MISSING DEPENDENCIES: Name -> Dependency{Required State:Actual State}\n");
/* 229 */           for (ControllerContext ctx : incomplete)
/*     */           {
/* 231 */             buffer.append(ctx.getName()).append(" -> ");
/* 232 */             DependencyInfo dependsInfo = ctx.getDependencyInfo();
/* 233 */             Set depends = dependsInfo.getIDependOn(null);
/* 234 */             for (Iterator j = depends.iterator(); j.hasNext(); )
/*     */             {
/* 236 */               DependencyItem item = (DependencyItem)j.next();
/* 237 */               buffer.append(item.getIDependOn()).append('{').append(item.getWhenRequired().getStateString());
/* 238 */               buffer.append(':');
/* 239 */               Object iDependOn = item.getIDependOn();
/* 240 */               if (iDependOn == null)
/*     */               {
/* 243 */                 buffer.append("** UNRESOLVED " + item + " **");
/*     */               }
/*     */               else
/*     */               {
/* 247 */                 ControllerContext other = this.controller.getContext(item.getIDependOn(), null);
/* 248 */                 if (other == null)
/* 249 */                   buffer.append("** NOT FOUND **");
/*     */                 else
/* 251 */                   buffer.append(other.getState().getStateString());
/*     */               }
/* 253 */               buffer.append('}');
/* 254 */               if (j.hasNext())
/* 255 */                 buffer.append(", ");
/*     */             }
/* 257 */             buffer.append('\n');
/*     */           }
/*     */         }
/* 260 */         throw new IllegalStateException(buffer.toString());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void deployBeans(KernelController controller, KernelDeployment deployment)
/*     */     throws Throwable
/*     */   {
/* 274 */     List beans = deployment.getBeans();
/* 275 */     if (beans != null)
/*     */     {
/* 277 */       for (BeanMetaData metaData : beans)
/*     */       {
/* 279 */         KernelControllerContext context = deployBean(controller, deployment, metaData);
/* 280 */         deployment.addInstalledContext(context);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected KernelControllerContext deployBean(KernelController controller, KernelDeployment deployment, BeanMetaData bean)
/*     */     throws Throwable
/*     */   {
/* 296 */     KernelControllerContext context = new AbstractKernelControllerContext(null, bean, null);
/* 297 */     if (this.requiredState != null)
/* 298 */       context.setRequiredState(this.requiredState);
/* 299 */     if (this.mode != null) {
/* 300 */       context.setMode(this.mode);
/*     */     }
/* 302 */     ClassLoaderMetaData beanClassLoader = bean.getClassLoader();
/* 303 */     if ((beanClassLoader == null) && (deployment != null))
/*     */     {
/* 305 */       ClassLoaderMetaData deploymentClassLoader = deployment.getClassLoader();
/* 306 */       if (deploymentClassLoader != null)
/* 307 */         bean.setClassLoader(deploymentClassLoader);
/*     */     }
/* 309 */     controller.install(context);
/* 310 */     return context;
/*     */   }
/*     */ 
/*     */   protected void changeBeans(KernelController controller, KernelDeployment deployment, ControllerState state)
/*     */     throws Throwable
/*     */   {
/* 323 */     List contexts = deployment.getInstalledContexts();
/* 324 */     if (contexts != null)
/*     */     {
/* 326 */       for (KernelControllerContext context : contexts)
/*     */       {
/* 328 */         changeBean(controller, context, state);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void changeBean(KernelController controller, KernelControllerContext context, ControllerState state)
/*     */     throws Throwable
/*     */   {
/* 343 */     if ((ControllerMode.MANUAL.equals(context.getMode())) && (!ControllerState.ERROR.equals(context.getState())))
/* 344 */       controller.change(context, state);
/*     */   }
/*     */ 
/*     */   protected void undeployBeans(KernelController controller, KernelDeployment deployment)
/*     */   {
/* 355 */     List contexts = deployment.getInstalledContexts();
/*     */     ListIterator i;
/* 356 */     if (!contexts.isEmpty())
/*     */     {
/* 358 */       for (i = contexts.listIterator(contexts.size()); i.hasPrevious(); )
/*     */       {
/* 360 */         KernelControllerContext context = (KernelControllerContext)i.previous();
/*     */         try
/*     */         {
/* 363 */           undeployBean(controller, context);
/* 364 */           deployment.removeInstalledContext(context);
/*     */         }
/*     */         catch (Throwable ignored)
/*     */         {
/* 368 */           log.warn("Ignored error during uninstall of " + context, ignored);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void undeployBean(KernelController controller, KernelControllerContext context)
/*     */     throws Throwable
/*     */   {
/* 383 */     if (!controller.isShutdown())
/* 384 */       controller.uninstall(context.getName());
/*     */     else
/* 386 */       log.debug("Not undeploying " + context.getName() + " the controller is shutdown!");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.AbstractKernelDeployer
 * JD-Core Version:    0.6.0
 */