/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import org.jboss.dependency.plugins.AbstractController;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.KernelFactory;
/*     */ import org.jboss.kernel.plugins.bootstrap.basic.BasicKernelInitializer;
/*     */ import org.jboss.kernel.plugins.config.property.PropertyKernelConfig;
/*     */ import org.jboss.kernel.spi.bootstrap.KernelInitializer;
/*     */ import org.jboss.kernel.spi.config.KernelConfig;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.kernel.spi.event.KernelEvent;
/*     */ import org.jboss.kernel.spi.event.KernelEventFilter;
/*     */ import org.jboss.kernel.spi.event.KernelEventListener;
/*     */ import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryEntry;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
/*     */ 
/*     */ public class ScopedKernelController extends AbstractKernelController
/*     */ {
/*     */   protected Kernel parentKernel;
/*     */ 
/*     */   public ScopedKernelController(Kernel parentKernel, AbstractController parentController)
/*     */     throws Exception
/*     */   {
/*  59 */     this.parentKernel = parentKernel;
/*  60 */     if (!(parentKernel.getController() instanceof AbstractController))
/*  61 */       throw new IllegalArgumentException("Underlying controller not AbstractController instance!");
/*  62 */     setUnderlyingController((AbstractController)parentKernel.getController());
/*  63 */     setParentController(parentController);
/*  64 */     KernelConfig config = new ScopedKernelConfig(System.getProperties());
/*  65 */     this.kernel = KernelFactory.newInstance(config);
/*  66 */     getParentController().addController(this);
/*     */   }
/*     */ 
/*     */   private boolean isParentKernelController()
/*     */   {
/*  71 */     return getParentController() instanceof KernelController;
/*     */   }
/*     */ 
/*     */   private KernelController getParentKernelController()
/*     */   {
/*  76 */     if (!isParentKernelController())
/*  77 */       throw new IllegalArgumentException("Illegal call to parent Controller, not of KernelController instance!");
/*  78 */     return (KernelController)getParentController();
/*     */   }
/*     */ 
/*     */   void addControllerContext(KernelControllerContext context)
/*     */   {
/*  85 */     super.addControllerContext(context);
/*     */   }
/*     */ 
/*     */   void removeControllerContext(KernelControllerContext context)
/*     */   {
/*  90 */     super.removeControllerContext(context);
/*     */   }
/*     */ 
/*     */   void release()
/*     */   {
/*  95 */     getParentController().removeController(this);
/*  96 */     setUnderlyingController(null);
/*  97 */     setParentController(null);
/*  98 */     this.parentKernel = null;
/*     */   }
/*     */ 
/*     */   public ControllerContext getContext(Object name, ControllerState state)
/*     */   {
/* 105 */     ControllerContext context = super.getContext(name, state);
/* 106 */     if (context != null)
/*     */     {
/* 108 */       return context;
/*     */     }
/* 110 */     return getParentController().getContext(name, state);
/*     */   }
/*     */ 
/*     */   public Set<ControllerContext> getNotInstalled()
/*     */   {
/* 115 */     Set uninstalled = new HashSet(getParentController().getNotInstalled());
/* 116 */     uninstalled.addAll(super.getNotInstalled());
/* 117 */     return uninstalled;
/*     */   }
/*     */ 
/*     */   protected void install(ControllerContext context, boolean trace) throws Throwable
/*     */   {
/* 122 */     throw new IllegalArgumentException("Should not be called!");
/*     */   }
/*     */ 
/*     */   public void fireKernelEvent(KernelEvent event)
/*     */   {
/* 129 */     if (isParentKernelController())
/*     */     {
/* 131 */       getParentKernelController().fireKernelEvent(event);
/*     */     }
/*     */     else
/*     */     {
/* 135 */       super.fireKernelEvent(event);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void registerListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable
/*     */   {
/* 141 */     if (isParentKernelController())
/*     */     {
/* 143 */       getParentKernelController().registerListener(listener, filter, handback);
/*     */     }
/*     */     else
/*     */     {
/* 147 */       super.registerListener(listener, filter, handback);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void unregisterListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable
/*     */   {
/* 153 */     if (isParentKernelController())
/*     */     {
/* 155 */       getParentKernelController().unregisterListener(listener, filter, handback);
/*     */     }
/*     */     else
/*     */     {
/* 159 */       super.unregisterListener(listener, filter, handback);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Set<KernelControllerContext> getInstantiatedContexts(Class clazz)
/*     */   {
/* 165 */     lockRead();
/*     */     try
/*     */     {
/* 168 */       Set contexts = new HashSet();
/* 169 */       Set currentContexts = super.getInstantiatedContexts(clazz);
/* 170 */       if ((currentContexts != null) && (currentContexts.size() > 0))
/*     */       {
/* 172 */         contexts.addAll(currentContexts);
/*     */       }
/* 174 */       if (isParentKernelController())
/*     */       {
/* 176 */         parentContexts = getParentKernelController().getInstantiatedContexts(clazz);
/* 177 */         if ((parentContexts != null) && (parentContexts.size() > 0))
/*     */         {
/* 179 */           contexts.addAll(parentContexts);
/*     */         }
/*     */       }
/* 182 */       Set parentContexts = contexts.size() > 0 ? contexts : null;
/*     */       return parentContexts; } finally { unlockRead(); } throw localObject;
/*     */   }
/*     */ 
/*     */   public Set<KernelControllerContext> getContexts(Class clazz, ControllerState state)
/*     */   {
/* 191 */     lockRead();
/*     */     try
/*     */     {
/* 194 */       Set contexts = new HashSet();
/* 195 */       Set currentContexts = super.getContexts(clazz, state);
/* 196 */       if ((currentContexts != null) && (currentContexts.size() > 0))
/*     */       {
/* 198 */         contexts.addAll(currentContexts);
/*     */       }
/* 200 */       if (isParentKernelController())
/*     */       {
/* 202 */         parentContexts = getParentKernelController().getContexts(clazz, state);
/* 203 */         if ((parentContexts != null) && (parentContexts.size() > 0))
/*     */         {
/* 205 */           contexts.addAll(parentContexts);
/*     */         }
/*     */       }
/* 208 */       Set parentContexts = contexts.size() > 0 ? contexts : null;
/*     */       return parentContexts; } finally { unlockRead(); } throw localObject;
/*     */   }
/*     */ 
/*     */   public KernelRegistryEntry getEntry(Object name)
/*     */   {
/* 221 */     KernelRegistryEntry entry = super.getEntry(name);
/* 222 */     if (entry != null)
/* 223 */       return entry;
/* 224 */     if ((getParentController() instanceof KernelRegistryPlugin))
/*     */     {
/* 226 */       return ((KernelRegistryPlugin)getParentController()).getEntry(name);
/*     */     }
/* 228 */     return null;
/*     */   }
/*     */ 
/*     */   private class ScopedKernelInitializer extends BasicKernelInitializer
/*     */   {
/*     */     public ScopedKernelInitializer()
/*     */       throws Exception
/*     */     {
/*     */     }
/*     */ 
/*     */     protected KernelConfigurator createKernelConfigurator(Kernel kernel)
/*     */       throws Throwable
/*     */     {
/* 260 */       return ScopedKernelController.this.parentKernel.getConfigurator();
/*     */     }
/*     */ 
/*     */     protected KernelController createKernelController(Kernel kernel) throws Throwable
/*     */     {
/* 265 */       return ScopedKernelController.this;
/*     */     }
/*     */ 
/*     */     protected KernelMetaDataRepository createKernelMetaDataRepository(Kernel kernel) throws Throwable
/*     */     {
/* 270 */       return ScopedKernelController.this.parentKernel.getMetaDataRepository();
/*     */     }
/*     */   }
/*     */ 
/*     */   private class ScopedKernelConfig extends PropertyKernelConfig
/*     */   {
/*     */     public ScopedKernelConfig(Properties properties)
/*     */     {
/* 237 */       super();
/*     */     }
/*     */ 
/*     */     public KernelInitializer createKernelInitializer() throws Throwable
/*     */     {
/* 242 */       return new ScopedKernelController.ScopedKernelInitializer(ScopedKernelController.this);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.ScopedKernelController
 * JD-Core Version:    0.6.0
 */