/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.dependency.plugins.AbstractController;
/*     */ import org.jboss.dependency.spi.ScopeInfo;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.MutableMetaData;
/*     */ import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataItem;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.scope.Scope;
/*     */ import org.jboss.metadata.spi.scope.ScopeFactory;
/*     */ import org.jboss.metadata.spi.scope.ScopeFactoryLookup;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ 
/*     */ public class PreInstallAction extends KernelControllerContextAction
/*     */ {
/*     */   protected void installActionInternal(KernelControllerContext context)
/*     */     throws Throwable
/*     */   {
/*  55 */     KernelController controller = (KernelController)context.getController();
/*  56 */     Kernel kernel = controller.getKernel();
/*  57 */     KernelConfigurator configurator = kernel.getConfigurator();
/*     */ 
/*  59 */     BeanMetaData metaData = context.getBeanMetaData();
/*  60 */     if (metaData.getBean() != null)
/*     */     {
/*  62 */       BeanInfo info = configurator.getBeanInfo(metaData);
/*  63 */       context.setBeanInfo(info);
/*     */ 
/*  65 */       KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
/*  66 */       repository.addMetaData(context);
/*     */       try
/*     */       {
/*  69 */         applyScoping(context);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/*  73 */         removeMetaData(context);
/*  74 */         throw t;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected ScopeKey getInstallScopeKey(KernelControllerContext context, KernelController controller, KernelMetaDataRepository repository)
/*     */     throws Throwable
/*     */   {
/*  85 */     MetaData retrieval = repository.getMetaData(context);
/*  86 */     if (retrieval != null)
/*     */     {
/*  88 */       Annotation[] annotations = retrieval.getAnnotations();
/*  89 */       if ((annotations != null) && (annotations.length > 0))
/*     */       {
/*  91 */         Collection scopes = new HashSet();
/*  92 */         for (Annotation annotation : annotations)
/*     */         {
/*  94 */           if (!annotation.annotationType().isAnnotationPresent(ScopeFactoryLookup.class))
/*     */             continue;
/*  96 */           ScopeFactoryLookup sfl = (ScopeFactoryLookup)annotation.annotationType().getAnnotation(ScopeFactoryLookup.class);
/*  97 */           Scope scope = ((ScopeFactory)sfl.value().newInstance()).create(annotation);
/*  98 */           scopes.add(scope);
/*     */         }
/*     */ 
/* 101 */         if (scopes.size() > 0)
/*     */         {
/* 103 */           return new ScopeKey(scopes);
/*     */         }
/*     */       }
/*     */     }
/* 107 */     return null;
/*     */   }
/*     */ 
/*     */   protected void applyScoping(KernelControllerContext context) throws Throwable
/*     */   {
/* 112 */     KernelController controller = (KernelController)context.getController();
/* 113 */     KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
/* 114 */     ScopeKey scopeKey = getInstallScopeKey(context, controller, repository);
/* 115 */     if (scopeKey != null)
/*     */     {
/* 117 */       scopeKey.freeze();
/* 118 */       context.getScopeInfo().setInstallScope(scopeKey);
/*     */ 
/* 127 */       MutableMetaDataRepository mmdr = repository.getMetaDataRepository();
/* 128 */       MetaDataRetrieval mdr = mmdr.getMetaDataRetrieval(scopeKey);
/* 129 */       if (mdr == null)
/*     */       {
/* 131 */         mdr = new MemoryMetaDataLoader(scopeKey);
/* 132 */         mmdr.addMetaDataRetrieval(mdr);
/*     */       }
/* 134 */       MetaDataItem controllerItem = mdr.retrieveMetaData(ScopedKernelController.class);
/*     */       ScopedKernelController scopedController;
/*     */       ScopedKernelController scopedController;
/* 136 */       if (controllerItem != null)
/*     */       {
/* 138 */         scopedController = (ScopedKernelController)controllerItem.getValue();
/*     */       }
/*     */       else
/*     */       {
/* 142 */         AbstractController parentController = null;
/* 143 */         ScopeKey parentKey = scopeKey.getParent();
/* 144 */         while ((parentController == null) && (parentKey != null))
/*     */         {
/* 146 */           MetaDataRetrieval pmdr = mmdr.getMetaDataRetrieval(parentKey);
/* 147 */           if (pmdr != null)
/*     */           {
/* 149 */             MetaDataItem pci = pmdr.retrieveMetaData(ScopedKernelController.class);
/* 150 */             if (pci != null)
/*     */             {
/* 152 */               parentController = (AbstractController)pci.getValue();
/*     */             }
/*     */           }
/* 155 */           parentKey = parentKey.getParent();
/*     */         }
/* 157 */         if (parentController == null)
/*     */         {
/* 159 */           if (!(controller instanceof AbstractController))
/* 160 */             throw new IllegalArgumentException("Underlying controller not AbstractController instance!");
/* 161 */           parentController = (AbstractController)controller;
/*     */         }
/* 163 */         scopedController = new ScopedKernelController(controller.getKernel(), parentController);
/* 164 */         ((MutableMetaData)mdr).addMetaData(scopedController, ScopedKernelController.class);
/*     */       }
/* 166 */       scopedController.addControllerContext(context);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void removeScoping(KernelControllerContext context) throws Throwable
/*     */   {
/* 172 */     KernelController controller = (KernelController)context.getController();
/* 173 */     KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
/* 174 */     ScopeKey scopeKey = context.getScopeInfo().getInstallScope();
/* 175 */     if (scopeKey != null)
/*     */     {
/* 178 */       MutableMetaDataRepository mmdr = repository.getMetaDataRepository();
/* 179 */       MetaDataRetrieval mdr = mmdr.getMetaDataRetrieval(scopeKey);
/* 180 */       if (mdr == null)
/*     */       {
/* 182 */         throw new IllegalArgumentException("Expecting MetaDataRetrieval instance in scope: " + scopeKey);
/*     */       }
/* 184 */       MetaDataItem controllerItem = mdr.retrieveMetaData(ScopedKernelController.class);
/* 185 */       if (controllerItem == null)
/*     */       {
/* 187 */         throw new IllegalArgumentException("Expecting ScopedKernelController instance in scope:" + scopeKey);
/*     */       }
/* 189 */       ScopedKernelController scopedController = (ScopedKernelController)controllerItem.getValue();
/* 190 */       scopedController.removeControllerContext(context);
/* 191 */       if (!scopedController.isActive())
/*     */       {
/*     */         try
/*     */         {
/* 195 */           ((MutableMetaData)mdr).removeMetaData(ScopedKernelController.class);
/*     */         }
/*     */         finally
/*     */         {
/* 199 */           scopedController.release();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void uninstallActionInternal(KernelControllerContext context)
/*     */   {
/*     */     try
/*     */     {
/* 209 */       removeScoping(context);
/*     */     }
/*     */     catch (Throwable ignored)
/*     */     {
/* 213 */       this.log.warn("Unexpected error removing scoping: ", ignored);
/*     */     }
/*     */     finally
/*     */     {
/* 217 */       removeMetaData(context);
/* 218 */       context.setBeanInfo(null);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void removeMetaData(KernelControllerContext context)
/*     */   {
/*     */     try
/*     */     {
/* 231 */       KernelController controller = (KernelController)context.getController();
/* 232 */       KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
/* 233 */       repository.removeMetaData(context);
/*     */     }
/*     */     catch (Throwable ignored)
/*     */     {
/* 237 */       this.log.warn("Unexpected error removing metadata: ", ignored);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.PreInstallAction
 * JD-Core Version:    0.6.0
 */