/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.security.AccessControlContext;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.dependency.plugins.action.SimpleControllerContextAction;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ScopeInfo;
/*     */ import org.jboss.joinpoint.spi.Joinpoint;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
/*     */ import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.stack.MetaDataStack;
/*     */ 
/*     */ public class KernelControllerContextAction extends SimpleControllerContextAction<KernelControllerContext>
/*     */ {
/*  51 */   private static final Logger staticLog = Logger.getLogger(KernelControllerContextAction.class);
/*     */   protected Logger log;
/*     */ 
/*     */   public KernelControllerContextAction()
/*     */   {
/*  56 */     this.log = Logger.getLogger(getClass());
/*     */   }
/*     */ 
/*     */   static Object dispatchJoinPoint(KernelControllerContext context, Joinpoint joinpoint)
/*     */     throws Throwable
/*     */   {
/*  68 */     ExecutionWrapper wrapper = new JoinpointDispatchWrapper(joinpoint);
/*  69 */     return dispatchExecutionWrapper(context, wrapper);
/*     */   }
/*     */ 
/*     */   static Object dispatchExecutionWrapper(KernelControllerContext context, ExecutionWrapper wrapper)
/*     */     throws Throwable
/*     */   {
/*  82 */     BeanMetaData metaData = context.getBeanMetaData();
/*  83 */     ClassLoader cl = Configurator.getClassLoader(metaData);
/*  84 */     AccessControlContext access = null;
/*  85 */     if ((context instanceof AbstractKernelControllerContext))
/*     */     {
/*  87 */       AbstractKernelControllerContext theContext = (AbstractKernelControllerContext)context;
/*  88 */       access = theContext.getAccessControlContext();
/*     */     }
/*     */ 
/*  91 */     KernelController controller = (KernelController)context.getController();
/*  92 */     KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
/*  93 */     MetaData md = repository.getMetaData(context);
/*  94 */     if (md != null)
/*  95 */       MetaDataStack.push(md);
/*     */     else {
/*  97 */       staticLog.warn("NO METADATA! for " + context.getName() + " with scope " + context.getScopeInfo().getScope());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 102 */       ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/*     */       try
/*     */       {
/* 105 */         if ((cl != null) && (access == null)) {
/* 106 */           Thread.currentThread().setContextClassLoader(cl);
/*     */         }
/* 108 */         Object localObject1 = wrapper.execute(access);
/*     */ 
/* 112 */         if ((cl != null) && (access == null)) {
/* 113 */           Thread.currentThread().setContextClassLoader(tcl);
/*     */         }
/*     */ 
/* 118 */         if (md != null)
/* 119 */           MetaDataStack.pop(); return localObject1;
/*     */       }
/*     */       finally
/*     */       {
/* 112 */         if ((cl != null) && (access == null))
/* 113 */           Thread.currentThread().setContextClassLoader(tcl);
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 118 */       if (md != null)
/* 119 */         MetaDataStack.pop(); 
/* 119 */     }throw localObject3;
/*     */   }
/*     */ 
/*     */   protected boolean validateContext(ControllerContext context)
/*     */   {
/* 125 */     return context instanceof AbstractKernelControllerContext;
/*     */   }
/*     */ 
/*     */   protected KernelControllerContext contextCast(ControllerContext context)
/*     */   {
/* 130 */     return (KernelControllerContext)KernelControllerContext.class.cast(context);
/*     */   }
/*     */ 
/*     */   public void installAction(KernelControllerContext context) throws Throwable
/*     */   {
/* 135 */     installActionInternal(context);
/* 136 */     setKernelControllerContext(context);
/*     */   }
/*     */ 
/*     */   private void setKernelControllerContext(KernelControllerContext context) throws Throwable
/*     */   {
/* 141 */     Object target = context.getTarget();
/* 142 */     if (target != null)
/*     */     {
/* 144 */       Class awareInterface = getActionAwareInterface();
/*     */ 
/* 146 */       if ((awareInterface != null) && (!awareInterface.equals(KernelControllerContextAware.class)) && (awareInterface.isAssignableFrom(target.getClass())))
/*     */       {
/* 150 */         ((KernelControllerContextAware)target).setKernelControllerContext(context);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void installActionInternal(KernelControllerContext context) throws Throwable
/*     */   {
/*     */   }
/*     */ 
/*     */   protected Class<? extends KernelControllerContextAware> getActionAwareInterface()
/*     */   {
/* 161 */     return null;
/*     */   }
/*     */ 
/*     */   public void uninstallAction(KernelControllerContext context)
/*     */   {
/* 166 */     unsetKernelControllerContext(context);
/* 167 */     uninstallActionInternal(context);
/*     */   }
/*     */ 
/*     */   protected void uninstallActionInternal(KernelControllerContext context)
/*     */   {
/*     */   }
/*     */ 
/*     */   private void unsetKernelControllerContext(KernelControllerContext context)
/*     */   {
/* 176 */     Object target = context.getTarget();
/*     */ 
/* 178 */     if (target != null)
/*     */     {
/* 180 */       Class awareInterface = getActionAwareInterface();
/*     */ 
/* 182 */       if ((awareInterface != null) && (!awareInterface.equals(KernelControllerContextAware.class)) && (awareInterface.isAssignableFrom(target.getClass())))
/*     */       {
/*     */         try
/*     */         {
/* 188 */           ((KernelControllerContextAware)target).unsetKernelControllerContext(context);
/*     */         }
/*     */         catch (Exception ignored)
/*     */         {
/* 192 */           this.log.debug("Ignored error unsetting context " + context.getName(), ignored);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class JoinpointDispatchWrapper extends ExecutionWrapper
/*     */   {
/*     */     private Joinpoint joinpoint;
/*     */ 
/*     */     public JoinpointDispatchWrapper(Joinpoint joinpoint)
/*     */     {
/* 207 */       if (joinpoint == null)
/* 208 */         throw new IllegalArgumentException("Null joinpoint");
/* 209 */       this.joinpoint = joinpoint;
/*     */     }
/*     */ 
/*     */     protected Object execute() throws Throwable
/*     */     {
/* 214 */       return this.joinpoint.dispatch();
/*     */     }
/*     */ 
/*     */     protected PrivilegedExceptionAction<Object> getAction()
/*     */     {
/* 219 */       return new DispatchJoinPoint(this.joinpoint);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.KernelControllerContextAction
 * JD-Core Version:    0.6.0
 */