/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.util.List;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.InstallMetaData;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.dispatch.InvokeDispatchHelper;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.kernel.spi.dependency.InstallKernelControllerContextAware;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistry;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class InstallAction extends KernelControllerContextAction
/*     */ {
/*     */   protected void installActionInternal(KernelControllerContext context)
/*     */     throws Throwable
/*     */   {
/*  49 */     KernelController controller = (KernelController)context.getController();
/*  50 */     Kernel kernel = controller.getKernel();
/*  51 */     KernelRegistry registry = kernel.getRegistry();
/*  52 */     KernelConfigurator configurator = kernel.getConfigurator();
/*     */ 
/*  54 */     BeanMetaData metaData = context.getBeanMetaData();
/*  55 */     Object name = metaData.getName();
/*  56 */     registry.registerEntry(name, context);
/*  57 */     controller.addSupplies(context);
/*     */ 
/*  59 */     List installs = metaData.getInstalls();
/*  60 */     if (installs != null)
/*     */     {
/*  62 */       for (InstallMetaData install : installs)
/*     */       {
/*  64 */         ControllerContext target = context;
/*  65 */         if (install.getBean() != null)
/*  66 */           target = controller.getContext(install.getBean(), install.getDependentState());
/*  67 */         if ((target instanceof InvokeDispatchContext))
/*     */         {
/*  69 */           InvokeDispatchHelper.invoke(configurator, target.getTarget(), (InvokeDispatchContext)target, install.getMethodName(), install.getParameters());
/*     */         }
/*     */         else
/*     */         {
/*  79 */           throw new IllegalArgumentException("Cannot install, context " + target + " does not implement InvokeDispatchContext");
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Class<? extends KernelControllerContextAware> getActionAwareInterface()
/*     */   {
/*  87 */     return InstallKernelControllerContextAware.class;
/*     */   }
/*     */ 
/*     */   protected void uninstallActionInternal(KernelControllerContext context)
/*     */   {
/*  92 */     KernelController controller = (KernelController)context.getController();
/*  93 */     Kernel kernel = controller.getKernel();
/*  94 */     KernelRegistry registry = kernel.getRegistry();
/*  95 */     KernelConfigurator configurator = kernel.getConfigurator();
/*  96 */     BeanMetaData metaData = context.getBeanMetaData();
/*  97 */     Object name = metaData.getName();
/*     */ 
/*  99 */     List uninstalls = metaData.getUninstalls();
/* 100 */     if (uninstalls != null)
/*     */     {
/* 102 */       for (int i = uninstalls.size() - 1; i >= 0; i--)
/*     */       {
/* 104 */         InstallMetaData uninstall = (InstallMetaData)uninstalls.get(i);
/* 105 */         ControllerContext target = context;
/* 106 */         if (uninstall.getBean() != null)
/*     */         {
/* 108 */           target = controller.getContext(uninstall.getBean(), uninstall.getDependentState());
/* 109 */           if (target == null)
/*     */           {
/* 111 */             this.log.warn("Ignoring uninstall action on target in incorrect state " + uninstall.getBean());
/* 112 */             continue;
/*     */           }
/*     */         }
/* 115 */         if ((target instanceof InvokeDispatchContext))
/*     */         {
/*     */           try
/*     */           {
/* 119 */             InvokeDispatchHelper.invoke(configurator, target.getTarget(), (InvokeDispatchContext)target, uninstall.getMethodName(), uninstall.getParameters());
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/* 129 */             this.log.warn("Ignoring uninstall action on target " + uninstall, t);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 134 */           throw new IllegalArgumentException("Cannot uninstall, context " + target + " does not implement InvokeDispatchContext");
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 141 */       controller.removeSupplies(context);
/* 142 */       registry.unregisterEntry(name);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 146 */       this.log.warn("Ignoring unregistered entry at uninstall " + name);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.InstallAction
 * JD-Core Version:    0.6.0
 */