/*    */ package org.jboss.kernel.plugins.dependency;
/*    */ 
/*    */ import java.util.Collection;
/*    */ import org.jboss.dependency.spi.Cardinality;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
/*    */ 
/*    */ public abstract class CollectionCreatorCallbackItem<T extends Collection<Object>> extends CollectionCallbackItem<T>
/*    */ {
/*    */   protected CollectionCreator<T> creator;
/*    */ 
/*    */   public CollectionCreatorCallbackItem(CollectionCreator<T> creator, Class name, InvokeDispatchContext owner, AttributeInfo attribute)
/*    */   {
/* 42 */     this(creator, name, null, null, null, owner, attribute);
/*    */   }
/*    */ 
/*    */   public CollectionCreatorCallbackItem(CollectionCreator<T> creator, Class name, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality, InvokeDispatchContext context, AttributeInfo attribute)
/*    */   {
/* 47 */     super(name, whenRequired, dependentState, cardinality, context, attribute);
/* 48 */     if (creator == null)
/* 49 */       throw new IllegalArgumentException("Null creator!");
/* 50 */     this.creator = creator;
/*    */   }
/*    */ 
/*    */   protected T getCollectionParameterHolder()
/*    */   {
/* 55 */     return this.creator.createCollection();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.CollectionCreatorCallbackItem
 * JD-Core Version:    0.6.0
 */